

#ifndef PLANE_H
#define PLANE_H

#if _MSC_VER > 1000
# pragma once
#endif

//////////////////////////////////////////////////////////////////////
#include "PBvector.h"

//////////////////////////////////////////////////////////////////////
#define	NORMAL_EPSILON	0.0001f
#define	DIST_EPSILON	0.01f

#define MX 0
#define MY 1
#define MZ 2

//////////////////////////////////////////////////////////////////////
template<class T> class CPlane
{
public:
	 
	CPlane() 
	{		
		m_vNormal.Clear();				
		m_fDist=0;
		//m_Type=-1;
	};

	//! Initialize a plane giving normal and dist
	CPlane(const vector3<T> &vNormal,T fDist)
	{
		Set(vNormal,fDist);
	}

	vector3f Closest(const vector3<T> &vPoint);
	
	//! set normal and dist for this plane 
	void	Set(const vector3<T> &vNormal,T fDist)
	{	
		m_vNormal = vNormal; 
		m_fDist = fDist;	
	}

	//! calc the plane giving 3 points
	//! returns false for degenrated triangles
	bool	CalcPlane(const vector3<T> &p0,const vector3<T> &p1,const vector3<T> &p2);

	//! tell which side of the plane the box is
  int CalcBoxSide(const vector3<T> &vMins, const vector3<T> &vMaxs) const;

	//! invert plane's equation
	void	Invert();

	void	Normalize();

	//! check for equality between two planes
	inline  friend	bool operator ==(const CPlane<T> &p1, const CPlane<T> &p2)
  {
    if (Ffabs(p1.m_vNormal.x-p2.m_vNormal.x)>NORMAL_EPSILON) 
      return (false);
    if (Ffabs(p1.m_vNormal.y-p2.m_vNormal.y)>NORMAL_EPSILON) 
      return (false);
    if (Ffabs(p1.m_vNormal.z-p2.m_vNormal.z)>NORMAL_EPSILON) 
      return (false);
    
    if (Ffabs(p1.m_fDist-p2.m_fDist)<DIST_EPSILON) 
      return(true);
    return (false);
  }

	//! snap a plane to the nearest grid
	void	Snap();

	//! calc the distance from the plane to point p
	inline T DistFromPlane(const vector3<T> &vPoint)
	{		
		//return (m_vNormal*vPoint-m_fDist);
		return (m_vNormal*vPoint+m_fDist);
	}

	//! same as above for const members
	inline T	DistFromPlane(const vector3<T> &vPoint) const
	{		
		//return (m_vNormal*vPoint-m_fDist);
		return (m_vNormal*vPoint+m_fDist);
	}

	bool RayIntersect(const vector3<T> &vRayOrigin, const vector3<T> &vRayDir,T &fTime) const;
	bool LineStabsPlane(const vector3<T> &v1, const vector3<T> &v2,vector3<T> &vRes) const;

//protected: 
	
	vector3<T>	m_vNormal;
	T					m_fDist;	
	//char			m_Type;				
};


//////////////////////////////////////////////////////////////////////
typedef	CPlane<ftype> CPlanef;

#endif //plane