// MocapDoc.h : interface of the CMocapDoc class
//


#pragma once

#include "Tracking.h"

//////////////////////////////////////////////////////////////////////////
class CMocapDoc : public CDocument
{
protected: // create from serialization only
	CMocapDoc();
	DECLARE_DYNCREATE(CMocapDoc)

// Attributes
public:

// Operations
public:

// Overrides
public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

// Implementation
public:
	virtual ~CMocapDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void	EditMarkers(int x,int y,int event);

	bool				m_bEditMode;
	lstFeature	m_lstFeatures;

protected:

	bool	LoadData(CArchive& ar);

	const char *GetFilename(const char *szSrc);
	const char *GetPath(const char *szFilename);
	void	FixPath(char *szFilename);
	void	RemoveExtension(char *szPath);
	void	ReplaceExtension(char *szPath, const char *szExt);

	void	MyPerspective2(double fovx, double aspect, double zNear, double zFar,CCamera &cam);
	void	ProjectToScreen(const vector3f &vSource,vector3f &vDest,CCamera &cam);
	void	UnProjectFromScreen(const vector3f &vSource,vector3f &vDest,CCamera &cam);

	bool	SaveTGA(unsigned char *sourcedata,int sourceformat,int w,int h,const char *filename,bool flipimage,bool flipcolors);

	char				m_szBuffer[256];

	CvCapture		*m_input_video;
	IplImage		*m_pScreen;
	IplImage		*m_pScreenEdit;
	CvFont			m_font1;
	int					m_nMarkerSelected;
	bool				m_bEditOperation;
	
// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
};


