
#include "stdafx.h"
#include "Mocap.h"

#include "MocapDoc.h"

int dirs[9][2]={{0,0},{0,-1},{1,-1},{1,0},{1,1},{0,1},{-1,1},{-1,0},{-1,-1}};

int dirs55[25][2]={
	{-2,-2},{-1,-2},{0,-2},{1,-2},{2,-2},
	{-2,-1},{-1,-1},{0,-1},{1,-1},{2,-1},
	{-2,0},{-1,0},{0,0},{1,0},{2,0},
	{-2,1},{-1,1},{0,1},{1,1},{2,1},
	{-2,2},{-1,2},{0,2},{1,2},{2,2}
};

//////////////////////////////////////////////////////////////////////////
void CMocapDoc::MyPerspective2(double fovx, double aspect, double zNear, double zFar,CCamera &cam)
{
	double xmin, xmax, ymin, ymax;
	// NOTE: this is NOT an identity!
	double m[16] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

	xmax = zNear * tan(fovx * M_PI / 360.0);
	xmin = -xmax;

	ymin = (xmin / aspect);
	ymax = (xmax / aspect);

#define M(row,col)  m[col*4+row]

	// Set up the projection matrix
	M(0,0) = (2.0 * zNear) / (xmax - xmin);
	M(1,1) = (2.0 * zNear) / (ymax - ymin);
	M(2,2) = -(zFar + zNear) / (zFar - zNear);

	M(0,2) = (xmax + xmin) / (xmax - xmin);
	M(1,2) = (ymax + ymin) / (ymax - ymin);
	M(3,2) = -1.0;

	M(2,3) = -(2.0 * zFar * zNear) / (zFar - zNear);

#undef M	

	// Add to current matrix
	//glMultMatrixd(m);
	cam.m_ProjMatrix.Identity();
	cam.m_ProjMatrix.MultMatrixf(m);
}

/*
* Transform a point (column vector) by a 4x4 matrix.  I.e.  out = m * in
* Input:  m - the 4x4 matrix
*         in - the 4x1 vector
* Output:  out - the resulting 4x1 vector.
*/
static void
transform_point(double out[4], const double m[16], const double in[4])
{
#define M(row,col)  m[col*4+row]
	out[0] =
		M(0, 0) * in[0] + M(0, 1) * in[1] + M(0, 2) * in[2] + M(0, 3) * in[3];
	out[1] =
		M(1, 0) * in[0] + M(1, 1) * in[1] + M(1, 2) * in[2] + M(1, 3) * in[3];
	out[2] =
		M(2, 0) * in[0] + M(2, 1) * in[1] + M(2, 2) * in[2] + M(2, 3) * in[3];
	out[3] =
		M(3, 0) * in[0] + M(3, 1) * in[1] + M(3, 2) * in[2] + M(3, 3) * in[3];
#undef M
}

// projection du point (objx,objy,obz) sur l'ecran (winx,winy,winz) 
//////////////////////////////////////////////////////////////////////////
int MyProject(double objx, double objy, double objz,
							const double mview[16], int nViewport[4],											
							double * winx, double * winy, double * winz)
{
	// matrice de transformation 
	double in[4], out[4];
	//double	m[16];
	const double	*matptr;

	// initilise la matrice et le vecteur a transformer 
	in[0] = objx;
	in[1] = objy;
	in[2] = objz;
	in[3] = 1.0;
	//transform_point(out, model, in);
	//transform_point(in, proj, out);

	//transform_point(out, pCam->m_dGLViewMatrix, in);
	//transform_point(in, pCam->m_dGLProjMatrix, out);

	matptr=mview;

	transform_point(out, matptr, in);

	// d'ou le resultat normalise entre -1 et 1 
	if (out[3] == 0.0)
		return 0;

	out[0] /= out[3];
	out[1] /= out[3];
	out[2] /= out[3];

	// en coordonnees ecran 
	*winx = nViewport[0] + (1 + out[0]) * nViewport[2] / 2;
	*winy = nViewport[1] + (1 + out[1]) * nViewport[3] / 2;
	// entre 0 et 1 suivant z 
	*winz = (1 + out[2]) / 2;
	return 1;
}

//////////////////////////////////////////////////////////////////////////
int MyUnproject(double winx, double winy, double winz,
								const double invmview[16], int nViewport[4],											
								double * objx, double * objy, double * objz)
{
	// matrice de transformation 		
	double in[4], out[4];
	double z = winz; //nearZ + winz * (farZ - nearZ);	

	// transformation coordonnees normalisees entre -1 et 1 
	in[0] = (winx - nViewport[0]) * 2 / nViewport[2] - 1.0;
	in[1] = (winy - nViewport[1]) * 2 / nViewport[3] - 1.0;
	in[2] = 2.0 * z - 1.0;
	in[3] = 1.0f; //clipw;

	// calcul transformation inverse 
	const double *matptr=invmview;

	// d'ou les coordonnees objets 
	transform_point(out, matptr, in);
	if (out[3] == 0.0)
		return 0;
	*objx = out[0] / out[3];
	*objy = out[1] / out[3];
	*objz = out[2] / out[3];
	//*objw = out[3];
	return 1;
}


//////////////////////////////////////////////////////////////////////
void CMocapDoc::ProjectToScreen(const vector3f &vSource,vector3f &vDest,CCamera &cam)
{
	double dx,dy,dz;	

	MyProject(vSource.x,vSource.y,vSource.z,		
		&cam.m_Matrix.m_Tvalues[0][0],cam.m_nViewport,
		&dx,&dy,&dz);

	vDest.x=(ftype)(dx);
	vDest.y=(ftype)((cam.m_nViewport[3]-1)-dy);
	vDest.z=(ftype)(dz);
}

//////////////////////////////////////////////////////////////////////
void CMocapDoc::UnProjectFromScreen(const vector3f &vSource,vector3f &vDest,CCamera &cam)
{
	double dx,dy,dz;

	vector3f vTemp=vSource;
	vTemp.y=((cam.m_nViewport[3]-1)-vSource.y);

	MyUnproject(vTemp.x,vTemp.y,vTemp.z,&cam.m_MatrixInverted.m_Tvalues[0][0],cam.m_nViewport,&dx,&dy,&dz);		

	vDest.x=(ftype)(dx);vDest.y=(ftype)(dy);vDest.z=(ftype)(dz);	
}

//////////////////////////////////////////////////////////////////////////
//gets the filename without path
const char *CMocapDoc::GetFilename(const char *szSrc)
{
	//find the filename
	int nLen=(int)strlen(szSrc);
	//go at the end of the filename 
	const char *szPtr=szSrc+nLen-1;

	//move back till the first '/' or '\\'
	while (*szPtr && szPtr>szSrc)
	{
		if ((*szPtr=='/') || (*szPtr=='\\'))
		{
			//if character found, increment the 
			//string pointer to point to the correct position 
			//(first character after the '/') and stop the loop
			szPtr++; 
			break;
		}

		szPtr--;
	}		

	return (szPtr);
}

//gets the path
/////////////////////////////////////////////////////////////////////////////
const char *CMocapDoc::GetPath(const char *szFilename)
{	
	//extract the path		
	strcpy(m_szBuffer,szFilename);

	char *szSrc = m_szBuffer+strlen(m_szBuffer)-1;
	while (*szSrc && szSrc>m_szBuffer)
	{
		if (*szSrc=='\\' || *szSrc=='/')
		{ 
			szSrc++;
			*szSrc=0; //terminate the string here
			break;
		}
		szSrc--;
	}  

	return (m_szBuffer);
}

//removes extension from filename
//////////////////////////////////////////////////////////////////////
void CMocapDoc::RemoveExtension(char *szPath)
{
	char *szSrc=szPath+strlen(szPath)-1;
	while (*szSrc && szSrc>szPath && *szSrc!='/')
	{
		if (*szSrc=='.')
		{ 
			*szSrc=0; // remove extension 
			return;  
		}
		szSrc--;
	}
}

//replace filename extension
//////////////////////////////////////////////////////////////////////
void CMocapDoc::ReplaceExtension(char *szPath, const char *szExt)
{
	RemoveExtension(szPath);
	strcat(szPath,".");
	strcat(szPath,szExt);
}

//////////////////////////////////////////////////////////////////////////
//TGA
//////////////////////////////////////////////////////////////////////////
#pragma pack (push)
#pragma pack (1)
typedef struct
{
	unsigned char  id_length, colormap_type, image_type;
	unsigned short colormap_index, colormap_length;
	unsigned char  colormap_size;
	unsigned short x_origin, y_origin, width, height;
	unsigned char  pixel_size, attributes;
} TargaHeader_t;
#pragma pack (pop)


//////////////////////////////////////////////////////////////////////////
bool CMocapDoc::SaveTGA(unsigned char *sourcedata,int sourceformat,int w,int h,const char *filename,bool flipimage,bool flipcolors)
{
	if (flipimage)
	{
		int size=w*(sourceformat);
		unsigned char *tempw=new unsigned char [size];
		unsigned char *src1=sourcedata;		
		unsigned char *src2=sourcedata+(w*(sourceformat))*(h-1);
		for (int k=0;k<h/2;k++)
		{
			memcpy(tempw,src1,size);
			memcpy(src1,src2,size);
			memcpy(src2,tempw,size);
			src1+=size;
			src2-=size;
		}
		delete [] tempw;
	}

	TargaHeader_t header;

	memset(&header, 0, sizeof(header));
	header.image_type = 2;
	header.width = w;
	header.height = h;

	if (sourceformat==4)
		header.pixel_size = 32;
	else
		header.pixel_size = 24;

	unsigned char *data = new unsigned char[w*h*(header.pixel_size>>3)];
	unsigned char *dest = data;
	unsigned char *source = sourcedata;

	/*
	if (sourceformat==1)
	{
	memcpy(dest,source,w*h);
	header.pixel_size = 8;
	}
	else
	*/
	{			  	
		for (int a1 = 0; a1 < h; a1++)
		{
			for (int b1 = 0; b1 < w; b1++)
			{
				unsigned char r, g, b, a;

				if (sourceformat==1)
				{
					r=g=b=*source++;
					*dest = b; dest++;
					*dest = g; dest++;
					*dest = r; dest++;
				}
				else
				{				
					if (flipcolors)
					{
						b = *source; source++;
						g = *source; source++;
						r = *source; source++;
					}
					else
					{					
						r = *source; source++;
						g = *source; source++;
						b = *source; source++;
					}
					*dest = b; dest++;
					*dest = g; dest++;
					*dest = r; dest++;
					if (sourceformat==4) 
					{
						a = *source; source++;
						*dest = a; dest++;
					}				
				}				
			}
		}
	}	

	FILE *f = fopen(filename,"wb");
	if (!f)
	{		
		MyOutputDebugString("Cannot save %s\n",filename);
		delete [] data;
		return (false);
	}

	if (!fwrite(&header,1, sizeof(header),f))
	{		
		MyOutputDebugString("Cannot save %s\n",filename);
		delete [] data;
		fclose(f);
		return (false);
	}

	if (!fwrite(data,1, w*h*(header.pixel_size>>3),f))
	{		
		MyOutputDebugString("Cannot save %s\n",filename);		
		delete [] data;
		fclose(f);
		return (false);
	}

	fclose(f);
	delete [] data;

	return (true);
}
