try
{
	// Get Filesystem object and generating arguments for
	var WSHSHELL = WScript.CreateObject("WScript.Shell");
	var WSHNETWORK = WScript.CreateObject("WScript.Network");
	
	var FSO = WScript.CreateObject("Scripting.FileSystemObject");
	var forReading = 1, forWriting = 2, forAppending = 8;
	var tristateUseDefault = -2, tristateTrue = -1, tristateFalse = 0;
	
	NoGUIApplication();
	
	// Get the path where the script is located and current script name
	var startedInPath = WSHSHELL.CurrentDirectory ;
	var scriptName = WScript.ScriptName.substr( 0 , WScript.ScriptName.length - 3);
	var workingScriptPath = WScript.ScriptFullName;
	var workingScriptDir = "";
	var regExp = /(.*)\\.*$/i;
	if(workingScriptPath.search(regExp) != "-1")
	{
		workingScriptDir = RegExp.$1;
	}
	else
	{
		WScript.Echo("Could not get the directory of the working script.");
		WScript.Quit(1);
	}
	
	
	
	
	
	///////////////////////////////////////////////////////////////////////////////
	// *Main*
	///////////////////////////////////////////////////////////////////////////////
	
	var repeat = true;
	var logF = workingScriptDir + "\\" + scriptName + ".log";
	
	while(repeat == true)
	{	
		// Create Log file		
		var	loadedLogFile = FSO.CreateTextFile( logF ,true );
		
		Log("Start of active flag saving script");
		Log("*******************************************");
		Log("For bugs and comments: Denis@Crytek.de\r\n\r\n");
	
		
		// Create flag file
		var flagF = workingScriptDir + "\\ActiveFlag.txt";
		
		var i = 0;
		// Main loop
		while(i<=10)
		{	
			Log("Creating flag file " + flagF);	
			var	loadedFlagF = FSO.CreateTextFile( flagF ,true );	
			var currentDateAsString = GetConvertedDate();
			
			Log("Writing the current time " + currentDateAsString + " into the flag file\r\n");
			loadedFlagF.WriteLine( currentDateAsString );
			loadedFlagF.Close();
			loadedFlagF = null;
			i++;
			WScript.Sleep(20000);
		}
		
		loadedLogFile.Close();
	}
	
	///////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////
	
	
	
	
	
	
	///////////////////////////////////////////////////////////////////////////////
	// *Functions*
	///////////////////////////////////////////////////////////////////////////////
	
	//+++++++++++++++++++++++++Get converted date+++++++++++++++++++++++++
	function GetConvertedDate()
	{
		var jscriptDate = new Date();
		var convertedDate = jscriptDate.getYear()+"-"+(jscriptDate.getMonth()+1)+"-"+jscriptDate.getDate()+" "+jscriptDate.getHours()+":"+jscriptDate.getMinutes()+":"+jscriptDate.getSeconds();
		return(convertedDate);
	}
	
	//++++++++++++++++++++++Prevents this script to be started without a dos window+++++++++++++
	function NoGUIApplication()
	{  
		var scriptHost = WScript.FullName;
		var regExp = /cscript.exe/i
		if(scriptHost.search(regExp) == "-1")
		{
			WSHSHELL.Popup( "Invalid script Host - This application is made for commandline use only\n"+
		                    "Please start the script with \"cscript\" before the scriptname e.g.: cscript <ScriptName>\n",
		                    0,"Script",0);
		                    
		 WScript.Quit(0);
		}
	}
	
	
	//+++++++++++++++++++++++++Function for writing to the log+++++++++++++++++++++++++
	function Log(str) 
	{
		var couldNotLog = "   (Could not write this line to log file)";
		
		if(loadedLogFile != null)
		{
			try
			{
				loadedLogFile.WriteLine( str );
			}
			catch(e)
			{
				str += couldNotLog;
			}
		}
		else 
			str += couldNotLog;
			
		WScript.StdOut.WriteLine( str );
	}
	
	///////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////
	
	
	
}
catch(e)
{
	WScript.Echo("error: "+e);
	WScript.Echo("error number: "+e.number & 0xFFFF);
	WScript.Echo("error description: "+e.description);
	errorLogFile = FSO.CreateTextFile(  workingScriptDir + "\\" + scriptName + "_ERROR.log",true );
	errorLogFile.WriteLine("error: "+e);
	errorLogFile.WriteLine("error number: "+e.number & 0xFFFF);
	errorLogFile.WriteLine("error message: "+e.message);
	errorLogFile.WriteLine("error description: "+e.description);
	errorLogFile.Close();
	WScript.Quit(1);
}