//////////////////////////////////////////////////////////////////////////////
// Implementation of CLinearApproximation,
// the class that is used to approximate a set of sample points with a linear
// function y = a[0] + a[1]*x
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GLUtils.h"
#include "BigVector.h"
#include "BigMatrix.h"
#include "LinearApproximation.h"

//////////////////////////////////////////////////////////////////////
// constructs the approximation from the given set of points
// using least-square method
//////////////////////////////////////////////////////////////////////
CLinearApproximation::CLinearApproximation (double* pData, int nPointCount)
{
	//   m_fTerm[0],b : f[x] = m_fTerm[0] + b*x
	m_fTerm[0] = m_fTerm[1] = 0;
	m_fTerm[0] = 0, m_fTerm[1] = 0;
	
	if (nPointCount<=0)
	{
		m_fTerm[1] = 0;
		m_fTerm[0] = 0;
	}
	else
	if (nPointCount == 1)
	{
		// stationary equation for one-point
		m_fTerm[1] = 0;
		m_fTerm[0] = pData[0];
	}
	else
	{
		double Yk, XkYk;
		int    i;

		Yk   = 0.0;
		XkYk = 0.0;
		for (i = 0; i < nPointCount; ++i)
		{
			Yk   += pData[i];
			XkYk += i*pData[i];
		}
		// sum of i from nXBegin to nXEnd-1
		double Xk = (double(nPointCount)*(nPointCount-1))/2;
		// sum of i^2 from nXBegin to nXEnd-1
		double X2k = (double(nPointCount)*(1 + nPointCount * (2*nPointCount-3) ))/6;

		m_fTerm[1] = (((Xk*Yk) - (nPointCount*XkYk)))/((Xk*Xk) - (nPointCount*X2k));
		m_fTerm[0] = (Yk - m_fTerm[1]*Xk)/nPointCount;
	}
}

// returns the sum of deviations of the approximation from the actual data set
double CLinearApproximation::GetError (double * pData, int nCount)const
{
	double fError = 0;
	for (int nFrame = 0; nFrame < nCount; ++nFrame)
	{
		fError += tsqr(pData[nFrame]-GetValue (nFrame));
	}
	return fError;
}

// returns the approximation line value at the given argument
double CLinearApproximation::GetValue(double x)const
{
	return m_fTerm[0] + m_fTerm[1] * x;
}
