// MotionOptimizerDoc.cpp : implementation of the CMotionOptimizerDoc class
//

#include "stdafx.h"
#include "MotionOptimizer.h"

#include "MotionOptimizerDoc.h"
#include "BSplineSimpleTest.h"
#include "BSplineApprTest.h"

#include "ChunkFileReader.h"
#include "CafTestReader.h"
#include "DlgApprParams.h"

#include "ChunkFileWriter.h"
#include "BSplineOpen.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMotionOptimizerDoc

IMPLEMENT_DYNCREATE(CMotionOptimizerDoc, CDocument)

BEGIN_MESSAGE_MAP(CMotionOptimizerDoc, CDocument)
	ON_COMMAND(ID_TEST_BSPLINEINTERPOLATOR, OnTestBsplineInterpolator)
	ON_COMMAND(ID_EDIT_CLEANUP, OnEditCleanup)
	ON_COMMAND(ID_TEST_BSPLINE_APPROXIMATOR, OnTestBsplineApproximator)
	ON_COMMAND(ID_FILE_IMPORT_CAF_TEST, OnFileImportCafTest)
	ON_COMMAND(ID_FILE_EXPORT_CAF, OnFileExportCaf)
	ON_COMMAND(ID_REOPTIMIZE, OnReoptimize)
	ON_COMMAND(ID_FILE_BATCHCONVERTCAF, OnFileBatchConvertCaf)
	ON_COMMAND(ID_8BIT, On8bit)
	ON_UPDATE_COMMAND_UI(ID_8BIT, OnUpdate8bit)
	ON_COMMAND(ID_TEST_TRIANGULATOR, OnTestTriangulator)
	ON_COMMAND(ID_FILE_OPTIMIZEALL, OnFileOptimizeall)
END_MESSAGE_MAP()


// CMotionOptimizerDoc construction/destruction

CMotionOptimizerDoc::CMotionOptimizerDoc():
	m_b8Bit (false)
{
	// TODO: add one-time construction code here

}

CMotionOptimizerDoc::~CMotionOptimizerDoc()
{
}

BOOL CMotionOptimizerDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// reinitialization code here
	// (SDI documents will reuse this document)
//	Test();

	m_vDrawables.clear();

	return TRUE;
}




// CMotionOptimizerDoc serialization

void CMotionOptimizerDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

// draws all drawables in the doc
void CMotionOptimizerDoc::onDraw(CDC* pDC, CMotionOptimizerView* pView)
{
	IDrawable_AutoArray::iterator it;
	for (it = m_vDrawables.begin(); it != m_vDrawables.end(); ++it)
		(*it)->onDraw (pDC, pView);
}

void CMotionOptimizerDoc::onLButtonDown(const CPoint& pt, CMotionOptimizerView* pView)
{
	IDrawable_AutoArray::iterator it;
	for (it = m_vDrawables.begin(); it != m_vDrawables.end(); ++it)
		(*it)->onLButtonDown (pt, pView);
	UpdateAllViews(NULL);
}

void CMotionOptimizerDoc::onLButtonUp (const CPoint& pt, CMotionOptimizerView* pView)
{
	IDrawable_AutoArray::iterator it;
	for (it = m_vDrawables.begin(); it != m_vDrawables.end(); ++it)
		(*it)->onLButtonUp (pt, pView);
	UpdateAllViews(NULL);
}

void CMotionOptimizerDoc::onMouseMove (const CPoint&pt, CMotionOptimizerView* pView)
{
	IDrawable_AutoArray::iterator it;
	for (it = m_vDrawables.begin(); it != m_vDrawables.end(); ++it)
		(*it)->onMouseMove (pt, pView);
	UpdateAllViews(NULL);
}


// CMotionOptimizerDoc diagnostics

#ifdef _DEBUG
void CMotionOptimizerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMotionOptimizerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CMotionOptimizerDoc commands

void CMotionOptimizerDoc::OnTestBsplineInterpolator()
{
	m_vDrawables.clear();
	m_vDrawables.push_back(new BSplineSimpleTest(/*(rand()%30)+4*/ 1220));
	UpdateAllViews(NULL);
}

void CMotionOptimizerDoc::OnEditCleanup()
{
	m_vDrawables.erase(m_vDrawables.begin());
	UpdateAllViews(NULL);
}

void CMotionOptimizerDoc::OnTestBsplineApproximator()
{
	try
	{
		//if (!m_vDrawables.empty())
		//	m_vDrawables.resize(1);
		//m_vDrawables.push_back(new CBSplineApprTest ("e:\\controller0.txt"));

		FILE* f = fopen ("e:\\controller0.txt", "rt");
		if (f)
		{

			//		std::string file("e:\\controller0.txt");
			//		FILE * f = fopen(file.c_str(), "rb");


			std::vector<int> vTimes;
			std::vector<Vec3d> vPos;
			//while(!feof(f))
			for (uint32 i =0; i < 100; ++i )
			//while(!feof(f))
			{
				float time;
				Vec3 quat;
				Vec3 pos;
				fscanf(f, "%f %f %f %f %f %f %f", &time, &quat.x, &quat.y, &quat.z, &pos.x, &pos.y, &pos.z);

				//			time *= 60;
				vPos.push_back(pos);
				vTimes.push_back(time);
			}

			fclose(f);

			CBSplineApprTest::Params params(CBSplineApprTest::Params::DefEnum::nDefPos);
			m_vDrawables.push_back(new CBSplineApprTest(vTimes, vPos, params, true ));
		}

		UpdateAllViews(NULL);
	}
	catch (const char* e)
	{
		AfxMessageBox(e);
	}
}


int RunApprParams (CDlgApprParams& dlgRot, CDlgApprParams& dlgPos)
{
	dlgRot.SetTitle("ROTATION");
	dlgPos.SetTitle("POSITION");
	dlgRot.SetOkText("Position >>");
	dlgPos.SetCancelText("<< Rotation");

	do 
	{
		if (dlgRot.DoModal() == IDCANCEL)
			return IDCANCEL; // cancel
		// forward to the position dialog
	}
	while(dlgPos.DoModal() == IDCANCEL); // Back to rotation dialog

	return IDOK;
}


void CMotionOptimizerDoc::OnFileImportCaf()
{
	CFileDialog fileDlg(TRUE, "caf", "*.caf", OFN_FILEMUSTEXIST, "Crytek Animation Files (*.caf)|*.caf|All Files (*.*)|*.*", AfxGetMainWnd());
	if (fileDlg.DoModal() == IDOK)
	{
		CChunkFileReader_AutoPtr pReader = new CChunkFileReader();
		if (pReader->open (fileDlg.GetPathName()))
		{
			try
			{
				CDlgApprParams dlgParamsRot (AfxGetMainWnd(), CBSplineApprTest::Params(CBSplineApprTest::Params::nDefRot));
				CDlgApprParams dlgParamsPos (AfxGetMainWnd(), CBSplineApprTest::Params(CBSplineApprTest::Params::nDefPos));
				if (RunApprParams(dlgParamsRot, dlgParamsPos) == IDOK)
				{
					CCafTestReader_AutoPtr pTestReader = new CCafTestReader(pReader, dlgParamsPos.m_Params, dlgParamsRot.m_Params,strstr(fileDlg.GetPathName(),"loop")?false:true);
					pTestReader->set8Bit(m_b8Bit);
					pTestReader->setOriginName(fileDlg.GetFileName());
					m_vDrawables.push_back ((CCafTestReader*)pTestReader);
				}
			}
			catch (const char*e)
			{
				AfxMessageBox(e);
			}
		}
		else
			AfxMessageBox("Cannot open the file. Perhaps it's not a CAF.");
	}
}

void CMotionOptimizerDoc::OnFileImportCafTest()
{
	OnFileImportCaf();
	UpdateAllViews(NULL);
}

void CMotionOptimizerDoc::onMouseWheel (UINT nFlags, short zDelta, CPoint pt, CMotionOptimizerView* pView)
{
	for (IDrawable_AutoArray::iterator it = m_vDrawables.begin(); it != m_vDrawables.end(); ++it)
		(*it)->onMouseWheel(nFlags, zDelta, pt, pView);
	UpdateAllViews(NULL);
}

void CMotionOptimizerDoc::OnFileExportCaf()
{
	for (unsigned i = 0; i < m_vDrawables.size(); ++i)
		m_vDrawables[i]->onCommand(ID_FILE_EXPORT_CAF);
}

void CMotionOptimizerDoc::OnReoptimize()
{
	for (unsigned i = 0; i < m_vDrawables.size(); ++i)
		m_vDrawables[i]->onCommand(ID_REOPTIMIZE);
	UpdateAllViews(NULL);
}

void CMotionOptimizerDoc::OnFileBatchConvertCaf()
{
	OPENFILENAME ofn;
	memset (&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner   = AfxGetMainWnd()->m_hWnd;
	ofn.hInstance   = AfxGetInstanceHandle();
	ofn.lpstrFilter = "Crytek Animation Files (*.caf)\0*.caf\0All Files (*.*)\0*.*\0\0";
	char szFiles[0x8000];
	szFiles[0] = '\0';
	ofn.lpstrFile   = szFiles;
	ofn.nMaxFile    = sizeof(szFiles);
	ofn.lpstrTitle  = "Pick the files to convert";
	ofn.Flags       = OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT|OFN_EXPLORER ;
	ofn.lpstrDefExt = "caf";

	//CFileDialog fileDlg (TRUE, "caf", "*.caf", OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT, "Crytek Animation Files (*.caf)|*.caf|All Files (*.*)|*.*");
	//fileDlg.m_ofn.lpstrTitle = ;

	//if (fileDlg.DoModal() != IDOK)
	//	return;

	if (!GetOpenFileName (&ofn))
		return ;

	CDlgApprParams dlgParamsRot (AfxGetMainWnd(), CBSplineApprTest::Params(CBSplineApprTest::Params::nDefRot));
	CDlgApprParams dlgParamsPos (AfxGetMainWnd(), CBSplineApprTest::Params(CBSplineApprTest::Params::nDefPos));

	if (RunApprParams(dlgParamsRot, dlgParamsPos) != IDOK)
		return ;

	for (const char* szFile = szFiles + strlen(szFiles)+1; *szFile; szFile += strlen(szFile)+1)
	{
		std::string strFileName = szFiles;
		strFileName += '\\';
		strFileName += szFile;
		
		LogToDbg("Converting CAF file: %s", (const char*)strFileName.c_str());
		CChunkFileReader_AutoPtr pReader = new CChunkFileReader ();
		if (pReader->open (strFileName.c_str()))
		{
			try
			{
				CCafTestReader_AutoPtr pTestReader = new CCafTestReader(pReader, dlgParamsPos.m_Params, dlgParamsRot.m_Params, strstr(strFileName.c_str(),"loop")?false:true);
				pTestReader->set8Bit(m_b8Bit);
				pTestReader->setOriginName(strFileName.c_str());
				//m_vDrawables.push_back ((CCafTestReader*)pTestReader);
				std::string strOutFileName = szFiles;
				strOutFileName += "\\(o)\\";
				strOutFileName += szFile;
				pTestReader->exportCaf (strOutFileName.c_str());
			}
			catch (const char*e)
			{
				LogToDbg("Error: %s", e);
			}
			catch (CChunkFileWriter::Error& e)
			{
				LogToDbg("Error writing file: %s", e.c_str());
			}
		}
		else
			LogToDbg("Cannot open the file %s. Perhaps it's not a CAF.", strFileName.c_str());
	}
}


void CMotionOptimizerDoc::Test()
{
	BSplineVec3d bsp(4, 3, false);
	int i;
	for (i = 0; i < bsp.numKnots(); ++i)
		bsp.setKnotTime(i,float(i)/(bsp.numKnots()-1));
	bsp.finalizeKnotTimes();

	for (i = 0; i < bsp.numCPs(); ++i)
		bsp.setCP(0, Vec3d(1,2,3));
	
	for (float t = 0; t <= 1; t+=0.05f)
	{
		float fBasis = bsp.getBasis (0,t);
		Vec3d pt = bsp.getValue(t);
	}
}

void CMotionOptimizerDoc::On8bit()
{
	if (m_vDrawables.empty())
		m_b8Bit = !m_b8Bit;
}

void CMotionOptimizerDoc::OnUpdate8bit(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_b8Bit);
}

void CMotionOptimizerDoc::OnTestTriangulator()
{
	AfxMessageBox("Feature deprecated");
	//m_vDrawables.push_back (new CTriangulatorTest());
	//UpdateAllViews (NULL);
}


int CMotionOptimizerDoc::GetDirDlgCallback (HWND hwnd, UINT uMsg, LPARAM lParam)
{
	switch (uMsg)
	{
	case BFFM_INITIALIZED:
		{
			SendMessage (hwnd, BFFM_SETSELECTION, (WPARAM)m_strLastDir.c_str(), (LPARAM)m_strLastDir.c_str());
		}
		break;
	}
	return 0;
}

std::string CMotionOptimizerDoc::GetDirDlg()
{
	char szName[0x1000] = "";
	BROWSEINFO bi;
	memset (&bi, 0, sizeof(bi));
	bi.hwndOwner      = AfxGetMainWnd()->m_hWnd;
	bi.pszDisplayName = szName;
	bi.lpszTitle      = "Pick up the directory";
	bi.ulFlags        = BIF_RETURNONLYFSDIRS|BIF_NEWDIALOGSTYLE;

	bi.lpfn   = GetDirDlg_BrowseCallbackProc;
	bi.lParam = (LPARAM)this;

	LPITEMIDLIST pIIL = SHBrowseForFolder(&bi);
	if (!pIIL)
		return 0;

	if (!SHGetPathFromIDList (pIIL, szName))
		szName[0] = '\0';

	LPMALLOC pMalloc;
	if (SUCCEEDED(SHGetMalloc (&pMalloc)))
	{
		pMalloc->Free(pIIL);
		pMalloc->Release();
	}

	return szName;
}

void CMotionOptimizerDoc::OnFileOptimizeall()
{
	std::string strDir = GetDirDlg();
	if (strDir.empty())
		return;
	m_strLastDir = strDir;

	CDlgApprParams dlgParamsRot (AfxGetMainWnd(), CBSplineApprTest::Params(CBSplineApprTest::Params::nDefRot));
	CDlgApprParams dlgParamsPos (AfxGetMainWnd(), CBSplineApprTest::Params(CBSplineApprTest::Params::nDefPos));

	if (RunApprParams(dlgParamsRot, dlgParamsPos) != IDOK)
		return;

	/*{
		LogToDbg("Converting CAF file: %s", (const char*)strFileName.c_str());
		CChunkFileReader_AutoPtr pReader = new CChunkFileReader ();
		if (pReader->open (strFileName.c_str()))
		{
			try
			{
				CCafTestReader_AutoPtr pTestReader = new CCafTestReader(pReader, dlgParamsPos.m_Params, dlgParamsRot.m_Params, strstr(strFileName.c_str(),"loop")?false:true);
				pTestReader->set8Bit(m_b8Bit);
				pTestReader->setOriginName(strFileName.c_str());
				//m_vDrawables.push_back ((CCafTestReader*)pTestReader);
				std::string strOutFileName = szFiles;
				strOutFileName += "\\(o)\\";
				strOutFileName += szFile;
				pTestReader->exportCaf (strOutFileName.c_str());
			}
			catch (const char*e)
			{
				LogToDbg("Error: %s", e);
			}
			catch (CChunkFileWriter::Error& e)
			{
				LogToDbg("Error writing file: %s", e.c_str());
			}
		}
		else
			LogToDbg("Cannot open the file %s. Perhaps it's not a CAF.", strFileName.c_str());
	}*/
}
