using System;

namespace NetworkBandwidthAnalyser
{
	/// <summary>
	/// Summary description for Message.
	/// </summary>
	public class Message : IParserSink
	{
		public String name;
		double tagSize;
		System.Collections.Hashtable data;

		public Message(String name, double tagSize)
		{
			data = new System.Collections.Hashtable();
			this.name = name;
			this.tagSize = tagSize;
		}

		public double TotalSize
		{
			get
			{
				double size = tagSize;
				foreach (double x in data.Values)
					size += x;
				return size;
			}
		}

		public double HeaderSize
		{
			get
			{
				return tagSize;
			}
		}

		public void AddDataNames( System.Collections.Specialized.StringCollection sc )
		{
			foreach (String dataName in data.Keys)
			{
				String fullName = name + ":" + dataName;
				if (!sc.Contains(fullName))
					sc.Add(fullName);
			}
		}
		public void AddDataSizes( System.Collections.ArrayList o, String filterData )
		{
			foreach (String dataName in data.Keys)
			{
				String fullName = name + ":" + dataName;
				if (fullName == filterData)
					o.Add(data[dataName]);
			}
		}
		public void AddDataTimes( System.Collections.ArrayList o, String filterData, double tm )
		{
			foreach (String dataName in data.Keys)
			{
				String fullName = name + ":" + dataName;
				if (fullName == filterData)
					o.Add(tm);
			}
		}

		#region IParserSink Members

        public double ConvertToDouble( String s )
        {
            System.Globalization.NumberFormatInfo provider = new System.Globalization.NumberFormatInfo();
            provider.NumberDecimalSeparator = ".";
            provider.NumberGroupSeparator = ",";
            return System.Convert.ToDouble(s, provider);
        }

		public void AddLine(Parser parser, String[] tokens)
		{
			if (tokens[0] == "Message" || tokens[0] == "EndPacket")
			{
				parser.PassUpLine(tokens);
				return;
			}
			if (tokens[0] == "Data")
			{
				if (data.Contains(tokens[1]))
				{
					double x = (double)data[tokens[1]];
					x += ConvertToDouble(tokens[2]);
					data[tokens[1]] = x;
				}
				else
				{
					data.Add(tokens[1], ConvertToDouble(tokens[2]));
				}
				return;
			}

			parser.Fail( tokens[0] );
		}

		#endregion
	}
}
