/*
ScPl - A plotting library for .NET

IPlot.cs
Copyright (C) 2003
Matt Howlett

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
   
2. Redistributions in binary form must reproduce the following text in 
   the documentation and / or other materials provided with the 
   distribution: 
   
   "This product includes software developed as part of 
   the ScPl plotting library project available from: 
   http://www.netcontrols.org/scpl/" 

------------------------------------------------------------------------

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: IPlot.cs,v 1.13 2004/04/26 04:18:41 mhowlett Exp $

*/

using System.Drawing;

namespace scpl
{
	/// <summary>
	/// Interface implemented by all trace objects that can be added to a PlotSurface2D.
	/// </summary>
	public interface IPlot : IDrawable
	{		
		/// <summary>
		/// Method used to draw a representation of the plot in a legend.
		/// </summary>
		/// <param name="g">The graphic object where the drawing is performed.</param>
		/// <param name="startEnd">The bounds of where the drawing takes place.</param>
		void DrawLegendLine( Graphics g, RectangleF startEnd ); // rectangle used to store start and end of line.

		/// <summary>
		/// The string label associated to the plot.
		/// </summary>
		string Label { get; set; }

		/// <summary>
		/// Whether or not to include an entry for this plot in the legend.
		/// </summary>
		bool ShowLegendLine { get; set; }

		/// <summary>
		/// The method used to set the abscissa axis defaults.
		/// </summary>
		Axis SuggestXAxis();

		/// <summary>
		/// The method used to set the ordinate axis defaults.
		/// </summary>
		Axis SuggestYAxis();

		/// <summary>
		/// TODO
		/// </summary>
		object DataSource { get; set; }

		/// <summary>
		/// TODO
		/// </summary>
		string DataMember { get; set; }
	}
}