/*
ScPl - A plotting library for .NET

Gradient.cs
Copyright (C) 2003
Matt Howlett

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
   
2. Redistributions in binary form must reproduce the following text in 
   the documentation and / or other materials provided with the 
   distribution: 
   
   "This product includes software developed as part of 
   the ScPl plotting library project available from: 
   http://www.netcontrols.org/scpl/" 

------------------------------------------------------------------------

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: LinearGradient.cs,v 1.1 2004/04/07 06:29:38 mhowlett Exp $

*/

using System;
using System.Drawing;

namespace scpl
{
	public class LinearGradient : IGradient
	{
		
		#region Constructor
		public LinearGradient( Color minColor, Color maxColor )
		{
			this.minColor_ = minColor;
			this.maxColor_ = maxColor;
		}
		#endregion

		#region get/set MaxColor
		public Color MaxColor
		{
			get
			{
				return this.maxColor_;
			}
			set
			{
				this.maxColor_ = value;
			}
		}
		private Color maxColor_;
		#endregion
		#region get/set MinColor
		public Color MinColor
		{
			get
			{
				return this.minColor_;
			}
			set
			{
				this.minColor_ = value;
			}
		}
		private Color minColor_;
		#endregion

		#region GetColor
		public Color GetColor( double prop )
		{

#if CHECK_ERRORS
			if ( prop < 0.0 || prop > 1.0 )
			{
				throw new System.Exception( "WARNING: Gradient.GetColor: proportion not in range 0.0 <= prop <= 1.0" );
			}
#endif

			if ( prop <= 0.0 )
			{
				return this.MinColor;
			}

			if ( prop >= 1.0 )
			{
				return this.MaxColor;
			}

			byte r = (byte)((int)(this.MinColor.R) + (int)(((double)this.MaxColor.R - (double)this.MinColor.R)*prop));
			byte g = (byte)((int)(this.MinColor.G) + (int)(((double)this.MaxColor.G - (double)this.MinColor.G)*prop));
			byte b = (byte)((int)(this.MinColor.B) + (int)(((double)this.MaxColor.B - (double)this.MinColor.B)*prop));

			return Color.FromArgb(r,g,b);
		}
		#endregion
	}
}
