// Function wrapper for invoking a function on a specified stack fragment.

	.file			"Invoke.S"
	.section	".toc", "aw"
	.section	".text"
	.align		2
	.globl		InvokeOnLinkedStack
	.section	".opd", "aw"
	.align		2

InvokeOnLinkedStack:
	.long			.InvokeOnLinkedStack, .TOC.@tocbase32
	.previous
	.size			InvokeOnLinkedStack, . - InvokeOnLinkedStack
	.type			.InvokeOnLinkedStack, @function
	.globl		.InvokeOnLinkedStack

// void InvokeOnLinkedStack(
//		void (*proc)(void *),
//		void *arg,
//		void *stack,
//		size_t stackSize )
//
.InvokeOnLinkedStack:
	// move to the new stack
	add				5, 6, 5
	subi			5, 5, 16
	std				1, 0(5)
	subi			1, 5, 128
	mflr			0
	std				0, 136(1)

	// invoke proc (proc => r6)
	mr				6, 3
	mr				3, 4
	std				2, 40(1)		// save TOC
	lwz				2, 4(6)			// load TOC
	lwz				6, 0(6)			// load proc addr
	mtctr			6
	bctrl
	ld				2, 40(1)		// restore TOC

	// restore stack
	ld				0, 136(1)
	ld				1, 128(1)
	mtlr			0
	blr

	.size	.InvokeOnLinkedStack, . - .InvokeOnLinkedStack

// vim:ts=2

