/* 
	implementation of spu job manager DMA related functions
*/

#if defined(PS3)

#define eCryModule eCryM_Launcher
#include <CryModuleDefs.h>
#include <platform.h>
#include "JobManSPU.h"
#include "PPU.h"

using namespace NPPU;

//create DMA output list packets
void CJobManSPU::CreateDMAList
(
	const uint32 cJobParamSize,
	NSPU::NDriver::SInfoBlock& __restrict rInfoBlock,
	const CSPUJobDel& crJob,
	volatile const CCommonDMABase* __restrict* __restrict ppPackets,
	const uint32 cPacketCount
)
{
	//allocate memory for packets and set packet pointer accordingly 
	uint8* const __restrict pParamAddr = (uint8*)rInfoBlock.GetParamAddress();
	uint8 *__restrict pCurParamDataDest = (uint8*)pParamAddr;
	const CCommonDMABase* __restrict pCurPacketData = (const CCommonDMABase*)&crJob;
	//iterate all packets (main one plus added packets)
	uint32 packet = 0;//packets to add, main packet comes first (<=)
	const uint32 cEndParamArea = (uint32)rInfoBlock.GetParamAddress() + NSPU::NDriver::SInfoBlock::scAvailParamSize;
	while(1)
	{
		assert((uint32)pCurParamDataDest + cJobParamSize <= cEndParamArea);
		//copy param data
		const void* const __restrict cpPacketSrc = pCurPacketData->GetJobParamData();
		memcpy((void* __restrict)pCurParamDataDest, cpPacketSrc, cJobParamSize);
		pCurParamDataDest += cJobParamSize;
		if(packet == cPacketCount)
		{
			if((uint32)pCurParamDataDest < cEndParamArea)//otherwise a whole packet would get wasted due to 16 byte alignment
				*(uint32*)pCurParamDataDest = NSPU::NDriver::SInfoBlock::scNoPacketVal;//signal no more packets
			break;
		}
		pCurPacketData = (CCommonDMABase* __restrict)ppPackets[packet];
		++packet;
	}//packet loop
}

#endif //PS3 
