////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) SN Systems Ltd 2005-2007
//
//  Description:  Tuner for PS3 - Library Functions
//
//  Change History:
//
//  Vers      Date            Author        Changes
//  1.4       09-Jul-2007     Tom           Added snRSXMarkerSync(), snRSXGetMaxMarkers(),
//                                                snRSXPushMarker() & snRSXPopMarker()
//  1.3       24-Jul-2006     Tom           Added snStartCapture()/snStopCapture()
//  1.2       26-Apr-2006     Tom           Renamed from SNTuner.h to libsntuner.h
//                                          Added __SN_Libsntuner_version
//  1.1       03-Apr-2006     Tom           Moved snIsTunerRunning() from libsn.h
//  1.0       26-Nov-2005     Tom           First release
//
////////////////////////////////////////////////////////////////////////////////

#ifndef __SNTUNER_H__
#define __SNTUNER_H__

#ifdef __cplusplus
extern "C" {
#endif

	void snStartMarker(unsigned int uID, const char *pText);
	void snStopMarker(unsigned int uID);
	void snStartCapture();
	void snStopCapture();

	int snIsTunerRunning (void);

#ifdef __CELL_GCM_H__
	int snRSXMarkerSync(CellGcmContextData* thisContext, void* pRsxReportEA, uint32_t uRsxReportOffset);
	unsigned int snRSXGetMaxMarkers();
	int snRSXPushMarker(CellGcmContextData* thisContext, const char *pText);	// Returns SUCCEEDED(0) or error(<0)
	int snRSXPopMarker(CellGcmContextData* thisContext);	// Returns SUCCEEDED(0) or error(<0)
#endif

	// For backwards compatibility:
	int snTunerInit();
	#define snIsTunerPresent snIsTunerRunning

	extern unsigned int __SN_Libsntuner_version[];

#ifdef __cplusplus
}
#endif

#endif /* __SNTUNER_H__ */
