
use Cwd;
use IO::File;
use File::Copy;
use File::Path;
use Shell;
use Win32::File;
use List::Util qw[min max];

$UnzipCmd = "\"c:\\Program\ Files\ \(x86\)\\zip\\unzip.exe\"";
$ZipCmd = "\"c:\\Program\ Files\\WinRAR\\WinRar.exe\"";
$ZipPakArg = "a -afzip";
$MaterialNameTool = "E:\\Crytek\\CryEngine2\\Code\\Tools\\PackSDK\\Bin32\\MaterialFile.exe";

my $sdkFilePath;
my $sdkFilename;
my $sourcePath;
my $outputPath;
my $currentPath;

my $tagBuildNumber;

%fileHandlers;
@fileList;

$CRLF = "\012";

#-------------------------------------------------------------------------
sub PrepareDirectory
{
	my $filename = shift;
	
	$filename =~ /^(.*?)\\([\w\.0-9\-_\s]+$)/;
	my $fullpath = $1;
	
	if (-e $fullpath)
	{
		return;	
	}
	
	#$filename =~ s/(..\\)//;
	my $path = "";
	
	if ($filename =~ s/^([\w]+:\\)//)
	{
		$path = $1;
	}
	
	while ($filename =~ s/([\w\s.0-9\-]+(\\|\/))//)
	{
		my $subdir = $1;
		$path = $path.$subdir;
		
		if (not -e $path)
		{
			mkpath $path;
		}
	}
}

#-------------------------------------------------------------------------
sub CompletePath
{
	my $filename = shift;
	my $path = shift;
	
	while ($filename =~ s/^..(\\|\/)//)
	{
		$path =~ s/([\\\/]?)[\w\d_\-\s]+([\\\/]?)$/$1/;
	}
	
	if (not $path =~ /(\\|\/)$/)
	{
		$path = $path."\\";
	}
	
	my $fullpath = $path.$filename;
	
	return $fullpath;
}

#-------------------------------------------------------------------------
sub FileHandlerGeneric
{
	my $filename = shift;
	while ($filename =~ s/\//\\\\/) {};
	
	if (-e $sourcePath.$filename)
	{
		print STDOUT "FileHandlerGeneric: added <$filename>\n";
		push @fileList, $filename."\n";
 	}
 	else
 	{
 		print STDOUT "FileHandlerGeneric: cannot find <$filename>\n";
 	}
}

#-------------------------------------------------------------------------
sub FileHandler
{
	my $filename = shift;
	
	#print STDOUT "FileHandler <$filename>\n";
	
	if ($filename =~ /(.*?)\.([\w]+)$/)
	{
		my $ext = $2;
		my $fileHandler;

		if ($fileHandler = $fileHandlers{$ext})
		{
			$fileHandler->($filename);
		}
		else
		{
			FileHandlerGeneric($filename);
		}
	}
}

#-------------------------------------------------------------------------
sub FileHandlerCal
{
	my $calFilename = shift;
	
	my $calIN = new IO::File;
	if (not open($calIN, $sourcePath.$calFilename))
	{
		print STDOUT "$! - cannot open cal file <$sourcePath$calFilename>\n";
		return;
	}
	
	undef $/;
	my $content = <$calIN>;
	close($calIN);
	$/ = "\n";
	
	print STDOUT "FileHandlerCal() with <$calFilename> and <$content>\n\n";

	my $filepath;
	my $line;
	
	while ($content =~ m/(.*?)\n/sg)
	{
		my $line = $1;
		
		#$AnimEventDatabase = animations\human\male\Male_EventDataBase.animevents
		#$Include = objects\characters\human\GlobalHuman.cal
		if ($line =~ /\#filepath[\s]?\=[\s]?([\w\\]+)/)
		{
			$filepath = $1;
		}
		elsif ($line =~ /^\/\//)
		{
			# comment line
		}
		elsif ($line =~ /^\$Include[\s]*=[\s]*(.*?)[\n]?$/i)
		{
			my $includeFilename = $1;
			$includeFilename =~ s/\\/\//;
			#addfilter cal exclude ondemand.cal
			my $isUsed = true;
			
			print STDOUT " hey $g_filters{\"cal\"}{\"exclude\"}\n";
			
			#while (($key, $value) = each(%coins)){
			#while (($key, $value) = each(g_filters{"cal"}{"exclude"}))
			#{
				#print STDOUT "exclude <$key> <$value>\n";
			#}
			
			if ($isUsed)
			{
				FileHandler("Game\/$includeFilename");
			}
		}
		elsif ($line =~ /^\$AnimEventDatabase[\s]*=[\s]*(.*?)[\n]?$/)
		{
			$dbFilename = $1;
			$dbFilename =~ s/\\/\//;
			FileHandler("Game\/$dbFilename");
		}
		elsif ($line =~ /^\$TracksDatabase[\s]*=[\s]*(.*?)[\n]?$/)
		{
			$dbFilename = $1;
			$dbFilename =~ s/\\/\//;
			FileHandler("Game\/$dbFilename");
		}
		elsif ($line =~ /^\$/)
		{}
		elsif ($line =~ /^([\_\w0-9]+)([\s\t]+)\=([\s\t]+)([\_\w0-9\\\/]+)\.([\w]+)$/)
		{
			my $animRelName = $4;
			my $ext = $5;
			my $f = "Game\\".$filepath."\\".$animRelName."\.".$ext;
			
			FileHandlerGeneric($f);
		}
	}
	
	print STDOUT "\n---\n";
	
	PrepareDirectory($outputPath.$calFilename);

	open($calOUT, ">$outputPath$calFilename") || die "open: $!";
	print $calOUT $content;
	close($calOUT);
}

#-------------------------------------------------------------------------
sub FileHandlerVehicle
{
	my $calFilename = shift;
	
	$calFilename = $sourcePath.$pakLocalPath.$calFilename;
	
	my $calIN = new IO::File;
	open($calIN, $calFilename) || die "open: $!";

	my $filepath;
	my $line;
	
	while ($line = <$calIN>)
	{
		if ($line =~ /\#filepath[\s]?\=[\s]?([\w\\]+)/)
		{
			$filepath = $1;
		}
		elsif ($line =~ /^\/\//)
		{}
		elsif ($line =~ /^\$/)
		{}
		elsif ($line =~ /^([\_\w0-9]+)([\s\t]+)\=([\s\t]+)([\_\w0-9\\\/]+)\.([\w]+)/)
		{
			my $animRelName = $4;
			my $ext = $5;
			my $f = $filepath."\\".$animRelName."\.".$ext;
			
			FileHandlerGeneric($f);
		}
	}
	
	close($calIN);
}

@vcPlatformListToRemove;
@vcConfigListToKeep;
@vcPlatformListToKeep;

#-------------------------------------------------------------------------
sub cmdKeepVCConfig
{
	my $line = shift;
	
	if ($line =~ /\"(.*?)\"$/)
	{
		push(@vcConfigListToKeep, $1);
	}
	if ($line =~ /clear$/i)
	{
		@vcConfigListToKeep = ();
	}
}

#-------------------------------------------------------------------------
sub cmdKeepVCPlatform
{
	my $line = shift;
	
	if ($line =~ /\"(.*?)\"$/)
	{
		push(@vcPlatformListToKeep, $1);
	}
	if ($line =~ /clear$/i)
	{
		@vcPlatformListToKeep = ();
	}
}

#-------------------------------------------------------------------------
sub FileHandlerVSProject
{
	my $projectFilename = shift;
	$projectFilename =~ /(.*?)[\w]+\.vcproj$/i;
	my $relPath = $1;
	
	print STDOUT "FileHandlerVSProject() <$projectFilename>\n";
	
	#FileHandlerGeneric($projectFilename);
	
	my $projIN = new IO::File;
	open($projIN, $sourcePath.$projectFilename) || die "open: $! <$sourcePath> <$projectFilename>\n";
	
	undef $/;
	my $content = <$projIN>;
	
	close($projIN);
	$/ = "\n";
	
	while ($content =~ m/<File[\s]+(.*?)[\s]+>/g) 
	{
		my $result = $1;
	  if ($result =~ /RelativePath=\"(.*?)\"/)
	  {
	  	my $filename = $1;
	  	$filename =~ s/^\.\\//;
	  	while ($filename =~ s/\\/\//) {}
	  	
	  	#print STDOUT " found: <$relPath$filename>\n";

	  	FileHandler("$relPath$filename");
		}
	}
	
	while ($content =~ s/[\t ]*SccProjectName=\"(.*?)\"\n//sgm) {}
	while ($content =~ s/[\t ]*SccLocalPath=\"(.*?)\"\n//sgm) {}
	while ($content =~ s/[\t ]*SccProvider=\"(.*?)\"\n//sgm) {}
	
	while ($content =~ m/<Platform([\s]+)(.*?)\/>/sgm)
	{
		my $platformTag = "<Platform$1$2\/>";
		
		$platformTag =~ /<Platform[\s\n]+Name\=\"(.*?)\"/;
		$platformName = $1;
		
		my $removePlatform = 1;
		
		foreach $platformToKeep (@vcPlatformListToKeep)
		{
			if ($platformName =~ /$platformToKeep/i)
			{
				$removePlatform = 0;
				#print STDOUT " - we keep platform <$platformName>\n";
			}
			
		}
		
		if ($removePlatform == 1)
		{
			print STDOUT " - we remove platform <$platformName>\n";
			$content =~ s/[\t ]*$platformTag[\n]?//;
		}
	}
	
	#<Configuration
	#		Name="Debug|Win32"
	#</Configuration>
	
	#Name="DebugPS3|Win32"
	
	while ($content =~ m/<Configuration[\s]+Name=\"(.*?)\"/sgm)
	{	
		my $configName = $1;
		
		my $removeConfig = 1;
		
		foreach $configToKeep (@vcConfigListToKeep)
		{
			if ($configName =~ /$configToKeep/i)
			{
				$removeConfig = 0;
				#print STDOUT " - we keep config <$configName>\n";
			}
			
		}
		
		if ($removeConfig == 1)
		{
			print STDOUT " - we remove config <$configName>\n";
			
			$configName =~ s/[\\]{0}\|/\\\|/g;
			
			$content =~ s/<Configuration[\s]+Name=\"$configName\"(.*?)<\/Configuration>[\n]?//sgm;
		}
	}
	
	#while ($content =~ s/<[\s\n]+Name\=\"Xbox[\s]+360\"[\s\n]+\/>[\s\n]+//sgm) {}
	#$content =~ s/<Configuration[\s\n]+Name=""//;
	
	my $projectFullPath = $outputPath.$projectFilename;
	while ($projectFullPath =~ s/\//\\/) {}
	
	my $projOUT = new IO::File;

	PrepareDirectory($projectFullPath);

	open($projOUT, ">$projectFullPath") || die "open: $!";
	print $projOUT $content;
	close($projOUT);
}

#-------------------------------------------------------------------------
sub FileHandlerVSSolution
{
	my $solutionFilename = shift;
	$solutionFilename =~ /(.*?)[\w]+\.sln$/i;
	my $relPath = $1;
	
	#FileHandlerGeneric($solutionFilename);
	
	my $slnIN = new IO::File;
	if (not open($slnIN, $sourcePath.$solutionFilename))
	{
		print STDOUT "open: $!\n"; 
		return 0;
	}
	
	undef $/;
	my $content = <$slnIN>;
	
	close($slnIN);
	$/ = "\n";
	
	while ($content =~ m/Project\(.*?\)[\s]?\=[\s]?\".*?\",[\s]?\"(.*?)\"/g) 
	{
		my $projFile = $1;
		my $projectFilename = CompletePath($projFile, $relPath);
		
		FileHandler($projectFilename);
	}
	
	while ($content =~ s/[\s]*GlobalSection\(SourceCodeControl\)(.*?|[\n]+)EndGlobalSection//s) {}
	
	if ($content =~ m/(GlobalSection\(SolutionConfigurationPlatforms\)[\s]?=[\s]?preSolution)(.*?)(EndGlobalSection)/sgm)
	{
		my $slnConfig = $2;
		
		while ($slnConfig =~ m/[\ \t]+(.*?)\ \=\ (.*?)\n/sgm)
		{
			my $configFirst = $1;
			my $configSecond = $2;
			
			my $lineToRemoved = 1;
			
			foreach $configToKeep (@vcConfigListToKeep)
			{				
				if ($configFirst =~ /$configToKeep/i)
				{
					if ($configSecond =~ /$configToKeep/i)
					{
						$lineToRemoved = 0;
					}
				}
			}
			
			if ($lineToRemoved == 1)
			{
				$configFirst =~ s/[\\]{0}\|/\\\|/g;
				$configSecond =~ s/[\\]{0}\|/\\\|/g;
				$content =~ s/[\ \t]+$configFirst\ =\ $configSecond\n//;
				
				#print STDOUT "removing <$configFirst> <$configSecond>\n";
			}
		}
	}

	
	if ($content =~ m/GlobalSection\(ProjectConfigurationPlatforms\)[\s]?=[\s]?postSolution\n(.*?)(EndGlobalSection)/sgm)
	{
		my $slnConfig = $1;
		
		while ($slnConfig =~ m/(.*?)\n/sgm)
		{
			my $lineSLN = $1;
			
			#{7D1FD0B0-A81D-4A7D-B399-37F8B9107D3F}.Debug|Win32.Build.0 = Debug|Win32
			
			$lineSLN =~ /{[\w\d\-]+}\.(.*?)\.(.*?)[\s]*=[\s]*(.*?)$/;
			my $configFirst = $1;
			my $configSecond = $3;
			
			$lineToRemoved = 1;
			
			foreach $configToKeep (@vcConfigListToKeep)
			{				
				if ($configFirst =~ /$configToKeep/i)
				{
					if ($configSecond =~ /$configToKeep/i)
					{
						$lineToRemoved = 0;
						#print STDOUT "SLN - keeping <$configFirst>\n";
					}
				}
			}
			
			if ($lineToRemoved == 1)
			{
				#print STDOUT "SLN - removing <$configFirst>\n";
				
				$lineSLN =~ s/[\\]{0}\|/\\\|/sgm;
				$content =~ s/$lineSLN\n//;
			}
		}
	}

	my $solutionFullPath = $outputPath.$solutionFilename;
	while ($solutionFullPath =~ s/\//\\/) {}
	PrepareDirectory($solutionFullPath);

	my $slnOUT = new IO::File;
	open($slnOUT, ">$solutionFullPath") || die "open: $!";
	print $slnOUT $content;
	close($slnOUT);
}

#-------------------------------------------------------------------------
sub FileHandlerRC
{
	my $resFilename = shift;
	$resFilename =~ /(.*?)[\w]+\.rc$/i;
	my $relPath = $1;
	
	#FileHandlerGeneric($resFilename);
	
	print STDOUT "FileHandlerRC() <$resFilename>\n";
	
	my $resIN = new IO::File;
	open($resIN, $sourcePath.$resFilename) || die "open: $!";
	
	undef $/;
	my $content = <$resIN>;
	close($resIN);
	$/ = "\n";
	
	while ($content =~ m/[\s]+CURSOR[\s]+\"(.*?)\"/sgm)
	{
		FileHandlerGeneric($relPath.$1);
	}

	while ($content =~ m/[\s]+ICON[\s]+\"(.*?)\"/sgm)
	{
		FileHandlerGeneric($relPath.$1);
	}
	
	if ($tagBuildNumber)
	{
		while ($content =~ s/VALUE[\s]+\"FileVersion\",[\s]+\"[\d]+, [\d]+, [\d]+, 1\"/VALUE \"FileVersion\", \"1, 1, 1, $tagBuildNumber\"/sgm) {}
	
		while ($content =~ s/VALUE[\s]+\"ProductVersion\",[\s]+\"[\d]+, [\d]+, [\d]+, 1\"/VALUE \"FileVersion\", \"1, 1, 1, $tagBuildNumber\"/sgm) {}
		
		while ($content =~ s/FILEVERSION [\d]+,[\d]+,[\d]+,1[\n\s]+/FILEVERSION 1,1,1,$tagBuildNumber\n/sgm) {}
		
		while ($content =~ s/PRODUCTVERSION[\s]+[\d]+,[\d]+,[\d]+,1[\n\s]+/PRODUCTVERSION 1,1,1,$tagBuildNumber\n/sgm) {}
	}
	
	my $resFullPath = $outputPath.$resFilename;
	while ($resFullPath =~ s/\//\\/) {}
	
	my $resOUT = new IO::File;

	PrepareDirectory($resFullPath);

	open($resOUT, ">$resFullPath") || die "open: $!";
	print $resOUT $content;
	close($resOUT);
	
}

#-------------------------------------------------------------------------
sub FileHandlerCDF
{
	my $cdfFilename = shift;
	
	my $cdfPath;
	while ($cdfFilename =~ m/(.*?)([\\\/]+)/sg)
	{
		$cdfPath = $cdfPath.$1.$2;
	}
	
	#print STDOUT "FileHandlerCDF <$cdfFilename>\n";
	
	#<Model File="objects/characters/human/asian/rifleman_light/rifleman_light.chr"/>
	#<Attachment AName="head" Type="CA_SKIN" Rotation="1,0,0,0" Position="0,0,0" BoneName="" Binding="objects/characters/heads/asian/asian_01/asian_01.chr" Flags="0"/>
	#<Attachment AName="helmet" Type="CA_BONE" Rotation="1.31134e-007,-0,0,-1" Position="-7.05576e-009,0.0269028,1.81651" 
	#    BoneName="Bip01 Head" Binding="objects/characters/attachment/asian/helmets/asian_helmet_01.cgf" Flags="0" 
	#    Material="Objects/Characters/Attachment/Asian/Helmets/asian_helmet_02"/>
	
	my $cdfIN = new IO::File;
	if (open($cdfIN, $sourcePath.$cdfFilename))
	{
		undef $/;
		my $content = <$cdfIN>;	
		close($cdfIN);
		$/ = "\n";
		
		FileHandlerGeneric($cdfFilename);
		
		while ($content =~ m/<Model[\s]+(.*?)>/sgm)
		{
			my $modelContent = $1;
			
		  if ($modelContent =~ /File=\"(.*?)\"/)
		  {
		  	my $filename = $1;
	  		FileHandler("Game/".$filename);
			}
		}
		
		while ($content =~ m/<Attachment[\s]+(.*?)>/sgm)
		{
			my $attachContent = $1;
			
		  if ($attachContent =~ /Binding=\"(.*?)\"/)
		  {
		  	my $filename = $1;
		  	FileHandler("Game/".$filename);
			}
			
			if ($attachContent =~ /Material=\"(.*?)\"/)
		  {
		  	my $filename = $1;
		  	FileHandler("Game/".$filename."\.mtl");
			}
		}
	}
}

#-------------------------------------------------------------------------
sub AddMaterialsFromFile
{
	my $objectFilename = shift;
	
	my $objectPath;
	while ($objectFilename =~ m/(.*?)([\\\/]+)/sg)
	{
		$objectPath = $objectPath.$1.$2;
	}
	
	my $mtlnames = `$MaterialNameTool \"$sourcePath$objectFilename\"`;
	
	while ($mtlnames =~ m/(.*?)[\n]/sgm)
	{
		my $mtlFilename = $1;
		#print STDOUT "mtl from the object: <$mtlFilename\.mtl> from path <$objectPath$>\n";
		
		if ($mtlFilename =~ /^Objects(\\|\/)/i)
		{
			$mtlFilename = "Game\/".$mtlFilename;
		}
		else
		{
			$mtlFilename = $objectPath.$mtlFilename;
		}
		
		#if (not $materialFilename =~ /^Game(\\|\/)/i)
		#{
		#	$materialFilename = $cgfPath.$materialFilename."\.mtl";
		#}
		
		FileHandler("$mtlFilename\.mtl");	
	}
}

#-------------------------------------------------------------------------
sub FileHandlerCGA
{
	my $cgaFilename = shift;
	my $cgaPath;
	while ($cgaFilename =~ m/(.*?)([\\\/]+)/sg)
	{
		$cgaPath = $cgaPath.$1.$2;
	}
	
	$cgaFilename =~ /(.*?)\.cga$/i;
	$cgaPrefix = $1;
	
	FileHandlerGeneric($cgaFilename);
	
	AddMaterialsFromFile($cgaFilename);
	
	chdir $sourcePath;
	my @files = <Game/$cgaPath*>;
	chdir $currentPath;
		
	foreach $file (@files) 
	{
		if ($file =~ /\.anm$/i and $file =~ /$cgaPrefix/i)
		{
			FileHandlerGeneric($file);
		}
	}
}

#-------------------------------------------------------------------------
sub FileHandlerCHR
{
	my $chrFilename = shift;
	#print STDOUT "\n\n$chrFilename\n\n";
	
	my $chrPath;
	while ($chrFilename =~ m/(.*?)([\\\/]+)/sg)
	{
		$chrPath = $chrPath.$1.$2;
	}
		
	$chrFilename =~ /(.*?)\.chr$/i;
	$chrPrefix = $1;
	
	FileHandlerGeneric($chrFilename);
	
	$chrFilename =~ /(.*?)\.chr/i;
	FileHandler($1.".cal");
	
	AddMaterialsFromFile($chrFilename);
}

#-------------------------------------------------------------------------
sub FileHandlerCGF
{
	my $cgfFilename = shift;
	
	FileHandlerGeneric($cgfFilename);
	
	AddMaterialsFromFile($cgfFilename);
}

#-------------------------------------------------------------------------
sub FileHandlerMTL
{
	my $mtlFilename = shift;
	
	my $mtlIN = new IO::File;
	if (open($mtlIN, $sourcePath.$mtlFilename))
	{
		undef $/;
		my $content = <$mtlIN>;	
		close($mtlIN);
		$/ = "\n";
		
		#<Texture Map="Normalmap" File="objects/characters/human/us/nanosuit/nanosuit_us_ddn.tif" Filter="7" Amount="50">
		
		while ($content =~ m/<Texture[\s]+(.*?)>/sgm)
		{
			my $result = $1;
			
		  if ($result =~ /File=\"(.*?)\"/)
		  {
		  	my $filename = "Game\/".$1;
		  	#print STDOUT "material: <$filename>\n";
	
				if (-e $sourcePath.$filename)
				{
					#print STDOUT " - sourcemat: <$filename>\n";
		  		FileHandlerGeneric($filename);
		  	}
		  	
		  	# if the path goes to a tif file, we try to also include 
		  	# the dds, if available
		  	
		  	if ($filename =~ /(.*?)\.tif/i)
		  	{
		  		my $ddsFilename = "$1.dds";
		  		#print STDOUT " ... <$sourcePath |hey| $ddsFilename>\n";
		  		if (-e $sourcePath.$ddsFilename)
					{
						#print STDOUT " - dds: <$ddsFilename>\n";
		  			FileHandlerGeneric($ddsFilename);
		  		}
		  	}
			}
		}
		
		FileHandlerGeneric($mtlFilename);
	}
}

#-------------------------------------------------------------------------
sub FileHandlerENT
{
	my $entFilename = shift;
	
	my $entIN = new IO::File;
	if (not open($entIN, $sourcePath.$entFilename))
	{
		return;
	}
	
	undef $/;
	my $content = <$entIN>;	
	close($entIN);
	$/ = "\n";

	FileHandlerGeneric($entFilename);
	
	while ($content =~ m/Script=\"(.*?)\"/sgm)
	{
		my $scriptFilename = $1;
		FileHandler("Game/$scriptFilename");
	}
}

#-------------------------------------------------------------------------
sub FileHandlerXML
{
	my $xmlFilename = shift;
	
	#print STDOUT "FileHandlerXML <$xmlFilename>\n";
	
	my $xmlIN = new IO::File;
	if (not open($xmlIN, $sourcePath.$xmlFilename))
	{
		return;
	}
	
	FileHandlerGeneric($xmlFilename);
	
	undef $/;
	my $content = <$xmlIN>;	
	
	close($xmlIN);
	$/ = "\n";
		
	if ($content =~ /^<Vehicle[\s]+/)
	{
		$content =~ /<Vehicle(.*?)name=\"(.*?)\"(.*?)>/;
		$soundName = lc($2);
		
		print STDOUT "adding $soundName\n";
		
		$g_filters{"fdp"}{"Vehicles"}{$soundName} = 1;
		
		#<Animated filename="Objects/Vehicles/ltv/ltv.cga" filenameDestroyed="Objects/Vehicles/ltv/ltv_damaged.cga" id="idAnimatedPart"/>
		
		while ($content =~ m/<Animated[\s]+(.*?)>/g)
		{
			my $animatedContent = $1;
			
			if ($animatedContent =~ /filename[\s]?=\"(.*?)\"/)
			{
				FileHandler("Game/$1");
			}
			
			if ($animatedContent =~ /filenameDestroyed[\s]?=\"(.*?)\"/)
			{
				FileHandler("Game/$1");
			}
		}
		
		while ($content =~ m/<Static[\s]+(.*?)>/g)
		{
			my $staticContent = $1;
			
			if ($staticContent =~ /filename[\s]?=\"(.*?)\"/)
			{
				FileHandler("Game/$1");
			}
			
			if ($staticContent =~ /filenameDestroyed[\s]?=\"(.*?)\"/)
			{
				FileHandler("Game/$1");
			}
		}
		
		#<Paint name="" material="objects/vehicles/ltv/us_ltv.mtl"/>
		while ($content =~ m/<Paint[\s]+(.*?)>/g)
		{
			my $paintContent = $1;
			
			if ($paintContent =~ /material=\"(.*?)\"/)
			{
				FileHandler("Game/$1");
			}
		}
		
		#<Weapon class="VehicleShiTenV2" part="shiten">
		while ($content =~ m/<Weapon[\s]+(.*?)>/g)
		{
			my $weaponContent = $1;
			
			if ($weaponContent =~ /class=\"(.*?)\"/)
			{
				FileHandler("Game/Scripts/Entities/Items/XML/Weapons/Vehicles/$1");
			}
		}
		
		my $luaFilename = $xmlFilename;
		$luaFilename =~ s/Xml[\\\/]+(.*?)\.xml$/$1\.lua/i;
		
		FileHandlerGeneric($luaFilename);
	}	
	
	#<item
	#<geometry>
	#	<firstperson name="objects/weapons/us/scar/scar_l-c_fp.chr" angles="0,0,0" position="0,0,0" />
	#	<thirdperson name="objects/weapons/us/scar/scar_l-c_tp.cgf" angles="0,0,0"/>
	#</geometry>
	
	if ($content =~ /^<item[\s]+/)
	{
		while ($content =~ m/<geometry>(.*?)(<\/geometry>)/sgm)
		{
			my $geomContent = $1;
			
			while ($geomContent =~ m/<firstperson[\s]+(.*?)\/>/sgm)
			{
				my $subGeomContent = $1;
				#print STDOUT "1st person geom...\n$subGeomContent\n---\n\n";
				if ($subGeomContent =~ m/name\=\"(.*?)\"/sgm)
				{
					FileHandler("Game/$1");
				}
			}
			
			while ($geomContent =~ m/<thirdperson[\s]+(.*?)\/>/sgm)
			{
				my $subGeomContent = $1;
				if ($subGeomContent =~ m/name=\"(.*?)\"/sgm)
				{
					FileHandler("Game/$1");
				}
			}
		}
	}

	if ($content =~ /^<ammo[\s]+/)
	{
		while ($content =~ m/<geometry>(.*?)(<\/geometry>)/sgm)
		{
			my $geomContent = $1;
			
			while ($geomContent =~ m/<firstperson[\s]+(.*?)\/>/sgm)
			{
				my $subGeomContent = $1;
				if ($subGeomContent =~ m/name\=\"(.*?)\"/sgm)
				{
					FileHandler("Game/$1");
				}
			}
			
			while ($geomContent =~ m/<thirdperson[\s]+(.*?)\/>/sgm)
			{
				my $subGeomContent = $1;
				if ($subGeomContent =~ m/name=\"(.*?)\"/sgm)
				{
					FileHandler("Game/$1");
				}
			}
		}
	}
	
	if ($content =~ /^<ParticleLibrary[\s]+/)
	{
		while ($content =~ m/Texture=\"(.*?)\"/sgm)
		{
			my $textureFilename = $1;
			FileHandler("Game/$textureFilename");
		}
		
		while ($content =~ m/Geometry=\"(.*?)\"/sgm)
		{
			my $geomFilename = $1;
			FileHandler("Game/$geomFilename");
		}
		
		while ($content =~ m/Material=\"(.*?)\"/sgm)
		{
			my $mtlFilename = $1;
			FileHandler("Game/$mtlFilename.mtl");
		}
	}
}

#-------------------------------------------------------------------------
sub FindAssetsInTag
{
	my $tagLine = shift;
	
	if ($tagLine =~ m/Geometry=\"(.*?)\"/sgm)
	{
		FileHandler("Game/$1");
	}
					
	if ($tagLine =~ m/object_[\w]+=\"(.*?)\"/sgm)
	{
		my $assetFilename = "Game/$1";
		FileHandler($assetFilename);
		print STDOUT "- asset!: <$assetFilename>\n";
	}
					
	if ($tagLine =~ m/fileModel=\"(.*?)\"/sgm)
	{
		my $assetFilename = "Game/$1";
		print STDOUT "fileModel: <$assetFilename>\n";						
		FileHandler("Game/$1");
	}
					
	if ($tagLine =~ m/objFrozenModel=\"(.*?)\"/sgm)
	{						
		FileHandler("Game/$1");
	}
	
	if ($tagLine =~ m/Type=\"EntityArchetype\"/sgm)
	{
		print STDOUT "1...\n";
		if ($tagLine =~ m/Prototype=\"\{(.*?)\}\"/)
		{
			AddArchetype($1);
			print STDOUT "2...\n";
		}
	}
	
	if ($tagLine =~ m/Type\=\"Prefab\"/sgm)
	{
		if ($tagLine =~ m/PrefabName=\"(.*?)\"/)
		{
			my $prefabID = $1;
			print STDOUT "prefab name: <$prefabID>\n";
			AddPrefab($prefabID);
		}
	}
	
	if ($tagLine =~ m/Type\=\"Brush\"/sgm)
	{
		if ($tagLine =~ m/Prefab=\"(.*?)\"/)
		{
			my $objName = $1;
			FileHandler("Game\\$objName");
		}
	}
	
	#equip_EquipmentPack="Asian_Rifleman"
	
	if ($tagLine =~ m/equip_EquipmentPack=\"(.*?)\"/sgm)
	{
		my $equipPack = "Game\/Libs\/EquipmentPacks\/$1\.xml";
		FileHandler($equipPack);
		print STDOUT "equipPack: $equipPack\n";
	}
}

@g_archLibs;

#-------------------------------------------------------------------------
sub FileHandlerCRY
{
	my $cryFilename = shift;
	
	FileHandlerGeneric($cryFilename);
	
	$extractOutput = `$UnzipCmd $sourcePath$cryFilename level.editor_xml -d $outputPath`;
	print STDOUT "extracted this: <$extractOutput>\n";
		
	if ($extractOutput =~ m/(inflating|extracting):[\s]+(.*?)[\s]+/sg)
	{
		my $levelEditorFilename = $2;
		print STDOUT "Ok, this <$levelEditorFilename>\n";
		
		if ($levelEditorFilename =~ /level\.editor_xml/i)
		{
			print STDOUT "Ok, level editor xml is there\n";
			
			my $levedIN = new IO::File;
			if (open($levedIN, $levelEditorFilename))
			{
				undef $/;
				my $content = <$levedIN>;	
				close($levedIN);
				$/ = "\n";
				
				while ($content =~ m/<EntityPrototypesLibs>(.*?)<\/EntityPrototypesLibs>/sg)
				{
					my $protoLibs = $1;
					print STDOUT "we've got some proto libs...\n";
					
					while ($protoLibs =~ m/<Library[\s]+Name=\"(.*?)\"\/>/sg)
					{
						my $libName = $1;
						print STDOUT "Library: <$libName>\n";
						push @g_archLibs, $libName;
					}
				}

				#<Object Type="Prefab"
				while ($content =~ m/<Object(.*?)(\/>|<\/Object>)/sg)
				{
					my $objectTag = $1;
					
					FindAssetsInTag($objectTag);
				}
				
				unlink($levelEditorFilename);
			}
			else
			{
				print STDOUT "error reading the extracted mission file <$levelEditorFilename> from the level <$cryFilename>\n";
			}
		}
	}
}

#-------------------------------------------------------------------------
sub AddPrefab
{
	my $prefabID = shift;
	
	print STDOUT "AddPrefab() used with <$prefabID>\n";

	#Buildings.village.village_house_8
	if ($prefabID =~ /^([\s\w\d]+).(.*?)$/)
	{
		$prefabFile = $1;
		$prefabName = $2;
		
		print STDOUT "prefabFile = <$prefabFile> and prefabName = <$prefabName>\n";
	}
	else
	{
		print STDOUT "error parsing the prefab id\n";
		return;
	}
		
	print STDOUT "prefabFile = <$prefabFile> and prefabName = <$prefabName>\n";
	my $prefabPath = "Game\\Prefabs\\$prefabFile.xml";
	my $prefabContent;
	
	my $prefabSourceIN = new IO::File;
	if (not open($prefabSourceIN, "$sourcePath$prefabPath"))
	{
		print STDOUT "Warning: could not open prefab lib $sourcePath$prefabPath\n";
		return;
	}
	
	undef $/;
	$archSourceContent = <$prefabSourceIN>;
	close($prefabSourceSourceIN);
	$/ = "\n";
 
	my $prefabTag;
	
	#<Prefab Name="village.village_house_8" Id="{8B2436C3-2DFE-4ED7-BBBC-AB52C1E0ACFD}">
	while ($archSourceContent =~ m/<Prefab(.*?)<\/Prefab>/sgm)
	{
		my $tag = $1;
		
		$prefabNameSearch = $prefabName;
		$prefabNameSearch =~ s/[\\]{0}\./\\\./g;
		
		if ($tag =~ /Name=\"$prefabNameSearch\"/sgmi)
		{
			$prefabTag = "<Prefab$tag<\/Prefab>";
			print STDOUT "found it...\n";
		}		
	}
	
	if (not $prefabTag)
	{
		print STDOUT "error: Could not find prefab <$prefabName> inside of <$prefabPath>\n";
		return;
	}
	
	while ($prefabTag =~ m/<Object[\s]+(.*?)(<\/Object>|\/>)/sgm)
	{
		FindAssetsInTag($1);
	}
	
	my $prefabIN = new IO::File;
	if (open($prefabIN, "$outputPath$prefabPath"))
	{
		undef $/;
		$prefabContent = <$prefabIN>;
		close($prefabIN);
		$/ = "\n";
		
		if ($prefabContent =~ m/Name=\"$prefabName\"/sgm)
		{
			print STDOUT "skipping adding this prefab since it's already present...\n";
			return;
		}
	}
	
	if (not $prefabContent =~ /<PrefabsLibrary/)
	{
		my $prefabLibName = "prefabFile";
		if ($archSourceContent =~	m/<PrefabsLibrary[\s]+Name=\"(.*?)\">/sgm)
		{
			$prefabLibName = $1;
		}
		
		$prefabContent = "<PrefabsLibrary Name=\"$prefabLibName\">\n</PrefabsLibrary>\n";
	}
	
	PrepareDirectory("$outputPath$prefabPath");
	
	print STDOUT "writing back the prefab to $outputPath$prefabPath\n";
	
	my $prefabOUT = new IO::File;
	if (open($prefabOUT, ">$outputPath$prefabPath"))
	{
		$prefabContent =~ s/<\/PrefabsLibrary>/$prefabTag\n<\/PrefabsLibrary>/;
		
		print STDOUT "writing prefab to <$outputPath$prefabPath>\n";
		
		undef $/;
		print $prefabOUT $prefabContent;
		close($prefabOUT);
		$/ = "\n";
	}
}

#-------------------------------------------------------------------------
sub FileHandlerPAK
{
	my $pakFilename = shift;
	
	FileHandlerGeneric($pakFilename);
	
	if ($pakFilename =~ /^Game\/Levels(.*?)level.pak/i)
	{	
		$pakFilename =~ /Game\/Levels\/(.*?)\/level.pak/;
		$levelPath = "$outputPath";
		
		my $extractOutput = `$UnzipCmd $sourcePath$pakFilename mission_*.xml -d $outputPath`;
		
		while ($extractOutput =~ m/(inflating|extracting):[\s]+(.*?)[\s]+\n/sg)
		{
			my $missionFilename = $2;
			
			my $missionIN = new IO::File;
			if (open($missionIN, $missionFilename))
			{
				undef $/;
				my $missionContent = <$missionIN>;	
				close($missionIN);
				$/ = "\n";
				
				while ($missionContent =~ m/<Entity(.*?)\/>/sgm)
				{
					my $tagContent = "<Entity$1\/>";
					
					FindAssetsInTag($tagContent);
				}
			}
			else
			{
				print STDOUT "error reading the extracted mission file <$missionFilename> from the level <$pakFilename>\n";
			}
			
			unlink($missionFilename);
		}
		
		$extractOutput = `$UnzipCmd $sourcePath$pakFilename leveldata.xml -d $outputPath`;
		
		if ($extractOutput =~ m/(inflating|extracting): (.*?)[\s]+\n/sg)
		{
			my $levelFilename = $2;
			
			my $leveldataIN = new IO::File;
			if (open($leveldataIN, $levelFilename))
			{
				undef $/;
				my $dataContent = <$leveldataIN>;	
				close($leveldataIN);
				$/ = "\n";
				
				while ($dataContent =~ m/<Objects(.*?)\/>/isgm)
				{
					my $tagContent = "<Objects$1\/>";
					
					if ($tagContent =~ /FileName=\"(.*?)\"/)
					{
						my $brushFilename = $1;
						FileHandler("Game/$brushFilename");
					}
				}
			}
			
			unlink($levelFilename);
		}
		
		$extractOutput = `$UnzipCmd $sourcePath$pakFilename terrain\\heightmap.dat -d $outputPath`;
		
		if ($extractOutput =~ m/(inflating|extracting):[\s]+(.*?)[\s]+/sgi)
		{
			my $heightmapFilename = $2;
			
			my $heightmapIN = new IO::File;
			if (open($heightmapIN, $heightmapFilename))
			{
				undef $/;
				my $dataContent = <$heightmapIN>;	
				close($heightmapIN);
				$/ = "\n";
				
				while ($dataContent =~ m/objects\/([\w\ \d\-_\\\/]+)\.([\w]{3,})/isgm)
				{
					my $assetFilename = "objects\/$1\.$2";
					FileHandler("Game/$assetFilename");
				}
			}
			
			unlink($heightmapFilename);
		}
	}
}

#-------------------------------------------------------------------------
sub GetArchetypeLib
{
	my $archetypeId = shift;
	
	foreach (@g_archLibs) 
	{
		my $archLib = $_;
		
		print STDOUT "we look into <$sourcePath\\Game\\Libs\\EntityArchetypes\\$archLib>\n";
		
		my $archSourceIN = new IO::File;
		if (open($archSourceIN, "$sourcePath\\Game\\Libs\\EntityArchetypes\\$archLib.xml"))
		{
			undef $/;
			$archSourceContent = <$archSourceIN>;
			close($archSourceSourceIN);
			$/ = "\n";
			
			while ($archSourceContent =~ m/<EntityPrototype(.*?)<\/EntityPrototype>/sg)
			{
				my $tag = $1;
				
				while ($tag =~ /Id=\"\{$archetypeId\}\"/)
				{
					return $archLib;
				}
			}
		}
	}
}

#-------------------------------------------------------------------------
sub AddArchetype
{
	my $archetypeId = shift;
	
	print STDOUT "AddArchetype() used with <$archetypeId>\n";
	
	#$archetypeLine =~ s/^(.*?)\.//;
	my $archetypeLib = GetArchetypeLib($archetypeId);
	print STDOUT "archetypeLib = $archetypeLib\n";
	
	my $archetypePath = "Game\\Libs\\EntityArchetypes\\$archetypeLib.xml";
	my $archContent;
	
	my $archSourceIN = new IO::File;
	if (not open($archSourceIN, "$sourcePath$archetypePath"))
	{
		print STDOUT "Warning: could not open archetype lib $sourcePath$archetypePath\n";
		return;
	}
	
	undef $/;
	$archSourceContent = <$archSourceIN>;
	close($archSourceSourceIN);
	$/ = "\n";
 
	my $archTag;
	
	my $archetypeMatch = $archetypeLine;
	$archetypeMatch =~ s/\\/\\\\/g;
	
	while ($archSourceContent =~ m/<EntityPrototype(.*?)<\/EntityPrototype>/sgm)
	{
		my $entProtoTag = $1;
		
		if ($entProtoTag =~ /Id=\"\{$archetypeId\}\"/i)
		{
			$archTag = "<EntityPrototype$entProtoTag</EntityPrototype>";
		}
	}
	
	if (not $archTag)
	{
		print STDOUT "error: Could not find archetype lib <$archetypeLine> inside of <$archetypePath>\n";
		return;
	}
	else
	{
		#print STDOUT " - could find <$archetypeLine>\n";
	}
	
	my $archIN = new IO::File;
	if (open($archIN, "$outputPath$archetypePath"))
	{
		undef $/;
		$archContent = <$archIN>;
		close($archIN);
		$/ = "\n";
		
		if ($archContent =~ m/Name=\"$archetypeMatch\"/sgm)
		{
			print STDOUT "skipping adding the archetype since it's already present...\n";
			return;
		}
	}
	
	if (not $archContent =~ /<EntityPrototypeLibrary/)
	{
		$archContent = "<EntityPrototypeLibrary Name=\"$archetypeLib\" SandboxVersion=\"1.1.1.$tagBuildNumber\">\n<\/EntityPrototypeLibrary>\n";
	}
	
	PrepareDirectory("$outputPath$archetypePath");
	
	print STDOUT "writing back the archetype to $outputPath$archetypePath\n";
	
	my $archOUT = new IO::File;
	if (open($archOUT, ">$outputPath$archetypePath"))
	{
		$archContent =~ s/<\/EntityPrototypeLibrary>/$archTag\n<\/EntityPrototypeLibrary>/;
		
		print STDOUT "writing archetype to <$outputPath$archetypePath>\n";
		
		undef $/;
		print $archOUT $archContent;
		close($archOUT);
		$/ = "\n";
	}
	
	FindAssetsInTag($archTag);
}

#-------------------------------------------------------------------------
sub cmdOpenPak
{
	my $l = shift;
	
	if ($l =~ /^openpak[\s]+(.*?)\.pak[\s]+(.*?)$/i)
	{
		$pakFilename = $1;
		$pakLocalPath = $2;
	}
}

#-------------------------------------------------------------------------
sub cmdClosePak
{
	my $pakFilenameFilt = $pakFilename;
	while ($pakFilenameFilt =~ s/(\\|\/)/_/) {}
	my $pakList = $outputPath.$pakFilenameFilt."PakList.txt";
	
	PrepareDirectory($pakList);
	
	my $paklistOUT = new IO::File;
	
	while ($pakLocalPath =~ s/\//\\\\/) {}
	
	open($paklistOUT, ">$pakList") || die "open: $pakList\nerror: $!";
	
	while ($#fileList >= 0)
	{
		if ($file = pop(@fileList))
		{
			while ($file =~ s/(\\\\|\/)/\\/) {}
			$file =~ s/^$pakLocalPath//i;
			
			print $paklistOUT $file;
		}
	}
	
	close($paklistOUT);
	
	my $pakPath = $outputPath.$pakLocalPath.$pakFilename;
	$pakPath =~ s/\//\\/;
	
  my $cmd = $ZipCmd." ".$ZipPakArg." ".$pakPath.".pak @".$pakList;
  
  PrepareDirectory("$pakPath.pak");
  chdir($sourcePath.$pakLocalPath);
  system($cmd);
  
  chdir($currentPath);
  
  unlink($pakList);
	
	$pakFilename = "";
	$pakLocalPath = "";
	@fileList = ();
}

#-------------------------------------------------------------------------
sub cmdBeginCopy
{
	my $l = shift;
	
	if ($l =~ /^begincopy[\s]+(.*?)$/i)
	{
		$pakLocalPath = $1;
	}
}

#-------------------------------------------------------------------------
sub cmdEndCopy
{		
	while ($#fileList >= 0)
	{
		if ($file = pop(@fileList))
		{
			$file =~ s/\n$//;
			PrepareDirectory("$outputPath$file");
			
			my $outputFile = "$outputPath$file";
			
			if (copy("$sourcePath$file", $outputFile))
			{
				my $attr;
				$attr = NORMAL;
				Win32::File::SetAttributes($outputFile, $attr);
			}
			else
			{
				print STDOUT "Error: File <$sourcePath$file> cannot be copied\n";
			}
		}
	}
	
	$pakFilename = "";
	$pakLocalPath = "";
	@fileList = ();
}

#-------------------------------------------------------------------------
sub cmdFile
{
	my $line = shift;
	
	if ($line =~ /^file([+]?)[\s]+(.*$)[\n]?$/i)
	{
		my $opt = $1;
		my $file = $2;
		
		if ($file =~ /\.(.*?)$/)
		{
			my $ext = $1;
			my $fileHandler;
			
			if ($opt eq "+" and $fileHandler = $fileHandlers{$ext})
			{
				$fileHandler->($file);
			}
			else
			{
				FileHandlerGeneric($file);
			}
		}
	}
}

#-------------------------------------------------------------------------
sub cmdDir
{
	my $line = shift;
	
	if ($line =~ /^dir([\+]?)[\s]+(.*$)[\n]?$/i)
	{
		my $opt = $1;
		my $localPath = $2;
		
		$localPath =~ s/\\$//;
		$localPath =~ s/\/$//;
		while ($localPath =~ s/([^\\])\ /$1\\\ /) {}
		
		chdir $sourcePath;
		my @files = <$localPath/*>;
		chdir $currentPath;
		
		foreach $file (@files) 
		{			
			if (-d $sourcePath.$file)
			{
				if ($opt =~ /^\+/)
				{
					cmdDir("dir+ $file");
				}
			}
			elsif (-f $sourcePath.$file)
			{				
				FileHandlerGeneric($file);
			}
		}
	}
}

#-------------------------------------------------------------------------
sub cmdExclude
{
	my $line = shift;
	
	if ($line =~ /^exclude[\s]+(.*$)[\n]?$/i)
	{
		my $filter = $1;
		
		#while ($filter =~ /\//\\/) {};
		
		foreach $file (@fileList) 
		{
			if ($file =~ /$filter/i)
			{
				$file = "";
			}
		}
	}
}

#-------------------------------------------------------------------------
sub cmdTagBuild
{
	my $line = shift;
	
	if ($line =~ /([0-9]+)$/)
	{
		$tagBuildNumber = $1;
		print STDOUT "tagging build #$tagBuildNumber\n";
	}
}

%g_filters;

#-------------------------------------------------------------------------
sub cmdAddFilter
{
	#addfilter fdp Vehicles Asian_helicopter
	my $filterLine = shift;
	
	$filterLine =~ /^[\w]+[\s]+([\w\d]+)[\s]+([\w\d\*]+)[\s]+([\w\d\*]+)/;
	my $fileFormat = $1;
	my $group = $2;
	my $value = $3;
	
	print STDOUT "adding filter fileFormat <$fileFormat>, group <$group>, value <$value>\n";
	
	$g_filters{$fileFormat}{$group}{$value} = 1;
}

#-------------------------------------------------------------------------
sub cmdRemoveFilter
{
}

#-------------------------------------------------------------------------
sub FileHandlerFDP
{
	my $fdpFilename = shift;
	$fdpFilename =~ /(.*?)\/([\w\d]+)\.[\w]+$/;
	my $fdpPath = $1."\/";
	my $libName = $2;
	my $fileFormat = "fdp";
	
	
	print STDOUT "FileHandlerFDP() with <$fdpFilename> which is <$libName>\n\n";
		
	my $fdpIN = new IO::File;
	if (not open($fdpIN, "$sourcePath$fdpFilename"))
	{
		print STDOUT "error opening <$sourcePath$fdpFilename>\n";
		return;
	}
	
	undef $/;
	my $fdpContent = <$fdpIN>;
	close($fdpIN);
	$/ = "\n";
	
	#print STDOUT "$fdpContent\n";
	
	my $soundDefs = "";
	@soundGroupsToRemove;
	
	my $over = 1;
	
	while ($fdpContent =~ m/<eventgroup>(.*?)<\/eventgroup>/csgm)
	{
		#<eventgroup>
		#</eventgroup>
		my $eventgroupTag = "<eventgroup>$1<\/eventgroup>";
		
		if ($eventgroupTag =~ /<name>(.*?)<\/name>/sgm)
		{
			my $eventgroup = $1;
 
 			if ($g_filters{$fileFormat}{$libName}{$eventgroup} == 1)
			{
				print STDOUT "we're keeping: <$eventgroup>\n";
				
				while ($eventgroupTag =~ m/<sound>[\s]+<name>(.*?)<\/name>(.*?)<sound>/sgm)
				{
					my $soundName = $1;
					$soundDefs = $soundDefs.$soundName."\n";
					print STDOUT "   pushed $soundName\n";
				}
			}
			else
			{
				print STDOUT "removing group: <$eventgroup>\n";
				
				#$fdpContent =~ s/$eventgroupTag//;
				#if ($fdpContent =~ s/$eventgroupTag/---/)
				#{
				#}
				#else
				#{
					#print STDOUT "failed to remove the eventgroup\n";
				#}
				
				push @soundGroupsToRemove, $eventgroup;
				
				$over = $over + 1;
				
				#$fdpContent =~ s/<eventgroup>[\s]*<name>$eventgroup<\/name>(.*?)<\/eventgroup>[\s]*//s;
				
				#<event>
				#<name>heavy_vtol_constant_run</name>
				
				if ($eventgroupTag =~ m/<event>[\s]+<name>(.*?)<\/name>/sgm)
				{
					#$fdpContent =~ s/<event>[\s]+<name>$1<\/name>(.*?)<\/event>//s;
				}
			}
		}
	}
	
	while (my $eventgroup = pop(@soundGroupsToRemove))
	{
		$fdpContent =~ s/<eventgroup>[\s]*<name>$eventgroup<\/name>(.*?)<\/eventgroup>[\s]*//s;
	}
	
	#sounddef
	
	print STDOUT "\#\#\# soundDefs\n";
	
	my %sounddefUsage;
	my $soundAssets;
	my $soundBanks;
	
	while ($fdpContent =~ m/<sounddef>(.*?)<\/sounddef>/sgm)
	{
		my $soundDefTag = "<sounddef>$1<\/sounddef>";
		my $wasUsed = 2;

		if ($soundDefTag =~ m/<name>(.*?)<\/name>/gm)
		{
			my $soundName = $1;

			if ($soundDefs =~ /$soundName/igs)
			{
				$wasUsed = 1;
				
				print STDOUT "soundName = <$soundName>\n";
				
				$sounddefUsage{$soundName} = 4;
				
				if ($soundDefTag =~ m/<filename>(.*?)<\/filename>/sgm)
				{
					#todo FileHandler($fdpPath.$1);
				}
				
				if ($soundDefTag =~ m/<soundbankname>(.*?)<\/soundbankname>/gm)
				{
					$soundBank = $1;
					
					if (not $soundBanks =~ /$soundBank/)
					{
						$soundBanks = $soundBanks.$soundBank."\n";
					}
				}
			}
			else
			{
				push @sounddefToRemove, $soundName;
				
				$sounddefUsage{$soundName} = 2;
				
				#print STDOUT "removing sounddef <$soundName>\n";
				#while ($fdpContent =~ s/<sounddef>[\s]+<name>$soundName<\/name>(.*?)<\/sounddef>//s)
				#{
				#	print STDOUT " - removed\n";
				#}
				
				#$fdpContent =~ s/$soundDefTag//s;
				
			}
		}
	}
	
	my $i = 0;
	while (my $sounddef = pop(@sounddefToRemove))
	{
		print STDOUT "removing sounddef <$sounddef>   <$sounddefUsage{$sounddef}>\n";
		
		if ($sounddefUsage{$sounddef} == 4)
		{
			print STDOUT "finally, we cannot remove: <$sounddef>\n";
		}
		else
		{
			$fdpContent =~ s/<sounddef>[\s]+<name>$sounddef<\/name>(.*?)<\/sounddef>[\s]*//s;
			if ($1 =~ /sounddef>/)
			{
				print STDOUT "ERROR - IT'S BAD\n";
			}
		}
		
		$i = $i + 1;
	}
	
	@soundbankToRemove;
	
	while ($fdpContent =~ m/<soundbank>(.*?)<\/soundbank>/sgm)
	{
		my $soundBankTag = "<soundbank>".$1."<\/soundbank>";
		
		my $soundAssetsUsed = 0;
		
		if ($soundBankTag =~ m/<name>(.*?)<\/name>/s)
		{
			my $bankName = $1;
			
			if ($soundBanks =~ /$bankName/)
			{
				print STDOUT "keeping bank <$bankName>\n";
			}
			else
			{
				#print STDOUT "removing bank <$bankName>\n";
				#$fdpContent =~ s/<soundbank>(.*?)<name>$bankName<\/name>(.*?)<\/soundbank>[\n]*//s;
				push @soundbankToRemove, $bankName;
			}
		}
	}
	
	my $i = 0;
	while (my $bankName = pop(@soundbankToRemove) and $i < 1111)
	{
		print STDOUT "removing bank <$bankName>\n";
		$fdpContent =~ s/<soundbank>[\s]+<name>$bankName<\/name>(.*?)<\/soundbank>[\n]*//s;
		
		$i = 1 + $i;
	}
	
	print STDOUT "FILE output <$outputPath$fdpFilename>\n";
	
	PrepareDirectory("$outputPath$fdpFilename");
	
	open($fdpOUT, ">$outputPath$fdpFilename") || print "cannot ouput: $!";
	print $fdpOUT $fdpContent;
	close($fdpOUT);
}

#-------------------------------------------------------------------------
# returns 1 if is it's accepted
#         2 if it's refused
#         3 regardless of the others, we require that condition
sub cmdCPPTestCondition
{
	my $define = shift;
	
	if ($define =~ /(WIN32|WIN64|LINUX)/i)
	{
		print STDOUT "   REQUIRED \"$define\"\n";
		return 3;
	}
	
	if ($define =~ /(PS3|XENON|_XBOX|_XBOX_VER|SPU)/i)
	{
		print STDOUT "   REFUSED \"$define\"\n";
		return 2;
	}
	
	print STDOUT "   accepted \"$define\"\n";
	
	return 1;
}

sub cmdCPPIsAcceptable
{
	my $defines = shift;
	my $isAcceptable = 1;
	my $oppositeRefused = 0;
	
	$defines =~ s/[\s\n]*$/\ /;
	
	print STDOUT "*  cmdCPPIsAcceptable?  <$defines>\n";
	
	if ($defines =~ /([n]?)def[\ \t]+(.*?)[\n]?$/i)
	{
		
		my $condition = $2;
		my $negation;
		if ($1 =~ /n/)
		{
			$negation = 1;
			#print STDOUT "    negation...\n";
		}

		my $testCondition = cmdCPPTestCondition($condition);
		if ($testCondition == 3 and not $negation)
		{
			$isAcceptable = 1;
		}
		elsif ($testCondition == 2)
		{
			if ($negation)
			{
				$oppositeRefused = 1;
			}
			else
			{
				$isAcceptable = 0;
			}
		}
	}

	while ($defines =~ /([!]?)defined[\s]*[(]?(.*?)[)]?[\s]+/gi)
	{
		my $condition = $2;
		my $negation;

		if ($1 =~ /!/)
		{
			$negation = 1;
			print STDOUT "   negation...\n";
		}

		my $testCondition = cmdCPPTestCondition($condition);
		if ($testCondition == 3 and not $negation)
		{
			$isAcceptable = 1;
			last;
		}
		elsif ($testCondition == 2)
		{
			if ($negation)
			{
				$oppositeRefused = 1;
			}
			else
			{
				$isAcceptable = 0;
			}
		}
	}
	
	print STDOUT "*  isAcceptable = $isAcceptable  ($oppositeRefused)\n";
	
	if ($defines =~ /(NOT\_USE\_CRY\_MEMORY\_MANAGER|DEBUG_MEMORY_MANAGER)/)
	{
		return 1;
	}
	
	if ($oppositeRefused > 0 and $isAcceptable > 0)
	{
		return 2;
	}
	
	return $isAcceptable;
}

#-------------------------------------------------------------------------
sub FileHandlerCPP
{
	my $cppFilename = shift;
	my $cppSourcePath = CompletePath($cppFilename, $sourcePath);
	
	print STDOUT "FileHandlerCPP() with <$cppSourcePath>\n\n";
		
	my $cppIN = new IO::File;
	if (not open($cppIN, "$cppSourcePath"))
	{
		print STDOUT "error opening cpp file <$cppSourcePath>\n";
		return;
	}
		
	my $cppOutputPath = CompletePath($cppFilename, $outputPath);
	PrepareDirectory($cppOutputPath);
	open($cppOUT, ">$cppOutputPath") || print "cannot ouput cpp <$cppOutputPath> to because <$!>\n";
	
	my $isDebugTextAdded = 0;
	
	my $nestedIf;
	
	my $isErasing;
	my $eraseLevel;
	
	my @erasionPendingForElse;
	my @removePendingEndif;
	my $erasionLimited;
	
	my $hasCopyrightInfo = 0;
	
	#$cppContent = $cppContent."\n";
		
	foreach $line (<$cppIN>)
	{
		######################################
		
		if ($line =~ /\#[\ \t]*endif/i)
		{
			my $nextEndifToRemove = pop(@removePendingEndif);
			
			if ($nextEndifToRemove)
			{
				if ($nextEndifToRemove == $nestedIf)
				{
					$line = "\n";
				}
				else
				{
					push(@removePendingEndif, $nextEndifToRemove);
				}
			}
			
			my $toBeRemoved = pop(@erasionPendingForElse);
			if ($toBeRemoved)
			{
				if ($toBeRemoved != $nestedIf)
				{
					push(@erasionPendingForElse, $toBeRemoved);
				}
			}
			
			if ($isErasing == 1)
			{
				if ($eraseLevel > $nestedIf)
				{
					$line = "\n";
					$isErasing = 0;
					$eraseLevel = 0;
				}
			}
			
			if ($erasionLimited == $nestedIf and $nestedIf <= $eraseLevel)
			{
				$isErasing = 0;
				$eraseLevel = 0;
				$erasionLimited = 0;
			}
			
			if ($nestedIf > 0)
			{
				$nestedIf = $nestedIf - 1;
			}
			else
			{
				print STDOUT "WARNING: un-matched #endif found inside of $cppFilename.\n";
			}
		}
		elsif ($line =~ /\#[\ \t]*elif(.*?)$/i)
		{
			my $defines = $1;
			
			if ($erasionLimited > 0 and $nestedIf <= $eraseLevel)
			{
				$isErasing = 0;
				$eraseLevel = 0;
				$erasionLimited = 0;
			}
			
			if ($isErasing > 0)
			{
				if (cmdCPPIsAcceptable($defines))
				{
					$line =~ s/\#elif/\#if/i;
					$isErasing = 0;
					$eraseLevel = 0;
					
					my $nextEndifToRemove = pop(@removePendingEndif);
					if ($nextEndifToRemove)
					{
						if ($nextEndifToRemove != $nestedIf)
						{
							push(@removePendingEndif, $nextEndifToRemove);
						}
					}
				}
				else
				{
					$line = "\n";
				}
			}
			
			if ($isErasing == 0)
			{
				$defines =~ s/(\/\/|\/*)(.*?)//;
				
				if (not cmdCPPIsAcceptable($defines))
				{
					$isErasing = 1;
					$eraseLevel = $nestedIf;
					$erasionLimited = $nestedIf;
					$line = "\n";
				}
			}
		}
		elsif ($line =~ /\#[\ \t]*else/i)
		{
			print STDOUT "*** else is erased? <$isErasing> <$erasionLimited> <$eraseLevel>\n";
			if ($erasionLimited > 0)
			{
				$isErasing = 0;
				$eraseLevel = 0;
				$erasionLimited = 0;
			}
			
			if ($isErasing == 1)
			{
				if ($nestedIf <= $eraseLevel)
				{
					$isErasing = 0;
					$eraseLevel = 0;
				}
				$line = "\n";
			}
			
			my $toBeRemoved = pop(@erasionPendingForElse);
			print STDOUT "  ! toBeRemoved == $toBeRemoved\n";
			if ($toBeRemoved)
			{
				print STDOUT "  ! toBeRemoved == $toBeRemoved\n";
				if ($toBeRemoved == $nestedIf)
				{
					$isErasing = 1;
					$eraseLevel = $nestedIf;
					$line = "\n";
				}
				else
				{
					push(@erasionPendingForElse, $toBeRemoved);
				}
			}
		}
		elsif ($line =~ /^[\ \t]*\#[\ \t]*if[\ \t]*(.*?)$/i)
		{
			my $defines = $1;
			$defines =~ s/(\/\/|\/*)(.*?)//;
			
			my $isAcceptable = cmdCPPIsAcceptable($defines);
			$nestedIf = $nestedIf + 1;
			
			if ($isErasing == 1)
			{
				$line = "\n";
				push(@removePendingEndif, $nestedIf);
				print STDOUT "pushing $nestedIf into removePendingEndif\n";
			}
			elsif ($isAcceptable == 0)
			{
				if ($isErasing == 1)
				{
					$eraseLevel = min($nestedIf, $eraseLevel);
				}
				else
				{
					$eraseLevel = $nestedIf;
				}
				
				$isErasing = 1;
				$line = "\n";
				push(@removePendingEndif, $nestedIf);
			}
			elsif ($isAcceptable > 1)
			{
				push(@erasionPendingForElse, $nestedIf);
				print STDOUT "pushing $nestedIf into erasionPendingForElse\n";
			}
		}
		elsif ($isErasing == 1 and $eraseLevel <= $nestedIf)
		{
			if (not $line =~ /erasing line/)
			{
				$line = "\n";
			}
		}
		
		$line =~ s/hacky/workaround/im;
		$line =~ s/hacks/workarounds/im;
		$line =~ s/hack/workaround/im;
		
		if ($line =~ /Copyright/i and $line =~ /Crytek/i)
		{
			$hasCopyrightInfo = 1;
		}
		
		print $cppOUT $line;
	}
	
	close($cppOUT);
	
	if (not $hasCopyrightInfo)
	{
		print STDOUT "Warning: missing Crytek copyright inside <$cppFilename>\n";
	}
}

#-------------------------------------------------------------------------
sub cmdBeginProcess
{
	my $l = shift;
	@fileList = ();
}

#-------------------------------------------------------------------------
sub cmdEndProcess
{	
	@fileList = ();
}

#-------------------------------------------------------------------------
sub cmdEraseContent
{
	my $line = shift;
	
	$line =~ /^erase[\s]+(.*$)\n$/i;
	my $toBeErased = $1;
	
	#print STDOUT "erase: $toBeErased\n";
	
	foreach $file (@fileList) 
	{
		my $fileIN = new IO::File;
		open($fileIN, $outputPath.$file) || die "open: $! <$outputPath$file>\n";
		
		undef $/;
		my $content = <$fileIN>;
		close($fileIN);
		$/ = "\n";
		
		#print STDOUT "parsing <$outputPath$file>";
		
		while ($content =~ s/$toBeErased//sgi) 
		{
			#print "one occurence deleted...\n";
		}
		
		my $fileOUT = new IO::File;
		open($fileOUT, ">$outputPath$file") || die "open: $!";
		print $fileOUT $content;
		close($fileOUT);
	}
}

#-------------------------------------------------------------------------
sub cmdReplaceContent
{
	my $line = shift;
	
	#$line =~ /^replace[\s]+[\\]{0}\"(.*$)[\\]{0}[\s]+[\\]{0}\"(.*$)[\\]{0}\"[\n]+\n$/i;
	$line =~ /^replace[\s]+\"(.*?)\"[\s]+\"(.*?)\"[\n]+$/i;
	my $toBeFound = $1;
	my $toReplace = $2;
	
	$toReplace =~ s/\\n/$CRLF/sgm;
	
	print STDOUT "replace: this <$toBeFound> with this <$toReplace>\n";
	
	foreach $file (@fileList)
	{
		my $fileIN = new IO::File;
		open($fileIN, $outputPath.$file) || die "open: $! <$outputPath$file>\n";
		
		undef $/;
		my $content = <$fileIN>;
		close($fileIN);
		$/ = "\n";
		
		print STDOUT "parsing <$outputPath$file>";
		
		while ($content =~ s/$toBeFound/$toReplace/sgi) 
		{
			print "one occurence replaced...\n";
		}
		
		my $fileOUT = new IO::File;
		open($fileOUT, ">$outputPath$file") || die "open: $!";
		print $fileOUT $content;
		close($fileOUT);
	}
}

#-------------------------------------------------------------------------
sub cmdInclude
{
	my $line = shift;
	
	my $sdkFilename;
	
	if ($line =~ /^include[\s]+(.*$)\n$/i)
	{
		$sdkFilename = $1;
	}
	else
	{
		$sdkFilename = $line;
	}

	
	my $sdkIN = new IO::File;
	$sdkLOG = new IO::File;
	open($sdkIN, "$sdkPath\\$sdkFilename") || die "open: <$!> while trying to open <$sdkPath\\$sdkFilename>\n";
	open($sdkLOG, ">$sdkFilename.log") || die "open: $!";
	
	my $line;
	my $filepath;
	
	while ($line = <$sdkIN>)
	{
		my $command;
		
		if ($line =~ /^\#/)
		{
			# it's a comment
		}
		elsif ($line =~ /^([\w\_0-9]+)[\+\s]+/)
		{
			$command = $1;
			
			my $function;
			if ($function = $cmdRegistry{$command})
			{
				$function->($line);
			}
			else
			{
				print STDOUT "Error unknown command: ".$command."\n";
			}
		}
	}
	
	close($sdkIN);
	close($sdkLOG);
}

#-------------------------------------------------------------------------
sub cmdQuit
{
	print STDOUT "Quit command executed...\n";
	die;
}

#-------------------------------------------------------------------------
if ($#ARGV != 2)
{
	die "Error: this script needs three arguments:\n\n\t- the txt file with the file list\n\t- the source directory\n\t- the output directory\n";
}

$sdkInput = $ARGV[0];
$sourcePath = $ARGV[1];
$outputPath = $ARGV[2];
$currentPath = cwd()."\\";

%cmdRegistry = 
(
	begincopy => \&cmdBeginCopy,
	endcopy => \&cmdEndCopy,
	openpak => \&cmdOpenPak,
	closepak => \&cmdClosePak,
	beginprocess => \&cmdBeginProcess,
	endprocess => \&cmdEndProcess,
	file => \&cmdFile,
	dir => \&cmdDir,
	exclude => \&cmdExclude,
	break => \&cmdQuit,
	tagbuild => \&cmdTagBuild,
	erase => \&cmdEraseContent,
	replace => \&cmdReplaceContent,
	keepconfig => \&cmdKeepVCConfig,
	keepplatform => \&cmdKeepVCPlatform,
	removevcconfig => \&cmdRemoveVCConfig,
	include => \&cmdInclude,
	addfilter => \&cmdAddFilter,
	removefilter => \&cmdRemoveFilter,
);

%fileHandlers =
(
	cal => \&FileHandlerCal,
	vcproj => \&FileHandlerVSProject,
	rc => \&FileHandlerRC,
	sln => \&FileHandlerVSSolution,
	cga => \&FileHandlerCGA,
	cgf => \&FileHandlerCGF,
	chr => \&FileHandlerCHR,
	mtl => \&FileHandlerMTL,
	cdf => \&FileHandlerCDF,
	xml => \&FileHandlerXML,
	ent => \&FileHandlerENT,
	pak => \&FileHandlerPAK,
	cry => \&FileHandlerCRY,
	cpp => \&FileHandlerCPP,
	h => \&FileHandlerCPP,
	#fdp => \&FileHandlerFDP,
);

$sdkInput =~ /^(.*?)(\/|\\)([\w\d\s\.\-_]+)$/;
$sdkPath = $1;
$sdkFilename = $3;

print STDOUT "sdkPath = $sdkPath  |  sdkFilename = $sdkFilename\n";

cmdInclude($sdkFilename);
