// MaterialFile.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "wchar.h"

#include "CryModuleDefs.h"
#include <platform.h>
#include <windows.h>
#include <algorithm>
#include <string>
#include <vector>

#define USE_NEWPOOL
#include "CryMemoryManager.h"

#include "CryHeaders.h"


int _tmain(int argc, _TCHAR* argv[])
{
	if (argc <= 1)
		return 0;

	FILE* fp = _wfopen(argv[1], L"rb");
	if (!fp)
		return 0;

	FILE_HEADER fh;
	fread(&fh, sizeof(FILE_HEADER), 1, fp);

	fseek(fp, fh.ChunkTableOffset, SEEK_SET);
	
	DWORD chunkNum;
	fread(&chunkNum, sizeof(DWORD), 1, fp);

	CHUNK_HEADER_0744 chunkHeader;
	for (int i = 0; i < chunkNum; i++)
	{
		if (fread(&chunkHeader, sizeof(CHUNK_HEADER_0744), 1, fp))
		{
			if (chunkHeader.ChunkType == ChunkType_MtlName)
			{
				fseek(fp, chunkHeader.FileOffset, SEEK_SET);

				MTL_NAME_CHUNK_DESC_0800 mncd;
				if (fread(&mncd, sizeof(MTL_NAME_CHUNK_DESC_0800), 1, fp))
				{
					printf("%s\n", mncd.name);
				}
			}
		}

	}

	return 0;
}

