#pragma once

#include <string>																			// STL string


#ifdef USE_3DSSAVEFUNCTION_IFPOSSIBLE		// 3DStudio Max specific
class BitmapInfo;
class Interface;
#endif

typedef unsigned char UBYTE;




// used to have a consistant way to export Bitmaps in MAX or without MAX (own TGA writer) (for 24Bit RGA Bitmaps)

enum ERasterImageSaveModes
{
	eRISM_Default,		// 24 Bit, uses 3DStduio MAX save function or 24Bit compressed TGA if it's not USE_3DSSAVEFUNCTION_IFPOSSIBLE
	eRISM_DDS8,				//  8 bit DDS, usually used for displacement mapping
	eRISM_DDS16,			// 16 bit DDS, usually used for displacement mapping
	eRISM_DDS24,			// 24 bit DDS, usually used for displacement mapping
	eRISM_DDS32,			// 32 bit DDS, usually used for displacement mapping
};

class CRasterImageOutput
{
public:

	//! constructor 
 CRasterImageOutput();
		
	//! allocate the memory
	//! /param indwWidth width of the bitamp 1..
	//! /param indwHeight height of the bitmap 1..
	void AllocBitmap( const DWORD indwWidth, const DWORD indwHeight );

	//! destructor (free the allocated memory)
	virtual ~CRasterImageOutput();

	//! get direct memory access 
	//! /param outPitchInBytes pitch in bytes usually indwWidth*3
	UBYTE	*GetMemoryAndPitch( DWORD &outPitchInBytes ) const;

#ifdef USE_3DSSAVEFUNCTION_IFPOSSIBLE		// 3DStudio Max specific
	//!
	//! /param inIP
	//! /param inoutsPathFileName
	bool InitWithUserDlg( Interface* inIP, std::string &inoutsPathFileName );
#endif

#ifndef USE_3DSSAVEFUNCTION_IFPOSSIBLE		// non 3DStudio Max specific
	//! /param inoutsPathFileName
	bool InitWithUserDlg( std::string &inoutsPathFileName );
#endif

	//! save the bitmap (the bitmap is deallocated afterwards)
	//! /return true=operation successful, otherwise an error occured
	bool SaveAndClear( const std::string insFilePathName, ERasterImageSaveModes ineRasMode=eRISM_Default );

	//! free the allocated memory 
	void FreeData();

	// ******************************************************************************************

	UBYTE	*					m_pData;					//!< pointer to the aloocoated memory m_dwWidth*m_dwHeight*3 bytes, 0 if error occured while allocation
	DWORD						m_dwWidth;				//!< width of the Bitmap 1..
	DWORD						m_dwHeight;				//!< height of the Bitmap 1..

#ifdef USE_3DSSAVEFUNCTION_IFPOSSIBLE		// 3DStudio Max specific
	BitmapInfo *		m_pBitMapInfo;		//!< used for 3DStudio MAX filetype
#endif
};
