// Copyright: (c) by Crytek GmbH
#include "stdafx.h"															// for precompiled headers (has to be in first place)
#include <assert.h>															//
#include "3DMaterial.h"													// C3DMaterial
#include "3dmaterialmanager.h"									// C3DMaterialManager

// constructor
C3DMaterialManager::C3DMaterialManager()
{
}

// destructor
C3DMaterialManager::~C3DMaterialManager()
{
	FreeData();
}



// creates a new one
C3DMaterial *C3DMaterialManager::AddMaterial( const char *insName )
{
	vector<C3DMaterial *>::iterator it;

	for(it=m_MaterialList.begin();it!=m_MaterialList.end();++it)
		if(strcmp((*it)->GetName(),insName)==0)
			assert(0);			// material is already existing

	C3DMaterial *ret=new C3DMaterial(insName);

	m_MaterialList.push_back(ret);

	return ret;
}



// search for the material with this name, returns pointer to the found material
C3DMaterial *C3DMaterialManager::GetMaterial( const char *insName )
{
	vector<C3DMaterial *>::iterator it;

	for(it=m_MaterialList.begin();it!=m_MaterialList.end();++it)
		if(strcmp((*it)->GetName(),insName)==0)
			return *it;

	return 0;
}


// free the materials (delete)
void C3DMaterialManager::FreeData()
{
	vector<C3DMaterial *>::iterator it;

	for(it=m_MaterialList.begin();it!=m_MaterialList.end();++it)
		delete (*it);

	m_MaterialList.clear();
}
