// Copyright: (c) by Crytek GmbH
#pragma once



#include <vector>																// STL vector<>
using namespace std;														// STL

// this manager is responsible for new and delete of the materials

class C3DMaterialManager
{
public:

	//! constructor
	C3DMaterialManager();

	//! destructor
	virtual ~C3DMaterialManager();

	//! free the materials (delete)
	void FreeData();

	//! search for the material with this name (case sensitive), returns pointer to the found material
	//! \param insName name of the searched material/material to create
	//! \return pointer to the material or 0 is the material is not in the list
	C3DMaterial *GetMaterial( const char *insName );

	//! creates a new one (case sensitive)
	//! \param insName name of the searched material/material to create (has to be a unique name in the list)
	//! \return pointer to the material
	C3DMaterial *AddMaterial( const char *insName );

	// ********************************************************************************

private:

	vector<C3DMaterial *>				m_MaterialList;				//!<
};
