// Copyright: (c) by Crytek GmbH
//
// This file is part of PolyBump(tm) Previewer
//


vs.1.0


// V_POSITION			v0
// V_NORMAL				v1				// unused
// V_TEXTURE			v3
// V_U					v4
// V_V					v5
// V_N					v6

// CV_ZERO				c0				// unused
// CV_ONE				c1				// unused
// CV_WORLDVIEWPROJ_0	c2,c3,c4,c5		//
// CV_WORLDVIEW			c6,c7,c8,c9		//
// CV_WORLD				c13,c14,c15,c16	//
// CV_HALF				c18				//
// CV_LIGHT_DIRECTION	c21				//
// CV_LIGHT_POSITION	c22				// unused
// CV_MATERIALPROP		c23				//
// CV_EYE_POS_WORLD		c24				// unused
// CV_DIFFLIGHTCOLOR	c25				// premultiplied with material diffuse color
// CV_SPECLIGHTCOLOR	c26				// premultiplied with material specular color
// CV_LIGHT_DIRECTION	c27				// unused, eye direction
// CV_AMBIENTLIGHTCOLOR	c28				// premultiplied with material ambient color
// CV_SUBSLIGHTCOLOR	c29				// premultiplied with material subsurface color

// S_WORLD				r0
// T_WORLD				r1
// SxT_WORLD			r2
// LIGHT_LOCAL			r3
// VERTEX_WORLD			r4
// EYE_VECTOR			r5
// HALF_ANGLE			r7



; Transform position to clip space and output it
dp4 oPos.x, v0, c2
dp4 oPos.y, v0, c3
dp4 oPos.z, v0, c4
dp4 oPos.w, v0, c5

mov oD0,c18


; Transform basis vectors to world space (only neccessary if world is transformed)
dp3 r0.x, v4, c13			// U
dp3 r0.y, v4, c14
dp3 r0.z, v4, c15

dp3 r1.x, v5, c13			// V
dp3 r1.y, v5, c14
dp3 r1.z, v5, c15

dp3 r2.x, v6, c13			// N
dp3 r2.y, v6, c14
dp3 r2.z, v6, c15


mad r0.xyz, c18,r0.xyz,c18	// -1..1 -> 0..1
mad r1.xyz, c18,r1.xyz,c18	// -1..1 -> 0..1
mad r2.xyz, c18,r2.xyz,c18	// -1..1 -> 0..1

; output texture coords (normalmap and decalmap)
mov oT0, r0.xyz
mov oT0.w, c1.w		// w to 0
mov oT1, r1.xyz
mov oT1.w, c1.w		// w to 0
mov oT2, r2.xyz
mov oT2.w, c1.w		// w to 0


