// Copyright: (c) by Crytek GmbH
#include "stdafx.h"														// for precompiled headers (has to be in first place)
#include "ProcessorClock.h"										// CProcessorClock
#include <assert.h>														// assert()

CProcessorClock MyProcessorClock;



// constructor
CProcessorClock::CProcessorClock()
{
	Init();
}

// destructor
CProcessorClock::~CProcessorClock()
{
}


DWORD CProcessorClock::GetActualTime()
{
	LARGE_INTEGER b;

	if(m_PerformanceFrequency.QuadPart==0)
		Init();	// call Init

	if(QueryPerformanceCounter(&b))
	{
		return((DWORD)(1000*(b.QuadPart-m_PerformanceLevelStart.QuadPart)/(m_PerformanceFrequency.QuadPart)));
	}

	assert(0);		// no PerformanceCounter available
	return(0);
}


//
DWORD CProcessorClock::GetActualTimem100()
{
	LARGE_INTEGER b;

	if(m_PerformanceFrequency.QuadPart==0)
		Init();	// call Init

	if(QueryPerformanceCounter(&b))
	{
		return((DWORD)(100000*(b.QuadPart-m_PerformanceLevelStart.QuadPart)/(m_PerformanceFrequency.QuadPart)));
	}

	assert(0);		// no PerformanceCounter available
	return(0);
}



// initialization
bool CProcessorClock::Init()
{
	if(m_PerformanceFrequency.QuadPart==0)
	{
		QueryPerformanceFrequency(&m_PerformanceFrequency);		// no error check here

		m_PerformanceLevelStart.QuadPart=0;
		return(QueryPerformanceCounter(&m_PerformanceLevelStart)!=0);
	}

	return(true);
}



//	
LARGE_INTEGER	CProcessorClock::GetActualTimeAccurate()
{
	LARGE_INTEGER b;

	if(QueryPerformanceCounter(&b))
		return(b);

	assert(0);		// no PerformanceCounter available
	b.QuadPart=0;
	return(b);
}


// (CurrentTime - )/m_PerformanceFrequency
DWORD CProcessorClock::GetDifference100( LARGE_INTEGER inSavedTime )
{
	LARGE_INTEGER b;

	if(QueryPerformanceCounter(&b))
	{
		DWORD ms=(DWORD)(100000*(b.QuadPart-inSavedTime.QuadPart)/(m_PerformanceFrequency.QuadPart));
		if(ms>0)return(ms);
		else return(1);
	}

	assert(0);		// no PerformanceCounter available
	return(0);
}

