// Copyright: (c) by Crytek GmbH
#include "stdafx.h"											// for precompiled headers (has to be in first place)
#include "SplashWindow.h"								// CSplashWindow
#include <malloc.h>											// malloc
#include <mmsystem.h>
#include <stdio.h>
#include <assert.h>
#include <shellapi.h>

// Extract the error code from an HRESULT
#define CODEFROMHRESULT(hRes) ((hRes) & 0x0000FFFFUL)


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSplashWindow::CSplashWindow()
{
	// Var Init
	m_iTimerNo=0;
	m_hWindow=0;
	m_hBitmap=0;
	m_iXBitmapSize=0;
	m_iYBitmapSize=0;
}

CSplashWindow::~CSplashWindow()
{
	// Free Resources, Cleanup
	TimeIsUp();
}





void CSplashWindow::Draw( HDC hdc )
{
	int mx=0,my=0;

	assert(m_iXBitmapSize);
	assert(m_iYBitmapSize);

	HDC BitmapDC=CreateCompatibleDC(hdc);
	HBITMAP oldBitmap=(HBITMAP)SelectObject(BitmapDC,m_hBitmap);

	BitBlt(hdc,mx,my,m_iXBitmapSize,m_iYBitmapSize,
						 BitmapDC,0,0,
						 SRCCOPY);

	SelectObject(BitmapDC,oldBitmap);
	DeleteDC(BitmapDC);
}



//-----------------------------------------------------------------------------
// Name: WndProc()
// Desc: Static msg handler which passes messages to the application class.
//-----------------------------------------------------------------------------
LRESULT CALLBACK CSplashWindow::WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	CSplashWindow *win=(CSplashWindow *)GetWindowLong(hWnd,DWL_USER);

	switch (uMsg)
  {
		case WM_LBUTTONDOWN:
		case WM_TIMER:
			{
				win->TimeIsUp();//win->Release();
			}
			return true;

		case WM_PAINT:
			{
				PAINTSTRUCT	ps;
				HDC hdc = BeginPaint (hWnd, &ps);

				win->Draw(hdc);

				EndPaint (hWnd, &ps);
			}
			return true;

		case WM_ERASEBKGND:								// Hintergrund lschen nicht ntig
			return true;
  }
  return DefWindowProc( hWnd, uMsg, wParam, lParam );
}



bool PIX_LoadTGA( const char* filename, unsigned char *outpix2,
				  unsigned long * pal, int* width, int* height, int &BytesPerPixel,
				  bool &AlphaIncluded );



bool CSplashWindow::Create( HINSTANCE inhInstance, HWND inhWnd, WORD inBitmapResourceID, int inTimeInMS )
{
	assert(!m_hWindow);

	int cxScreenMid = GetSystemMetrics(SM_CXSCREEN)/2;
  int cyScreenMid = GetSystemMetrics(SM_CYSCREEN)/2;

	int cxWindowSize = GetSystemMetrics(SM_CXSCREEN);
  int cyWindowSize = GetSystemMetrics(SM_CYSCREEN);


	m_hBitmap=LoadBitmap(inhInstance,MAKEINTRESOURCE(inBitmapResourceID));

	BITMAP BitData;
	GetObject(m_hBitmap,sizeof(BITMAP),&BitData);
	m_iXBitmapSize=BitData.bmWidth;
	m_iYBitmapSize=BitData.bmHeight;

	cxWindowSize=m_iXBitmapSize;
	cyWindowSize=m_iYBitmapSize;

	// Register the window class
  WNDCLASS wndClass = { 0, WndProc, 0, 
												DLGWINDOWEXTRA+4,		// DLGWINDOWEXTRA braucht Windows fr Dialoge
												inhInstance,
                        /*LoadIcon( dat.m_hInst, MAKEINTRESOURCE(IDI_MAIN_ICON) )*/NULL,
                        LoadCursor( NULL/*dat.m_hInst*/, IDC_ARROW ), 
                        (HBRUSH)(CreateSolidBrush(GetSysColor(COLOR_BTNFACE))),
                        NULL, "MySplashWindow" };

	ATOM aclass=RegisterClass( &wndClass );


	m_hWindow = CreateWindowEx(
															WS_EX_TOPMOST,
															(const char *)(aclass),
															"",WS_VISIBLE | WS_POPUP, 
															cxScreenMid-cxWindowSize/2, cyScreenMid-cyWindowSize/2,
															cxWindowSize,
															cyWindowSize,
															inhWnd, NULL, inhInstance, NULL
														);
	
	if( !m_hWindow ) 
	{
//		DWORD h=GetLastError();
		return false;
	}

	SetActiveWindow(m_hWindow);

	SetWindowLong(m_hWindow,DWL_USER,(long)(void *)(this));		// kein RefCounting, da ich Obj selbst zerstre


	m_iTimerNo=SetTimer (
												m_hWindow,				// handle of window for timer messages
												0,								// timer identifier
												inTimeInMS,				// time-out value
												0									// address of timer procedure  (0= WM_TIMER MESSAGE)
											);
 
	return true;
}




void CSplashWindow::TimeIsUp()
{
	if(m_iTimerNo)KillTimer(m_hWindow,m_iTimerNo);m_iTimerNo=0;
	if(m_hWindow)DestroyWindow(m_hWindow);m_hWindow=0;
	if(m_hBitmap)DeleteObject(m_hBitmap);
//	free(m_pBitmapMem);m_pBitmapMem=0;
}

