
// Helper class

class CSimpleTriangleFiller
{
public:

	class CPixelCallback
	{
	public:
		//! callback function
		virtual void ReturnPixel( DWORD inX, DWORD inY, DWORD &inoutdwColor )=0;
		virtual void ReturnLine( float inXLeft, float inXRight, DWORD inY )
		{
		}

	};

	//! callback function
	class CPixelFlatFill: public CPixelCallback
	{
	public:

		virtual void ReturnPixel( DWORD inX, DWORD inY, DWORD &inoutdwColor )
		{
			inoutdwColor=m_dwColor;
		}

		DWORD m_dwColor;
	};

	//! simple triangle filler with clipping (optimizable), not subpixel correct
	//! /param pBuffer pointer o the color buffer
	//! /param indwWidth width of the color buffer
	//! /param indwHeight height of the color buffer
	//! /param x1 x position of the vertex no 0 of the triangle
	//! /param y1 y position of the vertex no 0 of the triangle
	//! /param x2 x position of the vertex no 1 of the triangle
	//! /param y2 y position of the vertex no 1 of the triangle
	//! /param x3 x position of the vertex no 2 of the triangle
	//! /param y3 y position of the vertex no 2 of the triangle
	//! /param indwColor color of the triangle
	__forceinline static void FlatFill( DWORD *pBuffer, DWORD indwWidth, DWORD indwHeight, 
												float x1, float y1, float x2, float y2, float x3, float y3, DWORD indwColor, bool inbConservative )
	{
		CPixelFlatFill pix;

		pix.m_dwColor=indwColor;

		CallbackFill(pBuffer,indwWidth,indwHeight,x1,y1,x2,y2,x3,y3,&pix,inbConservative);
	}



	//! \param pBuffer pointe to the DWORD
	//! \param indwWidth width of the buffer pBuffer pointes to
	//! \param indwHeight height of the buffer pBuffer pointes to
	//! \param x1
	//! \param y1
	//! \param x2
	//! \param y2
	//! \param x3
	//! \param y3
	//! \param inpSink
	//! \param inbConservative conservative the whole triangle is covered otherwise the triangle is subpixel correct filled
	static void CallbackFill( DWORD *pBuffer, DWORD indwWidth, DWORD indwHeight, 
												float x1, float y1, float x2, float y2, float x3, float y3, CPixelCallback *inpSink, bool inbConservative );

	//! shrink triangle by 1 pixel
	//! /param inoutfX x position of the vertices of the triangle
	//! /param inoutY y position of the vertices of the triangle
	//! /param infAmount amount in pixel, could be negative for growing
	static void ShrinkTriangle( float inoutfX[3], float inoutfY[3], float infAmount=1.0f );
};