//
// This file is part of PolyBump(tm) Previewer
//
// (C) Crytek
//

vs.1.0


// V_POSITION			v0
// V_NORMAL				v1
// V_TEXTURE			v3
// V_U					v4				// unused
// V_V					v5				// unused
// V_N					v6				// unused

// CV_ZERO				c0				// unused
// CV_ONE				c1				//
// CV_WORLDVIEWPROJ_0	c2,c3,c4,c5		//
// CV_WORLDVIEW			c6,c7,c8,c9		//
// CV_WORLD				c13,c14,c15,c16	//
// CV_HALF				c18				//
// CV_LIGHT_DIRECTION	c21				//
// CV_LIGHT_POSITION	c22				// unused
// CV_MATERIALPROP		c23				// .x=specular exponent
// CV_EYE_POS_WORLD		c24				// unused
// CV_DIFFLIGHTCOLOR	c25				// premultiplied with material diffuse color
// CV_SPECLIGHTCOLOR	c26				// premultiplied with material specular color
// CV_LIGHT_DIRECTION	c27				// unused, eye direction
// CV_AMBIENTLIGHTCOLOR	c28				// premultiplied with material ambient color
// CV_SUBSLIGHTCOLOR	c29				// premultiplied with material subsurface color


; Transform position to clip space and output it
dp4 oPos.x, v0, c2
dp4 oPos.y, v0, c3
dp4 oPos.z, v0, c4
dp4 oPos.w, v0, c5

dp3 r1, v1 , c21    // perform lighting N dot L calculation in world space      

mul r0, c25,r1		// diffuse = diffuse light color * cos() 
max r0,r0,c0

// fake subsurface scattering into ambient
mad r1, c18,r1,c18	// -1..1 -> 0..1
mul r1,r1.rrrr,c29	// *subsurface color
add r0,r0,r1

add oD0,r0,c28

/////////////////////////////////////
// Calculate half angle vector

// transform vertex position to world space
//  to calculate V, vector to viewer in world
//  space.

dp4 r4.x, v0, c13
dp4 r4.y, v0, c14
dp4 r4.z, v0, c15

; Half angle vector is  (L+V)/||L+V||  or Normalize( L+V )
;  ||a|| is magnitude of a
;  L = vec to light from vertex point
;  V = vec to viewer from vertex point

// vertex position - eye position
// eye position - vertex position
add r5,  c24, -r4.xyz


; Normalize eye vec
dp3 r5.w, r5, r5
rsq r5.w, r5.w
mul r5,   r5, r5.w

// Add them to average & create half angle vector
add r7,  c21, r5


;  Normalize it
dp3 r7.w, r7, r7
rsq r7.w, r7.w
mul r7,   r7, r7.w  



  
dp3 r7, v1 , r7


mov r7.w,c23.x			; specular exponent

lit r7,r7
  
mul oD1, c26,r7.z		; specular = specular light color * pow(cos(),..)




mov oT0, v3				; texture coordiantes

  
  
  
  
  
  
  
  
