////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   convertcontext.h
//  Version:     v1.00
//  Created:     4/11/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __convertcontext_h__
#define __convertcontext_h__
#pragma once

#include "PathHelpers.h"

struct IResourceCompiler;
struct IConfig;
struct IRCLog;
struct ICfgFile;

//! Section in rc.ini file for common settings.
#define COMMON_SECTION "Common"

// [MichaelS] Moved this into convert context from ResourceCompiler so that it can be threadsafe.
// Stats are gathered in a vector per thread and then collated at the end.
class CFileStats
{
public:
	uint32				m_SrcFileSizeKB;	//!< in KB
	uint32				m_DstFileSizeKB;	//!< in KB
	string				m_sInfo;					//!< \t seperated list of properties (used for excel export)
	string				m_sDestFilename;	//!<
	string				m_sPreset;				//!<
};

/** Enumeration of supported platforms.
*/
enum Platform
{
	PLATFORM_UNKNOWN,	//!< Unknown platform.
	PLATFORM_PC,
//	PLATFORM_XBOX,
//	PLATFORM_PS2,
//	PLATFORM_GAMECUBE,
//	PLATFORM_WII,
	PLATFORM_PS3,
	PLATFORM_X360,

	// This entry must be last in Platform enum.
	PLATFORM_LAST,
};

struct IConvertContext
{
	virtual void Release() {delete this;}
	virtual void SetMasterFolder(const char* masterFolder) = 0;
	virtual void SetSourceFileIntermediate(const char* sourceFileIntermediate) = 0;
	virtual void SetSourceFileFinal(const char* sourceFileFinal) = 0;
	virtual void SetSourceFileFinalExtension(const char* sourceFileFinalExtension) = 0;
	virtual void SetOutputFile(const char* outputFile) = 0;
	virtual void SetSourceFolder(const char* sourceFolder) = 0;
	virtual void SetRC(IResourceCompiler* pRC) = 0;
	virtual void SetConfig(IConfig *config) = 0;
	virtual void SetLog(IRCLog *pLog) = 0;
	virtual void SetQuiet(bool bQuiet) = 0;
	virtual void SetPresets(ICfgFile *presets) = 0;
	virtual void SetPlatform(Platform platform) = 0;
	virtual void SetPlattformName(const char* plattformName) = 0;
	virtual void SetThreads(int threads) = 0;
	virtual void SetFileFolder(const char* sFileFolder) = 0;
	virtual void SetOutputFolder(const char* sOutputFolder) = 0;
	virtual const char* GetOutputFile() const = 0;
	virtual void SetFileStatsHandle(void* fileStatsHandle) = 0;
};

struct IConfig;

/** ConvertContext is a description of what should be processed by convertor.
*/
struct ConvertContext : public IConvertContext
{
	virtual void SetMasterFolder(const char* masterFolder) {this->masterFolder = masterFolder;}
	virtual void SetSourceFileIntermediate(const char* sourceFileIntermediate) {this->sourceFileIntermediate = sourceFileIntermediate;}
	virtual void SetSourceFileFinal(const char* sourceFileFinal) {this->sourceFileFinal = sourceFileFinal;}
	virtual void SetSourceFileFinalExtension(const char* sourceFileFinalExtension) {this->sourceFileFinalExtension = sourceFileFinalExtension;}
	virtual void SetOutputFile(const char* outputFile) {this->outputFile = outputFile;}
	virtual void SetSourceFolder(const char* sourceFolder) {this->sourceFolder = sourceFolder;}
	virtual void SetRC(IResourceCompiler* pRC) {this->pRC = pRC;}
	virtual void SetConfig(IConfig *config) {this->config = config;}
	virtual void SetLog(IRCLog *pLog) {this->pLog = pLog;}
	virtual void SetQuiet(bool bQuiet) {this->bQuiet = bQuiet;}
	virtual void SetPresets(ICfgFile *presets) {this->presets = presets;}
	virtual void SetPlatform(Platform platform) {this->platform = platform;}
	virtual void SetPlattformName(const char* plattformName) {this->plattformName = plattformName;}
	virtual void SetThreads(int threads) {this->threads = threads;}
	virtual void SetFileFolder(const char* sFileFolder) {this->m_sFileFolder = sFileFolder;}
	virtual void SetOutputFolder(const char* sOutputFolder) {this->m_sOutputFolder = sOutputFolder;}
	virtual const char* GetOutputFile() const {return this->outputFile;}
	virtual void SetFileStatsHandle(void* fileStatsHandle) {this->fileStatsHandle = fileStatsHandle;}

	// this string must be prepended to all paths
	string masterFolder;

	//! Source file that needs to be converted. (name on the disk - might be different from final e.g. "~temp123.tmp")
	string sourceFileIntermediate;
	//! Source file that needs to be converted. (final name of file - e.g. "dirt.tif")
	string sourceFileFinal;
	// Source file extension (use this if you need the extension, the sourceFile might not have the right extension e.g. .tmp)
	// is always lower case (e.g. ".tif")
	string sourceFileFinalExtension;
	//! Output file that would be created from sourceFile. (relative or absolute)
	string outputFile;

	// Returns
	//   the file with path you should read from
	string getSourcePath() {return PathHelpers::Join(masterFolder, PathHelpers::Join(sourceFolder,sourceFileIntermediate));}
	virtual string getOutputPath() {return PathHelpers::Join(masterFolder, PathHelpers::Join(m_sOutputFolder,outputFile));}

	// Returns
	//   path to the resource compiler exe including path e.g.  "c:\temp\bin32\rc\"
	string getCompilerFolderPath() const
	{
		char szRCPath[1000];

		if (GetModuleFileName (NULL, szRCPath, sizeof(szRCPath)))
			return PathHelpers::GetDirectory(szRCPath);

		assert(0);
		return "";
	}

	//! Source file folder, so that the source file can be opened regardless whether the 
	//! path is given in sourceFile or not
	string sourceFolder;

	//! Pointer to resource compiler interface.
	IResourceCompiler *pRC;
	//! Configuration settings for this file.
	IConfig *config;
	//! Returns the log to put the messages during conversion to:
	//! use Log(), LogWarning() and LogError()
	IRCLog *pLog;

	//! Dont log much info into log.
	bool bQuiet;

	//! file specific config file, must not be 0 (if there was no file, a empty instance with the right filename is created)
//	ICfgFile *pFileSpecificConfig;

	//! presets config (for use with the image compiler)
	ICfgFile *presets;

	//! Platform to which file must be processed.
	Platform platform;

	//! e.g. "PC", "XBOX"
	string plattformName;

//private: // --------------------------------------------------------------------------------------------

	int threads;                                  // Number of threads 
	string m_sFileFolder;                         // relative folder where the file is located, relative to source folder e.g. "Textures\Animals\Pets\"
	string m_sOutputFolder;                       // Output folder
	void* fileStatsHandle;
};

#endif // __convertcontext_h__