#pragma once

class CImageCompiler;

#include "RelativeMouseInput.h"						// CRelativeMouseInput
#include "UIBumpmapPanel.h"								// CUIBumpmapPanel
#include "UIMIPControlPanel.h"						// CUIMIPControlPanel
#include "Monitor.h"
#include "ImageProperties.h"
#include "TinyDocument.h"

class CImageUserDialog : public Monitor, public TinyDocument<float>::Listener
{
public:

	//! constructor
	CImageUserDialog();
	//! destructor
	virtual ~CImageUserDialog();

	//!
	bool DoModal( CImageCompiler *inpImageCompiler );

private: // ---------------------------------------------------------------------------------------

	enum WorkerAction
	{
		WorkerActionNone,
		WorkerActionPaint,
		WorkerActionUpdatePreview,
		WorkerActionGenerateOutput,
		WorkerActionGenerateOutputAndQuit,
		WorkerActionSaveConfig,
		WorkerActionSaveConfigAndQuit,
		WorkerActionQuit,
		WorkerActionNoCustomSettings
	};
	WorkerAction m_eWorkerAction;

	CImageCompiler *			m_pImageCompiler;				//!< this class is not responsibe for destruction
	float									m_fShiftX;							//!< in texture coordinates [0..1] initially 0.5
	float									m_fShiftY;							//!< in texture coordinates [0..1] initially 0.5
	int										m_iScale64;							//!< 16 is the default
	bool									m_bQuitting;						//!< 

	HWND									m_hWindow;							//!< main window handle

	// sub windows (in the tab control)
	HWND									m_hTab_Saveformat;			//!< window handle
	HWND									m_hTab_Advanced;				//!< window handle
	CUIBumpmapPanel				m_Bump2NormalPanel;			//
	CUIBumpmapPanel				m_AlphaAsBumpPanel;			//
	CUIMIPControlPanel		m_MIPControlPanel;			//!<

	const int							m_iPreviewWidth;				//!<
	const int							m_iPreviewHeight;				//!<

	CRelativeMouseInput		m_RelMouse;								//!< for relative mouse movement
	bool									m_bDialogIsUpdating;		//!<

	//!
	static BOOL CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

	//!
	void Draw( HDC inHdc );

	//!
	void MouseMessage( const DWORD indwButtons, const int iniRelX , const int iniRelY, int iniRelZ );

	//!
	void UpdateWindowTitle();

	void UpdatePixelFormatDesc();

	void UpdatePreview( const bool bFullConvert );

	void CreateDialogItems();

	void GetDataFromDialog();

	//! makes the dialog visible too
	void SetDataToDialog( const bool bInitalUpdate=false );

	void SetPropertyTab( const int iniNo ); 

	void UpdateBumpStrength();

	void UpdateBlurAmount();

	static DWORD WINAPI ThreadStart_Static(void* pThis);
	DWORD ThreadStart();

	void TriggerUpdatePreview();
	void TriggerGenerateOutput(bool bQuit);
	void TriggerSaveConfig(bool bQuit);
	void TriggerRepaint();
	void TriggerCancel();
	void TriggerResetSettings();
	WorkerAction CheckAndResetWorkerAction();

	virtual void OnTinyDocumentChanged(TinyDocument<float>* pDocument);
};
