////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   controllertcb.h
//  Version:     v1.00
//  Created:     12/11/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: TCB controller implementation.
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __controllertcb_h__
#define __controllertcb_h__
#pragma once

#include "TCBSpline.h"




// CJoint animation.
struct CControllerTCB : public IController
{

	uint32 GetID() const {
		return m_ID;
	}
	size_t SizeOfThis() const	{
		return 0;
	} 

	f32 NTime2KTime(int32 GAID,f32 ntime);
	Status4 GetOPS (int GAID, f32 t, Quat& rot, Vec3& pos, Diag33& scl);
	uint32 GetO(int GAID, f32 t, Quat& rot );
	uint32 GetP(int GAID, f32 t, Vec3& pos );
	uint32 GetS(int GAID, f32 t, Diag33& scl );
	Quat GetOrientationByKey (uint32 t) { return Quat(IDENTITY); };

	Status4 GetLM_OPS (f32 t, Quat& rot, Vec3& pos, Diag33& scl) { Status4 s4; return s4; };
	Status4 GetLM_OP (f32 t, Quat& rot, Vec3& pos) { Status4 s4; return s4; };
	Status4 GetLMRoot_OP (f32 t, Quat& rot, Vec3& pos) { Status4 s4; return s4; };
	uint32 GetLM_Position(f32 t, Vec3& pos ) { return 0; };
	uint32 GetLM_Rotation(f32 t, Quat& rot ) { return 0; };

	Status4 GetLM_RootOPS (f32 t, Quat& rot, Vec3& pos, Diag33& scl) { Status4 s4; return s4; };
	uint32 GetLM_RootPosition(f32 t, Vec3& pos ) { return 0; };
	uint32 GetLM_RootOrientation(f32 t, Quat& rot ) { return 0; };
	//Vec3 GetMoveDir() { return Vec3(0,-1,0); };

	CInfo GetControllerInfoRoot()
	{
		CInfo info;
		info.numKeys = 0;
		return info;
	}

	CInfo GetControllerInfo() const
	{
		CInfo info;
		info.numKeys = 0;
		return info;
	}

	Status4 m_active;
	uint32 m_ID;
	spline::TCBSpline<Vec3> m_posTrack;
	spline::TCBAngleAxisSpline m_rotTrack;
	spline::TCBSpline<Vec3> m_sclTrack;

	/*
	IController(GlobalAnimationHeader * header) : m_pGlobalAnimationHeader(header)
	{

	}

	*/
	CControllerTCB()
	{
		m_active.ops = 0;
		m_ID=0xaaaa5555;

	}

	CControllerTCB(GlobalAnimationHeader * header) : IController(header)
	{
		m_active.ops = 0;
		m_ID=0xaaaa5555;
	}
};


#endif // __controllertcb_h__

