//---------------------------------------------------------------------------
// Copyright 2006 Crytek GmbH
// Created by: Michael Smith
//---------------------------------------------------------------------------
#ifndef __IXMLSERIALIZER_H__
#define __IXMLSERIALIZER_H__

#include "ixml.h"
#include <cstdio>
class IXMLDataSink;
class IXMLDataSource;

class FileXmlBufferSource : public IXmlBufferSource
{
public:
	FileXmlBufferSource(const char* path)
	{
		file = std::fopen(path, "r");
	}
	~FileXmlBufferSource()
	{
		if (file)
			std::fclose(file);
	}

	virtual int Read(void* buffer, int size) const
	{
		if (!file)
			return 0;
		return std::fread(buffer, 1, size, file);
	}

private:
	mutable std::FILE* file;
};
class IXMLSerializer
{
public:
	virtual bool Write(XmlNodeRef root, const char* szFileName) = 0;
	virtual XmlNodeRef Read(const IXmlBufferSource& source, int nErrorBufferSize, char* szErrorBuffer) = 0;
};

#endif //__IXMLSERIALIZER_H__
