// ResourceCompilerPC.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "StatCGFCompiler.h"
#include "CharacterCompiler.h"
#include "ColladaCompiler.h"
#include "CGA\AnimationCompiler.h"
#include "ICryXML.h"
#include "mdump.h"

#include "ResourceCompilerPC.h"

#include "CryCommon.cpp"

//#ifdef CRY_STRING
//int sEmptyStringBuffer[] = { -1, 0, 0, 0 };
//string::StrHeader* string::m_emptyStringData = (string::StrHeader*)&sEmptyStringBuffer;
//wstring::StrHeader* wstring::m_emptyStringData = (wstring::StrHeader*)&sEmptyStringBuffer;
//#endif //CRY_STRING

SSystemGlobalEnvironment* gEnv = 0;

char g_sCurrentFilename[1024] = "";
char g_sCurrentNode[1024] = "";

IRCLog* g_pLog = NULL;

void LogWarning (const char* szFormat, ...)
{
	va_list args;
	va_start (args, szFormat);
	if (g_pLog)
	{
		char szNewFormat[4096];
		strcpy( szNewFormat,szFormat );
		strcat( szNewFormat,",  " );
		strcat( szNewFormat,g_sCurrentFilename );
		strcat( szNewFormat,", Node: " );
		strcat( szNewFormat,g_sCurrentNode );
		g_pLog->LogV(IMiniLog::eWarning, szNewFormat, args);
	}
	else
		vprintf (szFormat, args);
	va_end(args);
}

void Log (const char* szFormat, ...)
{
	va_list args;
	va_start (args, szFormat);
	if (g_pLog)
		g_pLog->LogV(IMiniLog::eMessage, szFormat, args);
	else
		vprintf (szFormat, args);
	va_end(args);
}

void CryLog_RC (const char* szFormat, ...)
{
	va_list args;
	va_start (args, szFormat);
	if (g_pLog)
		g_pLog->LogV(IMiniLog::eMessage, szFormat, args);
	else
		vprintf (szFormat, args);
	va_end(args);
}

void LogError (const char* szFormat, ...)
{
	va_list args;
	va_start (args, szFormat);
	if (g_pLog)
		g_pLog->LogV(IMiniLog::eError, szFormat, args);
	else
		vprintf(szFormat, args);
	va_end(args);
}

MiniDumper miniDumper("compilerPC");

BOOL APIENTRY DllMain( HANDLE hModule, 
											DWORD  ul_reason_for_call, 
											LPVOID lpReserved
											)
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		g_hInst = (HMODULE)hModule;
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}

ICryXML* LoadICryXML(IRCLog* pLog)
{
	//// Find the directory of the current dll.
	//char szBuffer[1024];
	//GetModuleFileName(g_hInst, szBuffer, sizeof(szBuffer));
	//string sPath = Path::GetPath(szBuffer);

	//SetDllDirectory(Path::AddBackslash(sPath) + "..\\tools");
	HMODULE hXMLLibrary = LoadLibrary("CryXML.dll");
	if (NULL == hXMLLibrary)
	{
		char szCurrentDirectory[512];

		GetCurrentDirectory(512,szCurrentDirectory);

		pLog->LogError("Unable to load xml library (CryXML.dll)");
		pLog->LogError("  Current Directory: %s",szCurrentDirectory);		// useful to track down errors
		return 0;
	}

	FnGetICryXML pfnGetICryXML = (FnGetICryXML)GetProcAddress(hXMLLibrary, "GetICryXML");
	if (pfnGetICryXML == 0)
	{
		pLog->LogError("Unable to load xml library (CryXML.dll) - cannot find exported function GetICryXML().");
		return 0;
	}

	return pfnGetICryXML();
}

// This is an example of an exported function.
void __stdcall RegisterConvertors(IResourceCompiler*pRC)
{
	g_pLog = pRC->GetIRCLog();
	ICryXML* pCryXML = LoadICryXML(pRC->GetIRCLog());

	pRC->RegisterKey("ext_cgf","ignore cgf files");	
	pRC->RegisterKey("ext_chr","ignore chr files");	

	pRC->RegisterConvertor(new CharacterCompiler(pCryXML));
	pRC->RegisterConvertor(new CStatCFGCompiler());

	if (pCryXML == 0)
	{
		pRC->GetIRCLog()->LogError("Loading xml library failed - not registering collada converter.");
		return;
	}
	pRC->RegisterConvertor(new ColladaCompiler(pCryXML, pRC->GetPakSystem()));
  
	pRC->RegisterKey("ext_cba","animations batch processing file");	
	pRC->RegisterKey("file","animation file for processing");	
	pRC->RegisterKey("dest","destination folder for the results");	
	pRC->RegisterKey("report","report mode");	
	pRC->RegisterKey("cleanupfast","erase uncompressed chunks without recalculation");	
	pRC->RegisterKey("cleanup","erase uncompressed chunks with recalculation");	
	pRC->RegisterKey("build","build dba");	
	pRC->RegisterKey("update","update only new files in the dba");	
	pRC->RegisterKey("checkloco",
		"should be used with report mode.\n"
		"Compare locomotion_locator motion with recalculated root motion");	

	pRC->RegisterKey("fastcompile","fast compile the cgf");

	pRC->RegisterConvertor(g_pAnimationCompiler = new CAnimationCompiler(pCryXML));
}

HMODULE g_hInst;

#include "Cry_Vector3_info.h"
#include "Cry_Quat_info.h"
#include "Cry_Matrix_info.h"
#include "Cry_Color_info.h"
#include "Cry_Geo_info.h"
#include "CryHeaders_info.h"
#include "IIndexedMesh_info.h"
#include "CGFContent_info.h"

