////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   StatCGFCompiler.cpp
//  Version:     v1.00
//  Created:     5/11/2002 by Vladimir Kajalin
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "ConvertContext.h"
#include "iconfig.h"
#include "StatCGFCompiler.h"

#include "CGF\CGFLoader.h"
#include "CGF\CGFSaver.h"
#include "CryVersion.h"
#include "StaticObjectCompiler.h"
#include "StatCGFPhysicalize.h"

//////////////////////////////////////////////////////////////////////////
CStatCFGCompiler::CStatCFGCompiler()
{
	m_pPhysicsInterface = NULL;
	//MessageBox(NULL, "Pres OK baton ->", "Ok?", MB_OK);

	m_refCount = 1;
}

//////////////////////////////////////////////////////////////////////////
CStatCFGCompiler::~CStatCFGCompiler()
{
	if (m_pPhysicsInterface)
		delete m_pPhysicsInterface;
}

////////////////////////////////////////////////////////////
bool CStatCFGCompiler::GetOutputFile( ConvertContext &cc )
{
	cc.outputFile = cc.sourceFileFinal;
	if (!cc.masterFolder.empty())
		cc.m_sOutputFolder = PathHelpers::Join(cc.masterFolder, cc.m_sOutputFolder);
	
//	cc.outputFile = "xtest_ivo.cga";
	return true;
}

//////////////////////////////////////////////////////////////////////////
int CStatCFGCompiler::GetNumPlatforms() const
{
	return 3;
}

//////////////////////////////////////////////////////////////////////////
void CStatCFGCompiler::Release()
{
	if (--m_refCount <= 0)
		delete this;
}

//////////////////////////////////////////////////////////////////////////
ICompiler* CStatCFGCompiler::CreateCompiler()
{
	// Only ever return one compiler, since we don't support multithreading. Since
	// the compiler is just this object, we can tell whether we have already returned
	// a compiler by checking the ref count.
	if (m_refCount >= 2)
		return 0;

	// Until we support multithreading for this convertor, the compiler and the
	// convertor may as well just be the same object.
	++m_refCount;
	return this;
}

//////////////////////////////////////////////////////////////////////////
bool CStatCFGCompiler::SupportsMultithreading() const
{
	return false;
}

//////////////////////////////////////////////////////////////////////////
Platform CStatCFGCompiler::GetPlatform( int index ) const
{
	switch (index)
	{
	case 0:	return PLATFORM_PC;
	case 1:	return PLATFORM_X360;
	case 2:	return PLATFORM_PS3;
	//case 3:	return PLATFORM_GAMECUBE;
	};
	//assert(0);
	return PLATFORM_UNKNOWN;
}

DWORD CStatCFGCompiler::GetTimestamp() const
{
	return GetTimestampForLoadedLibrary(g_hInst);
}

//////////////////////////////////////////////////////////////////////////
bool CStatCFGCompiler::Process( ConvertContext &cc )
{
	try
	{
		string sourceFile = cc.getSourcePath();
		string outputFile = cc.getOutputPath();

		strcpy( g_sCurrentFilename,sourceFile );
		strcpy( g_sCurrentNode,"" );

		CChunkFile chunkFile;

		CLoaderCGF cgfLoader;
		class Listener : public ILoaderCGFListener
		{
		public:
			Listener(ConvertContext& cc): cc(cc) {}
			virtual void Warning( const char *format ) {cc.pLog->LogWarning("%s", format);}
			virtual void Error( const char *format ) {cc.pLog->LogError("%s", format);}

		private:
			ConvertContext& cc;
		};
		Listener listener(cc);
		CContentCGF *pCGF = cgfLoader.LoadCGF( sourceFile,chunkFile,&listener );
		if (!pCGF)
		{
			LogError( "Failed to load geometry file %s - %s",(const char*)sourceFile,cgfLoader.GetLastError() );
			return false;
		}

		// Delete Node and Mesh chunks from CGF chunk file.
		DeleteOldChunks( pCGF,chunkFile );

		// Compile contents.
		if (m_pPhysicsInterface == 0)
			m_pPhysicsInterface = new CPhysicsInterface;
		CContentCGF* pCompiledCGF = CStaticObjectCompiler(m_pPhysicsInterface).MakeCompiledCGF(pCGF);

		// Save modified content to the same chunk file.
		CSaverCGF cgfSaver( sourceFile,chunkFile );

		SFileVersion fv = cc.pRC->GetFileVersion();
		pCompiledCGF->GetExportInfo()->rc_version[0] = fv.v[0];
		pCompiledCGF->GetExportInfo()->rc_version[1] = fv.v[1];
		pCompiledCGF->GetExportInfo()->rc_version[2] = fv.v[2];
		pCompiledCGF->GetExportInfo()->rc_version[3] = fv.v[3];
		sprintf( pCompiledCGF->GetExportInfo()->rc_version_string," RCVer:%d.%d ",fv.v[2],fv.v[1] );

		cgfSaver.SetContent( pCompiledCGF );
		// Only store 
		cgfSaver.SaveExportFlags();

    bool bNeedEndianSwap = false, bNeedCompressVertices = false;

    if (cc.platform == PLATFORM_PS3 || cc.platform == PLATFORM_X360)
      bNeedEndianSwap = true;

    
		cgfSaver.SaveNodes(bNeedEndianSwap, bNeedCompressVertices);
		cgfSaver.SaveBreakablePhysics(bNeedEndianSwap);
		cgfSaver.SaveFoliage();

		// Force remove of the read only flag and after write restore previous file flags.
		SetFileAttributes( outputFile,FILE_ATTRIBUTE_ARCHIVE );
		chunkFile.Write( outputFile );

		delete pCGF;
		delete pCompiledCGF;
	}
	catch(char*)
	{
		Beep(1000,1000);
		return false;
	}

	return true;
}

//////////////////////////////////////////////////////////////////////////
void CStatCFGCompiler::DeleteOldChunks( CContentCGF *pCGF,CChunkFile &chunkFile )
{
	for (int i = 0; i < pCGF->GetNodeCount(); i++)
	{
		CNodeCGF *pNode = pCGF->GetNode(i);
		if (pNode->nChunkId)
		{
			chunkFile.DeleteChunkId(pNode->nChunkId); // Delete chunk of node.
			// Check if light node, for light nodes we not change light object.
			if (pNode->nObjectChunkId && pNode->type != CNodeCGF::NODE_LIGHT)
				chunkFile.DeleteChunkId(pNode->nObjectChunkId); // Delete chunk of mesh.
			pNode->nObjectChunkId = 0;
		}
	}
	// Delete all mesh chunks.
	while (true) {
		CChunkFile::ChunkDesc *cd = chunkFile.FindChunkByType(ChunkType_Mesh);
		if (cd)
			chunkFile.DeleteChunkId( cd->hdr.ChunkID );
		else
			break;
	}
	// Delete all mesh subsets.
	while (true) {
		CChunkFile::ChunkDesc *cd = chunkFile.FindChunkByType(ChunkType_MeshSubsets);
		if (cd)
			chunkFile.DeleteChunkId( cd->hdr.ChunkID );
		else
			break;
	}
	// Delete all data streams.
	while (true) {
		CChunkFile::ChunkDesc *cd = chunkFile.FindChunkByType(ChunkType_DataStream);
		if (cd)
			chunkFile.DeleteChunkId( cd->hdr.ChunkID );
		else
			break;
	}
	// Delete all precompiled physics data streams.
	while (true) {
		CChunkFile::ChunkDesc *cd = chunkFile.FindChunkByType(ChunkType_MeshPhysicsData);
		if (cd)
			chunkFile.DeleteChunkId( cd->hdr.ChunkID );
		else
			break;
	}
	// Delete all mesh chunks.
	while (true) {
		CChunkFile::ChunkDesc *cd = chunkFile.FindChunkByType(ChunkType_ExportFlags);
		if (cd)
			chunkFile.DeleteChunkId( cd->hdr.ChunkID );
		else
			break;
	}
	// Delete breakable physics chunk.
	while (true) {
		CChunkFile::ChunkDesc *cd = chunkFile.FindChunkByType(ChunkType_BreakablePhysics);
		if (cd)
			chunkFile.DeleteChunkId( cd->hdr.ChunkID );
		else
			break; 
	}
}
