#include "stdafx.h"
#include "StaticObjectCompiler.h"
#include "StatCGFPhysicalize.h"
#include "StatCGFSHCompiler.h"
#include "MeshCompiler\MeshCompiler.h"

CStaticObjectCompiler::CStaticObjectCompiler(CPhysicsInterface *pPhysicsInterface)
:	m_pPhysicsInterface(pPhysicsInterface)
{
}

//////////////////////////////////////////////////////////////////////////
CContentCGF* CStaticObjectCompiler::MakeCompiledCGF( CContentCGF *pCGF, bool fastcompile )
{
	CContentCGF *pCompiledCGF = new CContentCGF( pCGF->GetFilename() );
	*pCompiledCGF->GetExportInfo() = *pCGF->GetExportInfo(); // Copy export info.
	*pCompiledCGF->GetPhysiclizeInfo() = *pCGF->GetPhysiclizeInfo();

	
	int nMeshCompileFlags = mesh_compiler::MESH_COMPILE_TANGENTS | mesh_compiler::MESH_COMPILE_OPTIMIZE;
	
	if (fastcompile)
		nMeshCompileFlags &= ~mesh_compiler::MESH_COMPILE_OPTIMIZE;

	if (pCGF->GetMergedMesh())
	{
		strcpy( g_sCurrentNode,"Merged" );

		// Compile single merged mesh.
		mesh_compiler::CMeshCompiler meshCompiler;
		if (!meshCompiler.Compile( *pCGF->GetMergedMesh(), nMeshCompileFlags))
		{
			LogError( "Failed to compile geometry in 'Merged' node in file %s - %s",pCGF->GetFilename(),meshCompiler.GetLastError() );
			delete pCompiledCGF;
			return 0;
		}
		//////////////////////////////////////////////////////////////////////////
		// Add single node for merged mesh.
		CNodeCGF *pNode = new CNodeCGF;
		pNode->type = CNodeCGF::NODE_MESH;
		pNode->name = "Merged";
		pNode->localTM.SetIdentity();
		pNode->worldTM.SetIdentity();
		pNode->pos.Set(0,0,0);
		pNode->rot.SetIdentity();
		pNode->scl.Set(1,1,1);
		pNode->bIdentityMatrix = true;
		pNode->pMesh = new CMesh;
		pNode->pMesh->Copy( *pCGF->GetMergedMesh() );
		pNode->pParent = NULL;
		pNode->pMaterial = pCGF->GetCommonMaterial();
		pNode->nPhysicalizeFlags = 0;

		//if(!CalculateSHCoefficientsForMesh(pNode->pMesh, pCGF, pNode->pMaterial))
		//	LogError( "Failed to process spherical harmonic coefficients for geometry in 'Merged' node in file %s",pCGF->GetFilename() );

		// Add node to CGF contents.
		pCompiledCGF->AddNode( pNode );

		//////////////////////////////////////////////////////////////////////////
	}
	else
	{
		// Compile meshes in nodes. 
		uint32 numNodes = pCGF->GetNodeCount();
		int i,j,len;

		for(i=0; i<numNodes; i++) 
			pCGF->GetNode(i)->bHasFaceMap = false;

		for(i=0; i<numNodes; i++) 
		{
			CNodeCGF *pNodeCGF = pCGF->GetNode(i), *pNodeCGF1;
			if (pNodeCGF->pMesh && !pNodeCGF->bPhysicsProxy && pNodeCGF->type==CNodeCGF::NODE_MESH && 
					(len=strlen(pNodeCGF->name))>10 && !strcmp((const char*)pNodeCGF->name+len-10,"_Destroyed"))
				for(j=0; j<numNodes; j++)	if (i!=j && !strncmp((pNodeCGF1=pCGF->GetNode(j))->name,pNodeCGF->name,len-10) && pNodeCGF1->name[len-10]==0)
					pNodeCGF1->bHasFaceMap = pNodeCGF->bHasFaceMap = true;
		}

		for (i=0; i<numNodes; i++)
		{
			CNodeCGF *pNodeCGF = pCGF->GetNode(i);
			if (!pNodeCGF->pMesh || pNodeCGF->bPhysicsProxy || pNodeCGF->type != CNodeCGF::NODE_MESH)
				continue;

			strcpy( g_sCurrentNode,pNodeCGF->name.c_str() );

			DynArray<uint16> mapFaceToFace;
			
			mesh_compiler::CMeshCompiler meshCompiler;
			if (pNodeCGF->bHasFaceMap)
			{
				std::vector<uint16>::iterator ite = pNodeCGF->mapFaceToFace0.begin();
				std::vector<uint16>::iterator iteEnd = pNodeCGF->mapFaceToFace0.end();
				for (; ite != iteEnd; ++ite)
					mapFaceToFace.push_back(*ite);

				meshCompiler.SetFaceRemapping(&mapFaceToFace);
			}

			if (!meshCompiler.Compile( *pNodeCGF->pMesh, nMeshCompileFlags))
			{
				LogError( "Failed to compile geometry in node '%s' in file %s - %s",pNodeCGF->name.c_str(),pCGF->GetFilename(),meshCompiler.GetLastError() );
				delete pCompiledCGF;
				return 0;
			}
			//now check whether any sh coefficients are required and if so, compute them, check all materials/submaterials for this cgf
			//if(!CalculateSHCoefficientsForMesh(pNodeCGF->pMesh, pCGF, pNodeCGF->pMaterial))
			//	LogError( "Failed to process spherical harmonic coefficients for geometry in node '%s' in file %s",pNodeCGF->name.c_str(),pCGF->GetFilename() );

			pCompiledCGF->AddNode(pNodeCGF);

			mapFaceToFace.clear();
		}
	}

	int numNodes = pCGF->GetNodeCount();
	for (int i=0; i<numNodes; i++)
	{
		CNodeCGF *pNodeCGF = pCGF->GetNode(i);
		
		if (pNodeCGF->bPhysicsProxy || pNodeCGF->type != CNodeCGF::NODE_MESH)
		{
			strcpy( g_sCurrentNode,pNodeCGF->name.c_str() );

			// If no indices in mesh, try to compile it.
			if (pNodeCGF->pMesh && pNodeCGF->pMesh->GetIndexCount() == 0)
			{
				//////////////////////////////////////////////////////////////////////////
				// Compile mesh.
				//////////////////////////////////////////////////////////////////////////
				mesh_compiler::CMeshCompiler meshCompiler;
				if (!meshCompiler.Compile( *pNodeCGF->pMesh,nMeshCompileFlags ))
				{
					LogError( "Failed to compile geometry in node '%s' in file %s - %s",pNodeCGF->name.c_str(),pCGF->GetFilename(),meshCompiler.GetLastError() );
					delete pCompiledCGF;
					return 0;
				}
			}
			pCompiledCGF->AddNode(pNodeCGF);
		}
	}

	//////////////////////////////////////////////////////////////////////////
	// Check if any duplicate meshes exist, and try to share them.
	{
		mesh_compiler::CMeshCompiler meshCompiler;
		numNodes = pCompiledCGF->GetNodeCount();
		for (int i = 0; i < numNodes-1; i++)
		{
			CNodeCGF *pNode1 = pCompiledCGF->GetNode(i);
			if (!pNode1->pMesh || pNode1->pSharedMesh)
				continue;

			if (!(pNode1->pMesh->m_numVertices && pNode1->pMesh->m_numFaces))
				continue;
 
			for (int j = i+1; j < numNodes; j++)
			{
				CNodeCGF *pNode2 = pCompiledCGF->GetNode(j);
				if (pNode1 == pNode2 || !pNode2->pMesh)
					continue;

				if (pNode1->properties == pNode2->properties)
				{
				if (meshCompiler.CompareMeshes( *pNode1->pMesh,*pNode2->pMesh ) && pNode1->pMesh != pNode2->pMesh)
				{
					// Meshes are same, share them.
					delete pNode2->pMesh;
					pNode2->pMesh = pNode1->pMesh;
					pNode2->pSharedMesh = pNode1;
				}
			}
		}
		}
		//////////////////////////////////////////////////////////////////////////

	}

	uint32 numNodes2 = pCGF->GetNodeCount();
	Physicalize( pCompiledCGF,pCGF );
	int i;
	for(i=0; i<pCompiledCGF->GetNodeCount() && pCompiledCGF->GetNode(i)->type!=CNodeCGF::NODE_MESH; i++);

	if (i<pCompiledCGF->GetNodeCount())
		AnalyzeFoliage( pCompiledCGF, pCompiledCGF->GetNode(i) );

	return pCompiledCGF;
}

//////////////////////////////////////////////////////////////////////////
void CStaticObjectCompiler::Physicalize( CContentCGF *pCompilerCGF,CContentCGF *pSrcCGF )
{
	//if (!m_pPhysicsInterface)
	//	m_pPhysicsInterface = new CPhysicsInterface;
	bool bCgfHavePhysProxy = false;
	for (int i=0; i<pCompilerCGF->GetNodeCount(); i++)
	{
		CNodeCGF *pNode = pCompilerCGF->GetNode(i);
		if (pNode->pMesh && pNode->bPhysicsProxy)
		{
			bCgfHavePhysProxy = true;
			break;
		}
	}

	for (int i=0; i<pCompilerCGF->GetNodeCount(); i++)
	{
		CNodeCGF *pNode = pCompilerCGF->GetNode(i);
		if (!pNode->pMesh)
			continue;
		if (bCgfHavePhysProxy && !pNode->bPhysicsProxy)
			continue;

		m_pPhysicsInterface->Physicalize( pNode,pCompilerCGF );
	}

	for (int i=0; i<pCompilerCGF->GetNodeCount(); i++)
	{
		CNodeCGF *pNode = pCompilerCGF->GetNode(i);
		if (pNode->pMesh)
			m_pPhysicsInterface->DeletePhysicalProxySubsets( *pNode->pMesh );
	}

	m_pPhysicsInterface->ProcessBreakablePhysics( pCompilerCGF,pSrcCGF );
}

//////////////////////////////////////////////////////////////////////////
const bool CStaticObjectCompiler::CalculateSHCoefficientsForMesh(CMesh *pMesh, CContentCGF *pCGF, const CMaterialCGF* cpMat)
{
	CStatCFGSHCompiler shCompiler(pMesh, pCGF, cpMat);
	return shCompiler.Calculate();
}


//////////////////////////////////////////////////////////////////////////

inline int check_mask(unsigned int *pMask, int i) {
	return pMask[i>>5]>>(i&31) & 1;
}
inline void set_mask(unsigned int *pMask, int i) {
	pMask[i>>5] |= 1u<<(i&31);
}
inline void clear_mask(unsigned int *pMask, int i) {
	pMask[i>>5] &= ~(1u<<(i&31));
}


int UpdatePtTriDist(const Vec3 *vtx, const Vec3 &n, const Vec3 &pt, float &minDist,float &minDenom)
{
	float rvtx[3]={ (vtx[0]-pt).len2(),(vtx[1]-pt).len2(),(vtx[2]-pt).len2() }, elen2[2],dist,denom;
	int i=idxmin3(rvtx), bInside[2];
	Vec3 edge[2],dp=pt-vtx[i];

	edge[0] = vtx[incm3(i)]-vtx[i]; elen2[0] = edge[0].len2();
	edge[1] = vtx[decm3(i)]-vtx[i]; elen2[1] = edge[1].len2();
	bInside[0] = isneg((dp^edge[0])*n);
	bInside[1] = isneg((edge[1]^dp)*n);
	rvtx[i] = rvtx[i]*elen2[bInside[0]] - sqr(max(0.0f,dp*edge[bInside[0]]))*(bInside[0]|bInside[1]); 
	denom = elen2[bInside[0]];

	if (bInside[0]&bInside[1]) {
		if (edge[0]*edge[1]<0) {
			edge[0] = vtx[decm3(i)]-vtx[incm3(i)];
			dp = pt-vtx[incm3(i)];
			if ((dp^edge[0])*n>0)	{
				dist=rvtx[incm3(i)]*edge[0].len2()-sqr(dp*edge[0]); denom=edge[0].len2();
				goto found;
			}
		}
		dist=sqr((pt-vtx[0])*n), denom=n.len2();
	}	else
		dist = rvtx[i];

	found:
	if (dist*minDenom < minDist*denom) {
		minDist=dist; minDenom=denom;
		return 1;
	}
	return 0;
}


struct SBranchPt {
	Vec3 pt;
	Vec2 tex;
	int itri;
	float minDist,minDenom;
};

struct SBranch {
	SBranchPt *pt;
	int npt;
	float len;
};

void CStaticObjectCompiler::AnalyzeFoliage(CContentCGF *pCGF, CNodeCGF *pNodeCGF)
{
	if (!pCGF || !pNodeCGF)
		return;
	int i,j,isle,iss,ivtx0,nVtx,itri,ivtx,iedge,nSegs,ibran0,ibran1,ibran,nBranches,ispine,ispineDst,nBones,nGlobalBones,idmat=0, 
			*pIdxSorted,*pForeignIdx;
	int nMaxBones = 72;
	Vec3 pt[7],edge,edge1,n,nprev,axisx,axisy;
	Vec2 tex[6];
	float t,s,mindist,k,denom,len,dist[3],e,t0,t1,denomPrev;
	unsigned int *pUsedTris,*pUsedVtx;
	char sname[64];
	SFoliageInfoCGF &fi = *pCGF->GetFoliageInfo();
	CMesh &mesh = *pNodeCGF->pMesh;
	mesh_data *pmd;
	IGeometry *pPhysGeom;
	SBranch branch,*pBranches;
	primitives::box bbox;

	int nMeshVtx,nMeshIdx;
	Vec3 *pMeshVtx;
	SMeshTexCoord *pMeshTex;
	unsigned short *pMeshIdx;
	nMeshVtx = mesh.GetVertexCount(); pMeshVtx = mesh.m_pPositions;
	nMeshIdx = mesh.GetIndexCount();  pMeshIdx = mesh.m_pIndices; 
	pMeshTex = mesh.m_pTexCoord;

	// iterate through branch points branch#_#, build a branch structure
	pBranches=0; nBranches=0;
	do {
		branch.pt=0; branch.npt=0; branch.len=0;
		do {
			sprintf(sname,"branch%d_%d",nBranches+1,branch.npt+1);
			for(i=pCGF->GetNodeCount()-1; i>=0 && stricmp((const char*)pCGF->GetNode(i)->name,sname); i--); 
			if (i<0)
				break;
			pt[0].Set(pCGF->GetNode(i)->localTM.m03, pCGF->GetNode(i)->localTM.m13, pCGF->GetNode(i)->localTM.m23);
			if ((branch.npt & 15)==0)
				branch.pt = (SBranchPt*)realloc(branch.pt, (branch.npt+16)*sizeof(SBranchPt));
			branch.pt[branch.npt].minDist = 1; branch.pt[branch.npt].minDenom = 0;
			branch.pt[branch.npt].itri = -1;
			branch.pt[branch.npt++].pt = pt[0];
			branch.len += (pt[0]-branch.pt[max(0,branch.npt-2)].pt).len();
		} while(true);
		if (branch.npt<2)	{
			if (branch.pt) free(branch.pt);
			break;
		}
		if ((nBranches & 15)==0)
			pBranches = (SBranch*)realloc(pBranches,(nBranches+16)*sizeof(SBranch));
		pBranches[nBranches++] = branch;
		// make sure the segments have equal length
		len = branch.len/(branch.npt-1);
		for(i=1;i<branch.npt;i++)
			branch.pt[i].pt = branch.pt[i-1].pt+(branch.pt[i].pt-branch.pt[i-1].pt).normalized()*len;
	} while(true);

	if (nBranches==0)
		return;
	SSpineRC spine;
	memset(&spine, 0, sizeof spine); 
	memset(fi.pBoneMapping = new SMeshBoneMapping[fi.nSkinnedVtx=nMeshVtx], 0, nMeshVtx*sizeof(SMeshBoneMapping));
	for(i=0; i<nMeshVtx; i++)
		fi.pBoneMapping[i].weights[0] = 255;
	pIdxSorted = new int[nMeshVtx];	nVtx = 0;
	pForeignIdx = new int[nMeshIdx/3];
	pUsedTris = new unsigned int[i = ((nMeshIdx-1)>>5)+1]; memset(pUsedTris,0,i*sizeof(int));
	pUsedVtx = new unsigned int[i = ((nMeshVtx-1)>>5)+1];	memset(pUsedVtx,0,i*sizeof(int));

	// iterate through all triangles, track the closest for each branch point
	for(iss=0; iss<mesh.GetSubSetCount(); iss++) 
	if (mesh.m_subsets[iss].nPhysicalizeType == PHYS_GEOM_TYPE_NONE)
		for(i=mesh.m_subsets[iss].nFirstIndexId; i<mesh.m_subsets[iss].nFirstIndexId+mesh.m_subsets[iss].nNumIndices; i+=3)
		{
			for(j=0;j<3;j++) pt[j] = pMeshVtx[pMeshIdx[i+j]];	n = pt[1]-pt[0] ^ pt[2]-pt[0];
			for(ibran=0; ibran<nBranches; ibran++) for(ivtx0=0; ivtx0<pBranches[ibran].npt; ivtx0++)
				if (UpdatePtTriDist(pt,n, pBranches[ibran].pt[ivtx0].pt, pBranches[ibran].pt[ivtx0].minDist, pBranches[ibran].pt[ivtx0].minDenom))
					pBranches[ibran].pt[ivtx0].itri = i;
		}

	for(ibran=0;ibran<nBranches;ibran++) for(i=0;i<pBranches[ibran].npt;i++) if(pBranches[ibran].pt[i].itri>=0)
	{	// get the closest point on the triangle for each vertex, get tex coords from it
		for(j=0;j<3;j++) pt[j] = pMeshVtx[pMeshIdx[pBranches[ibran].pt[i].itri+j]];
		n = pt[1]-pt[0] ^ pt[2]-pt[0]; pt[3] = pBranches[ibran].pt[i].pt;
		for(j=0;j<3 && (pt[incm3(j)]-pt[j] ^ pt[3]-pt[j])*n>0;j++);
		if (j==3)	
		{	// the closest pt is in triangle interior
			denom = 1.0f/n.len2(); 
			pt[3] -= n*(n*(pt[3]-pt[0]))*denom;
			for(j=0,s=0,t=0; j<3; j++) {
				k = ((pt[3]-pt[incm3(j)] ^ pt[3]-pt[decm3(j)])*n)*denom;
				s += pMeshTex[pMeshIdx[pBranches[ibran].pt[i].itri+j]].s*k;
				t += pMeshTex[pMeshIdx[pBranches[ibran].pt[i].itri+j]].t*k;
			}
		} else {
			for(j=0;j<3 && !inrange((pt[incm3(j)]-pt[j])*(pt[3]-pt[j]), 0.0f,(pt[incm3(j)]-pt[j]).len2());j++);
			if (j<3) 
			{ // the closest pt in on an edge
				k = ((pt[3]-pt[j])*(pt[incm3(j)]-pt[j]))/(pt[incm3(j)]-pt[j]).len2();
				s = pMeshTex[pMeshIdx[pBranches[ibran].pt[i].itri+j]].s*(1-k)+
					  pMeshTex[pMeshIdx[pBranches[ibran].pt[i].itri+incm3(j)]].s*k;
				t = pMeshTex[pMeshIdx[pBranches[ibran].pt[i].itri+j]].t*(1-k)+
						pMeshTex[pMeshIdx[pBranches[ibran].pt[i].itri+incm3(j)]].t*k;
			} else 
			{	// the closest pt is a vertex
				for(j=0;j<3;j++) dist[j] = (pt[j]-pt[3]).len2();
				j = idxmin3(dist);
				s = pMeshTex[pMeshIdx[pBranches[ibran].pt[i].itri+j]].s;
				t = pMeshTex[pMeshIdx[pBranches[ibran].pt[i].itri+j]].t;
			}
		}
		pBranches[ibran].pt[i].tex.set(s,t);
	}

if (!IsHeapValid()) __asm int 3;

	for(iss=0,nGlobalBones=1; iss<mesh.GetSubSetCount(); iss++,nGlobalBones+=nBones-1) 
	if (mesh.m_subsets[iss].nPhysicalizeType == PHYS_GEOM_TYPE_NONE)
	{
		// fill the foreign idx list
		for(i=0,j=mesh.m_subsets[iss].nFirstIndexId/3; j*3<mesh.m_subsets[iss].nFirstIndexId+mesh.m_subsets[iss].nNumIndices;	j++,i++)
			pForeignIdx[i] = j;
		pPhysGeom = m_pPhysicsInterface->GetPhysicalWorld()->GetGeomManager()->CreateMesh(pMeshVtx, pMeshIdx+mesh.m_subsets[iss].nFirstIndexId, 
			0,pForeignIdx, mesh.m_subsets[iss].nNumIndices/3, mesh_shared_vtx|mesh_SingleBB|mesh_keep_vtxmap);
		pmd = (mesh_data*)pPhysGeom->GetData();
		pPhysGeom->GetBBox(&bbox);
		e = sqr((bbox.size.x+bbox.size.y+bbox.size.z)*0.002f);
		nBones = 1;
		//mesh.m_subsets[iss].m_arrChunkBoneIDs.push_back(0);
		fi.chunkBoneIds.push_back(0);

		for(isle=0; isle<pmd->nIslands; isle++)	if (pmd->pIslands[isle].nTris>=4)
		{
			ibran0=0; ibran1=nBranches; ivtx=0; nSegs=0; 
			spine.nVtx=0; spine.pVtx=0; spine.iAttachSpine=spine.iAttachSeg = -1;
			do {
				for(itri=pmd->pIslands[isle].itri,i=j=0; i<pmd->pIslands[isle].nTris; itri=pmd->pTri2Island[itri].inext,i++)
				{
					for(j=0;j<3;j++) tex[j].set(pMeshTex[pMeshIdx[pmd->pForeignIdx[itri]*3+j]].s, 
																			pMeshTex[pMeshIdx[pmd->pForeignIdx[itri]*3+j]].t);
					k = tex[1]-tex[0] ^ tex[2]-tex[0]; s = fabs_tpl(k);
					for(ibran=ibran0,j=0; ibran<ibran1; ibran++) {
						for(j=0;j<3 && sqr_signed(tex[incm3(j)]-tex[j] ^ pBranches[ibran].pt[ivtx].tex-tex[j])*k>-e*s*(tex[incm3(j)]-tex[j]).GetLength2(); j++);
						if (j==3) goto foundtri;
					}
				}
				break; // if no tri has the next point in texture space, skip the rest
				foundtri:
				if (nBones+pBranches[ibran].npt-1 > nMaxBones)
					break;

				// output phys vtx
				if (!spine.pVtx)
					spine.pVtx = new Vec3[pBranches[ibran].npt];
				denom = 1.0f/(tex[1]-tex[0] ^ tex[2]-tex[0]);
				tex[3] = pBranches[ibran].pt[ivtx].tex;
				for(j=0,pt[0].zero(); j<3; j++)
					pt[0] += pmd->pVertices[pmd->pIndices[itri*3+j]].scale((tex[3]-tex[incm3(j)]^tex[3]-tex[decm3(j)]))*denom;
				spine.pVtx[ivtx++] = pt[0];
				
				ibran0 = ibran; ibran1 = ibran+1;
			} while(ivtx<pBranches[ibran].npt);

			if (ivtx<3)	{
				if (spine.pVtx) delete[] spine.pVtx;
				continue;
			}
			spine.nVtx = ivtx;
			spine.pSegDim = new Vec4[spine.nVtx];

			// enforce equal length for phys rope segs
			for(i=0,len=0; i<spine.nVtx-1; i++)
				len += (spine.pVtx[i+1]-spine.pVtx[i]).len();
			spine.len = len;
			for(i=1,len/=(spine.nVtx-1); i<spine.nVtx; i++)
				spine.pVtx[i] = spine.pVtx[i-1]+(spine.pVtx[i]-spine.pVtx[i-1]).normalized()*len;

			// append island's vertices to the vertex index list
			for(itri=pmd->pIslands[isle].itri,i=0,ivtx0=nVtx,n.zero(); i<pmd->pIslands[isle].nTris; itri=pmd->pTri2Island[itri].inext,i++) 
			{
				for(iedge=0;iedge<3;iedge++) if (!check_mask(pUsedVtx, pMeshIdx[pmd->pForeignIdx[itri]*3+iedge]))
					set_mask(pUsedVtx, pIdxSorted[nVtx++]=pMeshIdx[pmd->pForeignIdx[itri]*3+iedge]);
				nprev = pMeshVtx[pMeshIdx[pmd->pForeignIdx[itri]*3+1]].sub(pMeshVtx[pMeshIdx[pmd->pForeignIdx[itri]*3]]) ^
								pMeshVtx[pMeshIdx[pmd->pForeignIdx[itri]*3+2]].sub(pMeshVtx[pMeshIdx[pmd->pForeignIdx[itri]*3]]);
				n += nprev*float(sgnnz(nprev.z));
			}
			spine.navg = n.normalized();

			nprev = spine.pVtx[1]-spine.pVtx[0];
			for(ivtx=0; ivtx<spine.nVtx-1; ivtx++) 
			{	// generate a separating plane between current seg and next seg	and move vertices that are sliced by it to the front
				n = edge = spine.pVtx[ivtx+1]-spine.pVtx[ivtx];
				axisx=(n^spine.navg).normalized(); axisy=axisx^n;	spine.pSegDim[ivtx]=Vec4(0,0,0,0);
				if (ivtx<spine.nVtx-2)
					n += spine.pVtx[ivtx+2]-spine.pVtx[ivtx+1]; 
				denom = 1.0f/(edge*n); denomPrev = 1.0f/(edge*nprev);
				for(i=ivtx0;i<nVtx;i++) if ((t1 = (spine.pVtx[ivtx+1].sub(pMeshVtx[pIdxSorted[i]]))*n)>0) {
					t = (pMeshVtx[pIdxSorted[i]].sub(spine.pVtx[ivtx]))*axisx;
					spine.pSegDim[ivtx].x=min(t,spine.pSegDim[ivtx].x); spine.pSegDim[ivtx].y=max(t,spine.pSegDim[ivtx].y);
					t = (pMeshVtx[pIdxSorted[i]].sub(spine.pVtx[ivtx]))*axisy;
					spine.pSegDim[ivtx].z=min(t,spine.pSegDim[ivtx].z); spine.pSegDim[ivtx].w=max(t,spine.pSegDim[ivtx].w);
					t0 = ((spine.pVtx[ivtx].sub(pMeshVtx[pIdxSorted[i]]))*nprev)*denomPrev; t1 *= denom;
					t = min(1.0f,max(0.0f,1.0f-fabs_tpl(t0+t1)*0.5f/(t1-t0)));
					j = isneg(t0+t1);
					fi.pBoneMapping[pIdxSorted[i]].boneIDs[0] = nBones+min(spine.nVtx-2,ivtx+j);
					fi.pBoneMapping[pIdxSorted[i]].boneIDs[1] = nBones+max(0,ivtx-1+j);
					fi.pBoneMapping[pIdxSorted[i]].weights[j^1] = 255-(fi.pBoneMapping[pIdxSorted[i]].weights[j] = max(1,min(254,FtoI(t*255))));
					j=pIdxSorted[ivtx0]; pIdxSorted[ivtx0++]=pIdxSorted[i]; pIdxSorted[i]=j;
				}
				nprev = n;
				//mesh.m_subsets[iss].m_arrChunkBoneIDs.push_back(nGlobalBones+nBones-1+ivtx);
				fi.chunkBoneIds.push_back(nGlobalBones+nBones-1+ivtx);
			}
			for(i=ivtx0;i<nVtx;i++) {
				fi.pBoneMapping[pIdxSorted[i]].boneIDs[0] = nBones+spine.nVtx-2;
				fi.pBoneMapping[pIdxSorted[i]].weights[0] = 255;
			}

			if ((fi.nSpines & 7)==0) {
				SSpineRC *pSpines = fi.pSpines;
				memcpy(fi.pSpines = new SSpineRC[fi.nSpines+8], pSpines, fi.nSpines*sizeof(SSpineRC));
				for(j=0;j<fi.nSpines;j++) 
					pSpines[j].pVtx=0, pSpines[j].pSegDim=0;
				if (pSpines) delete[] pSpines;
			}
			fi.pSpines[fi.nSpines++] = spine;
			nBones += spine.nVtx-1;
		}
		pPhysGeom->Release();
	} else
		nBones = 1;

	// for every spine, check if its base is close enough to a point on another spine 
	for(ispine=0; ispine<fi.nSpines; ispine++)
		for(ispineDst=0,pt[0]=fi.pSpines[ispine].pVtx[0]; ispineDst<fi.nSpines; ispineDst++) if (ispine!=ispineDst)
		{
			mindist = sqr(fi.pSpines[ispine].len*0.05f); 
			for(i=0,j=-1; i<fi.pSpines[ispineDst].nVtx-1; i++) 
			{	// find the point on this seg closest to pt[0]
				if ((t=(fi.pSpines[ispineDst].pVtx[i+1]-pt[0]).len2())<mindist)
					mindist=t, j=i;	// end vertex
				edge = fi.pSpines[ispineDst].pVtx[i+1]-fi.pSpines[ispineDst].pVtx[i];
				edge1 = pt[0]-fi.pSpines[ispineDst].pVtx[i];
				if (inrange(edge1*edge, edge.len2()*-0.3f*((i-1)>>31),edge.len2()) && (t=(edge^edge1).len2()) < mindist*edge.len2())
					mindist=t/edge.len2(), j=i;	// point on edge
			}
			if (j>=0)
			{	// attach ispine to a point on iSpineDst
				fi.pSpines[ispine].iAttachSpine = ispineDst;
				fi.pSpines[ispine].iAttachSeg = j;
				break;
			}
		}

	delete[] pUsedVtx; delete[] pUsedTris; delete[] pForeignIdx; delete[] pIdxSorted;
	spine.pVtx = 0; spine.pSegDim=0;
}
