#include "stdafx.h"
#include "IResCompiler.h"
#include "XMLConverter.h"
#include "IRCLog.h"

HMODULE g_hInst;

void* CryModuleMalloc(size_t size) {return malloc(size);}
//size_t CryModuleFree(void *ptr) { size_t ret=_msize(ptr); free(ptr); return ret; }
void CryModuleFree(void *ptr) { size_t ret=_msize(ptr); free(ptr); }
void* CryModuleRealloc(void *memblock,size_t size) {return realloc(memblock, size);}

BOOL APIENTRY DllMain( HANDLE hModule, 
											DWORD  ul_reason_for_call, 
											LPVOID lpReserved
											)
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		g_hInst = (HMODULE)hModule;
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}

ICryXML* LoadICryXML(IRCLog* pLog)
{
	// Find the directory of the current dll.
	char szBuffer[1024];
	GetModuleFileName(g_hInst, szBuffer, sizeof(szBuffer));

	HMODULE hXMLLibrary = LoadLibrary("CryXML.dll");
	if (NULL == hXMLLibrary)
	{
		pLog->LogError("Unable to load xml library (CryXML.dll).");
		return 0;
	}

	FnGetICryXML pfnGetICryXML = (FnGetICryXML)GetProcAddress(hXMLLibrary, "GetICryXML");
	if (pfnGetICryXML == 0)
	{
		pLog->LogError("Unable to load xml library (CryXML.dll) - cannot find exported function GetICryXML().");
		return 0;
	}

	return pfnGetICryXML();
}

void __stdcall RegisterConvertors( IResourceCompiler *pRC )
{
	ICryXML* pCryXML = LoadICryXML(pRC->GetIRCLog());
	if (pCryXML == 0)
	{
		pRC->GetIRCLog()->LogError("Loading xml library failed - not registering xml converter.");
		return;
	}

	pCryXML->AddRef();

	pRC->RegisterConvertor(new XMLConverter(pCryXML));

	pCryXML->Release();
}
