//---------------------------------------------------------------------------
// Copyright 2006 Crytek GmbH
// Created by: Michael Smith
//---------------------------------------------------------------------------
#ifndef __XMLBINARYHEADERS_H__
#define __XMLBINARYHEADERS_H__

// Make sure this structures have proper packing
#pragma pack(push,4)

namespace XMLBinary
{
	class IError
	{
	public:
		virtual ~IError() {}
		virtual void GetDescription(int nBufferSize, char* szDescriptionBuffer) = 0;
	};

	//////////////////////////////////////////////////////////////////////////
	struct IDataWriter
	{
	public:
		virtual void Write(const void* pData, size_t size) = 0;
	};

	class Node
	{
	public:
		uint32 nTagStringOffset;
		uint32 nContentStringOffset;
		uint16 nParentIndex;
		uint16 nFirstAttributeIndex;
		uint16 nAttributeCount;
		uint16 nFirstChildIndex;
		uint16 nChildCount;
		uint16 reserved_for_alignment;

		AUTO_STRUCT_INFO
	};

	class Attribute
	{
	public:
		uint32 nKeyStringOffset;
		uint32 nValueStringOffset;

		AUTO_STRUCT_INFO
	};

	class BinaryFileHeader
	{
	public:
		static const char* sk_szCorrectSignature;
		char szSignature[8];
		uint32 nXMLSize;
		uint32 nNodeTablePosition;
		uint32 nNodeCount;
		uint32 nAttributeTablePosition;
		uint32 nAttributeCount;
		uint32 nChildTablePosition;
		uint32 nChildCount;
		uint32 nStringDataPosition;
		uint32 nStringDataSize;

		AUTO_STRUCT_INFO
	};
}

#pragma pack(pop)

#endif //__XMLBINARYHEADERS_H__
