#ifndef __FBTOOL_H__
#define __FBTOOL_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file	fbtool.h
*	Declaration for the FBTool class.
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbcontrols/fbcontrols.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif

////////////////////////////////////////////////////////////////////////////////////
// FBTool
////////////////////////////////////////////////////////////////////////////////////
/**	Register a tool
*	\param	ClassName		Name of tool class to register.
*	\param	Label			Short description of tool.
*	\param	Description		Long description of tool.
*	\param	IconFilename	Filename of associated icon.
*/
#define FBRegisterTool( ClassName, Label, Description, IconFilename ) \
	static HIObject RegisterTool##ClassName( HIObject pOwner,char * pName,void * pData) \
	{\
		ClassName *Class = new ClassName( Label ); \
		if( Class->FBCreate() )	{\
			return Class->GetHIObject(); \
		} else { \
			delete Class; \
			return NULL; \
		} \
	} \
	FBLibraryModule( ClassName )	\
	{	\
		FBRegisterObject( ClassName,"UI/Tools",Label,Description,RegisterTool##ClassName, false, IconFilename );\
	}

/**	Tool class declaration.
*	\param	ClassName	Name of tool class to declare.
*	\param	Parent		Name of tool class parent class.
*/
#define FBToolDeclare( ClassName,Parent ) \
	FBClassDeclare( ClassName,Parent ); \
  public: \
  ClassName(char *pName=NULL, HIObject pObject=NULL):Parent(pName, pObject) { FBClassInit; } \
  private:

/**	Tool class implementation.
*	\param	ThisComponent	Tool class to implement.
*/
#define FBToolImplementation( ThisComponent ) \
	FBClassImplementation( ThisComponent )

FB_FORWARD( FBFbxObject );
__FB_FORWARD( FBTool );

//! Tool class.
class  FBSDK_DLL FBTool :	public FBLayout {
	__FBClassDeclare( FBTool,FBLayout );
public:
	/** Constructor.
	*	\param	pName		Name of tool.
	*	\param	pObject		Internal parent object to own FBComponent.
	*/
	FBTool(char* pName = NULL, HIObject pObject = NULL);

	//@{
	/** Storage/Retrieval of information into the FBX file format.
	*	\param	pFbxObject	Object to interface with FBX file format.
	*	\param	pStoreWhat	Attributes to store in FBX file.
	*/
	virtual bool	FbxStore	( HFBFbxObject pFbxObject, kFbxObjectStore pStoreWhat );
	virtual bool	FbxRetrieve	( HFBFbxObject pFbxObject, kFbxObjectStore pStoreWhat );
	//@}

	IObject_Declare(Implementation);		// Interface to IObject.

	FBPropertyInt		StartSize	[2];	//!< Starting Size. This is the initial size when the tool is opened. (0:Width, 1:Height. Default = 800x400)
	FBPropertyInt		MaxSize		[2];	//!< Maximum Size (Disabled in this version). A value of -1 means no maximum size. (0:Width, 1:Height. Default = -1x-1)
	FBPropertyInt		MinSize		[2];	//!< Minimum Size. A value of -1 means no minimum value. (0:Width, 1:Height. Default = 140x-1).
};

#ifdef FBSDKUseNamespace
	}
#endif
#endif	/* __FBTOOL_H	*/
