#ifndef __FBAUDIO_H__
#define __FBAUDIO_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file fbaudio.h
*	Audio interface for FBSDK
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>
#include <fbsdk/fbaudiofmt.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif

__FB_FORWARD( FBAudioIn );
__FB_FORWARD( FBAudioOut );
__FB_FORWARD( FBAudioClip );
FB_DEFINE_COMPONENT( FBSDK_DLL, AudioIn );
FB_DEFINE_COMPONENT( FBSDK_DLL, AudioOut );
FB_DEFINE_COMPONENT( FBSDK_DLL, AudioClip );

//! Data access modes.
enum FBAccessMode {
	kFBAccessModeDisk,	//!< Access data directly to disk using a cache system.
	kFBAccessModeMemory	//!< Access data from memory, which means that it will copyed entirely into it.
};

//! Use Channel modes.
enum FBUseChnMode {
	kFBUseChannelLeftOnly,	//!< Left channel will be played in both speakers.
	kFBUseChannelRightOnly,	//!< Right channel will be played in both speakers.
	kFBUseChannelBoth		//!< Default mode, where each channel play in its respective speaker.
};

//! Audio clips' trigger styles.
enum FBTriggerStyle {
	kFBTriggerStyleContinue,	//!< Previously triggered clips that are still playing won't be stopped and mixing will occur.
	kFBTriggerStyleCut,			//!< Previously triggered clips that are still playing will be stopped.
	kFBTriggerStyleToggle		//!< If a previously triggered clip is playing, it will only be stopped, otherwise a new starts playing. No mixing and no loop.
};

FB_DEFINE_ENUM(FBSDK_DLL, AccessMode);
FB_DEFINE_ENUM(FBSDK_DLL, UseChnMode);
FB_DEFINE_ENUM(FBSDK_DLL, TriggerStyle);

typedef class FBSDK_DLL FBPropertyBaseList< HFBAudioIn > FBPropertyBaseListAudioIn;
typedef class FBSDK_DLL FBPropertyBaseList< HFBAudioOut > FBPropertyBaseListAudioOut;
typedef class FBSDK_DLL FBPropertyBaseList< HFBAudioClip > FBPropertyBaseListAudioClip;

FB_FORWARD( FBPropertyListAudioIn );
//! <b>List:</b> AudioIn
class FBSDK_DLL FBPropertyListAudioIn : public FBPropertyBaseList< HFBAudioIn >
{
public:
	/**	Internal operation only. You cannot add to this list. */
	virtual int Add(HFBAudioIn pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual int Remove(HFBAudioIn pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual void RemoveAt(int pIndex);

	/**	Get the audio input at \e pIndex.
	*	\param	pIndex	Index of audio input to get.
	*	\return Audio input at \e pIndex.
	*/
	virtual HFBAudioIn operator[](int pIndex);

	/** Get the number of audio input.
	*	\return Number of audio input.
	*/
	virtual int GetCount();
};

FB_FORWARD( FBPropertyListAudioOut );
//! <b>List:</b> AudioOut
class FBSDK_DLL FBPropertyListAudioOut : public FBPropertyBaseList< HFBAudioOut >
{
public:
	/**	Internal operation only. You cannot add to this list. */
	virtual int Add(HFBAudioOut pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual int Remove(HFBAudioOut pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual void RemoveAt(int pIndex);

	/**	Get the audio output at \e pIndex.
	*	\param	pIndex	Index of audio output to get.
	*	\return Audio output at \e pIndex.
	*/
	virtual HFBAudioOut operator[](int pIndex);

	/** Get the number of audio output.
	*	\return Number of audio output.
	*/
	virtual int GetCount();
};

FB_FORWARD( FBPropertyListAudioClip );
//! <b>List:</b> AudioClip
class FBSDK_DLL FBPropertyListAudioClip : public FBPropertyBaseList< HFBAudioClip >
{
public:
	/**	Internal operation only. You cannot add to this list. */
	virtual int Add(HFBAudioClip pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual int Remove(HFBAudioClip pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual void RemoveAt(int pIndex);

	/**	Get the audio clip at \e pIndex.
	*	\param	pIndex	Index of audio clip to get.
	*	\return Audio clip at \e pIndex.
	*/
	virtual HFBAudioClip operator[](int pIndex);

	/** Get the number of audio clip.
	*	\return Number of audio clip.
	*/
	virtual int GetCount();
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// FBAudioIn
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** Audio In class.
*	Properties of this class are work in progress, but you can still list them and get their names.
*/
class FBSDK_DLL FBAudioIn : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare(FBAudioIn, FBComponent);
public:

	/**	Constructor.
	*	\param	pObject	For internal use only.
	*/
	FBAudioIn(HIObject pObject=NULL);
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// FBAudioOut
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** Audio Out class.
*	Properties of this class are work in progress, but you can still list them and get their names.
*/
class FBSDK_DLL FBAudioOut : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare(FBAudioOut, FBComponent);
public:

	/**	Constructor.
	*	\param	pObject	For internal use only.
	*/
	FBAudioOut(HIObject pObject=NULL);
};

//! Get default audio output.
FBSDK_DLL HFBAudioOut FBAudioOutGetDefault();

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// FBAudioClip
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** Audio Clip class.
*	This class permits you to access audio clip's properties to read or change them.
*/
class FBSDK_DLL FBAudioClip : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare(FBAudioClip, FBComponent);
public:

	/**	Constructor.
	*	\param	pFileName			The complete file path of the media file to access.
	*	\param	pSetToDefaultDest	If true and the media file open successfully, it will automatically be connected to an output device.
	*	\param	pObject				For internal use only.
	*/
	FBAudioClip(char* pFileName, bool pSetToDefaultDest=true, HIObject pObject=NULL);

	/** Virtual FBDelete function.
	*/
	virtual void FBDelete();

	/** Play audio clip now.
	*	\param	pStyle			How the audio clip should be triggered.
	*	\param	pDestination	Where the audio clip should be played. If NULL, it will play on the default destination.
	*	\return	Return true if the buffer for the audio clip was successfully allocated so that you can hear the sound.
	*/
	bool Play(FBTriggerStyle pStyle=kFBTriggerStyleContinue, HFBAudioOut pDestination=NULL);

	/** Stop any playing triggered audio clip on a specified destination.
	*	\param	pDestination	Where the audio clip is playing. If NULL, the default destination will be used.
	*/
	void Stop(HFBAudioOut pDestination=NULL);

	FBPropertyString		Filename;		//!< <b>Read Only Property:</b> Filename of media.
	FBPropertyInt			Format;			//!< <b>Read Only Property:</b> Data format of media, including rate, bits and channels count. You can typecast it to a FBAudioFmt.
	FBPropertyAudioOut		Destination;	//!< <b>Read Write Property:</b> The audio output destination where the clip will be played.
	FBPropertyTime			Duration;		//!< <b>Read Only Property:</b> Total duration of this audio clip.
	FBPropertyTime			InPoint;		//!< <b>Read Write Property:</b> When not used in the Story, this specify when the clips begin to play.
	FBPropertyAccessMode	AccessMode;		//!< <b>Read Write Property:</b> Specify the media data access mode between disk or memory.
	FBPropertyUseChnMode	UseChannelMode;	//!< <b>Read Write Property:</b> Enables you to control which track are used with stereo clips.
	FBPropertyBool			Scrubbing;		//!< <b>Read Write Property:</b> Control which clip (one at a time) can shuttle when playing a various speeds.
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef FBSDKUseNamespace
	}
#endif
#endif /* this must be the last line of this file */
