#ifndef __FBCHARACTER_H__
#define __FBCHARACTER_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/** \file fbcharacter.h
*	Contains definitions for actors, characters, and marker sets <b>In Development</b>.
*	\warning
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>

#include <fbsdk/fbcharacterextension.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif

//! All body nodes
enum FBBodyNodeId 
{
	kFBInvalidNodeId = -1,
	kFBHipsNodeId = 0,             //!< Required.
	kFBLeftHipNodeId,              //!< Required.
	kFBLeftKneeNodeId,             //!< Required.
	kFBLeftAnkleNodeId,            //!< Required.
	kFBLeftFootNodeId,             //!<
	kFBRightHipNodeId,             //!< Required.
	kFBRightKneeNodeId,            //!< Required.
	kFBRightAnkleNodeId,           //!< Required.
	kFBRightFootNodeId,            //!<
	kFBWaistNodeId,		        //!< Required, Spine 0.
	kFBChestNodeId,		        //!< Spine 1.
	kFBLeftCollarNodeId,           //!<
	kFBLeftShoulderNodeId,         //!< Required.
	kFBLeftElbowNodeId,            //!< Required.
	kFBLeftWristNodeId,            //!< Required.
	kFBRightCollarNodeId,          //!<
	kFBRightShoulderNodeId,        //!< Required.
	kFBRightElbowNodeId,           //!< Required.
	kFBRightWristNodeId,           //!< Required.
	kFBNeckNodeId,                 //!<
	kFBHeadNodeId,                 //!< Required.
	kFBLeftHipRollNodeId,          //!<
	kFBLeftKneeRollNodeId,         //!<
	kFBRightHipRollNodeId,         //!<
	kFBRightKneeRollNodeId,        //!<
    kFBLeftShoulderRollNodeId,     //!<
    kFBLeftElbowRollNodeId,        //!<
    kFBRightShoulderRollNodeId,    //!<
    kFBRightElbowRollNodeId,       //!<
	kFBSpine2NodeId,               //!<
	kFBSpine3NodeId,               //!<
	kFBSpine4NodeId,               //!<
	kFBSpine5NodeId,               //!<
	kFBSpine6NodeId,               //!<
	kFBSpine7NodeId,               //!<
	kFBSpine8NodeId,               //!<
	kFBSpine9NodeId,               //!<
	kFBLeftThumbANodeId,           //!<
	kFBLeftThumbBNodeId,           //!<
	kFBLeftThumbCNodeId,           //!<
	kFBLeftIndexANodeId,           //!<
	kFBLeftIndexBNodeId,           //!<
	kFBLeftIndexCNodeId,           //!<
	kFBLeftMiddleANodeId,          //!<
	kFBLeftMiddleBNodeId,          //!<
	kFBLeftMiddleCNodeId,          //!<
	kFBLeftRingANodeId,            //!<
	kFBLeftRingBNodeId,            //!<
	kFBLeftRingCNodeId,            //!<
	kFBLeftPinkyANodeId,           //!<
	kFBLeftPinkyBNodeId,           //!<
	kFBLeftPinkyCNodeId,           //!<
    kFBRightThumbANodeId,          //!<
    kFBRightThumbBNodeId,          //!<
    kFBRightThumbCNodeId,          //!<
    kFBRightIndexANodeId,          //!<
    kFBRightIndexBNodeId,          //!<
    kFBRightIndexCNodeId,          //!<
    kFBRightMiddleANodeId,         //!<
    kFBRightMiddleBNodeId,         //!<
    kFBRightMiddleCNodeId,         //!<
    kFBRightRingANodeId,           //!<
    kFBRightRingBNodeId,           //!<
    kFBRightRingCNodeId,           //!<
    kFBRightPinkyANodeId,          //!<
    kFBRightPinkyBNodeId,          //!<
    kFBRightPinkyCNodeId,          //!<
	kFBReferenceNodeId,            //!<
    
    // -- New bones for 2.0 --

    kFBLeftThumbInNodeId,          //!<
    kFBLeftThumbDNodeId,           //!<
    kFBLeftIndexInNodeId,          //!<
    kFBLeftIndexDNodeId,           //!<
    kFBLeftMiddleInNodeId,         //!<
    kFBLeftMiddleDNodeId,          //!<
    kFBLeftRingInNodeId,           //!<
    kFBLeftRingDNodeId,            //!<
    kFBLeftPinkyInNodeId,          //!<
    kFBLeftPinkyDNodeId,           //!<
    kFBRightThumbInNodeId,         //!<
    kFBRightThumbDNodeId,          //!<
    kFBRightIndexInNodeId,         //!<
    kFBRightIndexDNodeId,          //!<
    kFBRightMiddleInNodeId,        //!<
    kFBRightMiddleDNodeId,         //!<
    kFBRightRingInNodeId,          //!<
    kFBRightRingDNodeId,           //!<
    kFBRightPinkyInNodeId,         //!<
    kFBRightPinkyDNodeId,          //!<

    kFBLeftExtraFingerInNodeId,    //!< New extra finger bone
    kFBLeftExtraFingerANodeId,     //!< New extra finger bone
    kFBLeftExtraFingerBNodeId,     //!< New extra finger bone
    kFBLeftExtraFingerCNodeId,     //!< New extra finger bone
    kFBLeftExtraFingerDNodeId,     //!< New extra finger bone
    kFBRightExtraFingerInNodeId,   //!< New extra finger bone
    kFBRightExtraFingerANodeId,    //!< New extra finger bone
    kFBRightExtraFingerBNodeId,    //!< New extra finger bone
    kFBRightExtraFingerCNodeId,    //!< New extra finger bone
    kFBRightExtraFingerDNodeId,    //!< New extra finger bone

    kFBLeftFootThumbInNodeId,      //!<
    kFBLeftFootThumbANodeId,       //!<
	kFBLeftFootThumbBNodeId,       //!<
	kFBLeftFootThumbCNodeId,       //!<
    kFBLeftFootThumbDNodeId,       //!<
	kFBLeftFootIndexInNodeId,      //!<
    kFBLeftFootIndexANodeId,       //!<
	kFBLeftFootIndexBNodeId,       //!<
	kFBLeftFootIndexCNodeId,       //!<
    kFBLeftFootIndexDNodeId,       //!<
	kFBLeftFootMiddleInNodeId,     //!<
    kFBLeftFootMiddleANodeId,      //!<
	kFBLeftFootMiddleBNodeId,      //!<
	kFBLeftFootMiddleCNodeId,      //!<
    kFBLeftFootMiddleDNodeId,      //!<
	kFBLeftFootRingInNodeId,       //!<
    kFBLeftFootRingANodeId,        //!<
	kFBLeftFootRingBNodeId,        //!<
	kFBLeftFootRingCNodeId,        //!<
    kFBLeftFootRingDNodeId,        //!<
	kFBLeftFootPinkyInNodeId,      //!<
    kFBLeftFootPinkyANodeId,       //!<
	kFBLeftFootPinkyBNodeId,       //!<
	kFBLeftFootPinkyCNodeId,       //!<
    kFBLeftFootPinkyDNodeId,       //!<
    kFBRightFootThumbInNodeId,     //!<
    kFBRightFootThumbANodeId,      //!<
    kFBRightFootThumbBNodeId,      //!<
    kFBRightFootThumbCNodeId,      //!<
    kFBRightFootThumbDNodeId,      //!<
    kFBRightFootIndexInNodeId,     //!<
    kFBRightFootIndexANodeId,      //!<
    kFBRightFootIndexBNodeId,      //!<
    kFBRightFootIndexCNodeId,      //!<
    kFBRightFootIndexDNodeId,      //!<
    kFBRightFootMiddleInNodeId,    //!<
    kFBRightFootMiddleANodeId,     //!<
    kFBRightFootMiddleBNodeId,     //!<
    kFBRightFootMiddleCNodeId,     //!<
    kFBRightFootMiddleDNodeId,     //!<
    kFBRightFootRingInNodeId,      //!<
    kFBRightFootRingANodeId,       //!<
    kFBRightFootRingBNodeId,       //!<
    kFBRightFootRingCNodeId,       //!<
    kFBRightFootRingDNodeId,       //!<
    kFBRightFootPinkyInNodeId,     //!<
    kFBRightFootPinkyANodeId,      //!<
    kFBRightFootPinkyBNodeId,      //!<
    kFBRightFootPinkyCNodeId,      //!<
    kFBRightFootPinkyDNodeId,      //!<
    kFBLeftExtraFootFingerInNodeId,        //!< New extra finger bone
    kFBLeftExtraFootFingerANodeId,         //!< New extra finger bone
    kFBLeftExtraFootFingerBNodeId,         //!< New extra finger bone
    kFBLeftExtraFootFingerCNodeId,         //!< New extra finger bone
    kFBLeftExtraFootFingerDNodeId,         //!< New extra finger bone
    kFBRightExtraFootFingerInNodeId,       //!< New extra finger bone
    kFBRightExtraFootFingerANodeId,        //!< New extra finger bone
    kFBRightExtraFootFingerBNodeId,        //!< New extra finger bone
    kFBRightExtraFootFingerCNodeId,        //!< New extra finger bone
    kFBRightExtraFootFingerDNodeId,        //!< New extra finger bone

	kFBLeftHandNodeId,             //!<
	kFBRightHandNodeId,            //!<
    kFBNeck1NodeId,                //!<
	kFBNeck2NodeId,                //!<
	kFBNeck3NodeId,                //!<
	kFBNeck4NodeId,                //!<
	kFBNeck5NodeId,                //!<
	kFBNeck6NodeId,                //!<
	kFBNeck7NodeId,                //!<
	kFBNeck8NodeId,                //!<
	kFBNeck9NodeId,                //!<
	kFBLastNodeId                  //!<
};
FB_DEFINE_ENUM( FBSDK_DLL, BodyNodeId );

//! Last Actor NodeId
const int kFBLastActorNodeId = ( kFBHeadNodeId + 1 );

//! All effector nodes
enum FBEffectorId
{
	kFBHipsEffectorId = 0,             //!<
	kFBLeftAnkleEffectorId,            //!<
	kFBRightAnkleEffectorId,           //!<
	kFBLeftWristEffectorId,            //!<
	kFBRightWristEffectorId,           //!<
	kFBLeftKneeEffectorId,             //!<
	kFBRightKneeEffectorId,            //!<
	kFBLeftElbowEffectorId,            //!<
	kFBRightElbowEffectorId,           //!<
	kFBChestOriginEffectorId,          //!<
	kFBChestEndEffectorId,             //!<
	kFBLeftFootEffectorId,             //!<
	kFBRightFootEffectorId,            //!<
	kFBLeftShoulderEffectorId,         //!<
	kFBRightShoulderEffectorId,        //!<
	kFBHeadEffectorId,                 //!<
	kFBLeftHipEffectorId,              //!<
	kFBRightHipEffectorId,             //!<

    // -- New effector for 2.0 --

    kFBLeftHandEffectorId,             //!<
	kFBRightHandEffectorId,            //!<
	kFBLeftHandThumbEffectorId,        //!<
	kFBLeftHandIndexEffectorId,        //!<
	kFBLeftHandMiddleEffectorId,       //!<
	kFBLeftHandRingEffectorId,         //!<
	kFBLeftHandPinkyEffectorId,        //!<
	kFBLeftHandExtraFingerEffectorId,  //!<
	kFBRightHandThumbEffectorId,       //!<
	kFBRightHandIndexEffectorId,       //!<
	kFBRightHandMiddleEffectorId,      //!<
	kFBRightHandRingEffectorId,        //!<
	kFBRightHandPinkyEffectorId,       //!<
	kFBRightHandExtraFingerEffectorId, //!<
	kFBLeftFootThumbEffectorId,        //!<
	kFBLeftFootIndexEffectorId,        //!<
	kFBLeftFootMiddleEffectorId,       //!<
	kFBLeftFootRingEffectorId,         //!<
	kFBLeftFootPinkyEffectorId,        //!<
	kFBLeftFootExtraFingerEffectorId,  //!<
	kFBRightFootThumbEffectorId,       //!<
	kFBRightFootIndexEffectorId,       //!<
	kFBRightFootMiddleEffectorId,      //!<
	kFBRightFootRingEffectorId,        //!<
	kFBRightFootPinkyEffectorId,       //!<
	kFBRightFootExtraFingerEffectorId, //!<
	kFBLastEffectorId                  //!<
};
FB_DEFINE_ENUM( FBSDK_DLL, EffectorId );

//! Character Input/Output types.
enum FBCharacterInputType
{ 
	kFBCharacterInputActor, 
	kFBCharacterInputCharacter,
	kFBCharacterInputMarkerSet, 
	kFBCharacterOutputMarkerSet, 
	kFBCharacterInputStance
};
FB_DEFINE_ENUM( FBSDK_DLL, CharacterInputType );

//! Character keying modes.
enum FBCharacterKeyingMode
{ 
	kFBCharacterKeyingFullBody, 
	kFBCharacterKeyingBodyPart,
	kFBCharacterKeyingSelection, 
};
FB_DEFINE_ENUM( FBSDK_DLL, CharacterKeyingMode );

//! Where to plot a character.
enum FBCharacterPlotWhere
{
	kFBCharacterPlotOnControlRig,
	kFBCharacterPlotOnSkeleton
};
FB_DEFINE_ENUM( FBSDK_DLL, CharacterPlotWhere );

/** Get the UI name associated with a body node.
	*	\param	pBodyNodeId The body node ID.
	*	\return				The UI name for this body node.
	*/
FBSDK_DLL const char* FBCharacterBodyNodeNameFromId( FBBodyNodeId pBodyNodeId );

/** Get the UI name associated with an effector.
	*	\param	pEffectorId		The effector ID.
	*	\return					The UI name for this effector.
	*/
FBSDK_DLL const char* FBCharacterEffectorNameFromId( FBEffectorId pEffectorId );

////////////////////////////////////////////////////////////////////////////////////
// FBMarkerSet - Marker set for an actor
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBMarkerSet );
FB_DEFINE_COMPONENT( FBSDK_DLL, MarkerSet );
FB_FORWARD( FBModel );
typedef class FBSDK_DLL FBArrayTemplate<HFBModel> FBModelList;

/** Marker set class.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/
class FBSDK_DLL FBMarkerSet : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare( FBMarkerSet, FBComponent );
public:
	/** Constructor.
	*	\param	pName		Name of new marker set (default is NULL)
	*	\param	pObject		For internal use only.
	*						This parameter does not need to be specified by the developer.
	*/
	FBMarkerSet(char* pName = NULL, HIObject pObject = NULL);

	IObject_Declare(Implementation);		// Interface to IObject.

	/** Get the reference model associated with this marker set.
	*	\return					The reference model associated with the marker set.
    */
	HFBModel GetReferenceModel( );

    /** Associate a model to a marker.
    *   \param  pReferenceModel Model to be associated to the marker.
    */
	void SetReferenceModel( HFBModel pReferenceModel );

	/** Get the model associated with a marker.
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker.
	*	\return					The model associated with the marker.
    */
	HFBModel GetMarkerModel( FBBodyNodeId pNodeId, int pMarkerIndex );

    /** Associate a model to a marker.
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker.
    *   \param  pModel          Model to be associated to the marker.
    */
	void SetMarkerModel( FBBodyNodeId pNodeId, int pMarkerIndex, HFBModel pModel );

	/** Associate multiple models to markers, matching them by name.
    *   \param  pModelList		A list of models to be matched with marker names.
    *   \return					True if at least one marker was matched.
    */
	bool SetMultipleMarkerModels( FBModelList* pModelList );

    /** Get the name of marker at index \b pMarkerIndex.
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker to access.
    *   \return Name of marker at index \b pMarkerIndex.
    */
	char* GetMarkerName( FBBodyNodeId pNodeId, int pMarkerIndex );

    /** Set the name of marker at index \b pMarkerIndex.
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker to access.
    *   \param  pMarkerName     New name to give to the marker.
    */
	void SetMarkerName( FBBodyNodeId pNodeId, int pMarkerIndex, char* pMarkerName );

    //@{
    /** Get/Set a marker translation.
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker to access.
    *   \retval pTOffset        Current or new value of the marker translation.
    */
	void GetMarkerTOffset( FBBodyNodeId pNodeId, int pMarkerIndex, HFBTVector pTOffset );
	void SetMarkerTOffset( FBBodyNodeId pNodeId, int pMarkerIndex, HFBTVector pTOffset );
    //@}

    //@{
    /** Get/Set a marker rotation.
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker to access.
    *   \retval pROffset        Current or new value of the marker rotation.
    */
	void GetMarkerROffset( FBBodyNodeId pNodeId, int pMarkerIndex, HFBRVector pROffset );
	void SetMarkerROffset( FBBodyNodeId pNodeId, int pMarkerIndex, HFBRVector pROffset );
    //@}

    /** Is marker orientated ?
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker to access.
    *   \return					\b True if marker is oriented, \b false otherwise.
    */
    bool GetMarkerOriented( FBBodyNodeId pNodeId, int pMarkerIndex );

    /** Set marker to be oriented or not.
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker to access.
    *   \param  pIsOriented     Oriented or not.
    */
	void SetMarkerOriented( FBBodyNodeId pNodeId, int pMarkerIndex, bool pIsOriented );

	/** Is marker used ?
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker to access.
    *   \return					\b True if marker is used, \b false otherwise.
    */
    bool GetMarkerUsed( FBBodyNodeId pNodeId, int pMarkerIndex );

    /** Set marker to be oriented or not.
	*	\param	pNodeId			Id of Actor body node.
    *   \param  pMarkerIndex    Index of marker to access.
    *   \param  pUsed			Used or not.
    */
	void SetMarkerUsed( FBBodyNodeId pNodeId, int pMarkerIndex, bool pUsed );
	
    /** Get the number of marker in the set.
    *   \param  pNodeId			If specified, obtain the number of marker for the specific node.
    *   \return					Total number of marker.
    */
	int GetMarkerCount( FBBodyNodeId pNodeId = kFBInvalidNodeId );

	/** Get the number of used marker in the set.
    *   \param  pNodeId			If specified, obtain the number of used marker for the specific node.
    *   \return					Total number of used marker.
    */
	int GetUsedMarkerCount( FBBodyNodeId pNodeId = kFBInvalidNodeId );

    /** Add a marker to the marker set.
    *   \param	pNodeId			Id of Actor body node.   
	*	\param	pModel			The model to be associated with the marker (Optional).
	*	\param	pIsOriented		Set marker to be oriented or not (Optional).
    *   \return					Index of the new marker.
    */
	int AddMarker( FBBodyNodeId pNodeId, HFBModel pModel = NULL, bool pIsOriented = false );

	/** Specify that you are about to call a group of functions.
    *   \remark This is used to speed up operations, the UI won't be refreshed until EndTransaction() is called.
    */
	void BeginTransaction( );

	/** Specify that you are  done calling a group of functions.
    *   \remark This is used to speed up operations, the UI won't be refreshed until EndTransaction() is called.
    */
	void EndTransaction( );

};


////////////////////////////////////////////////////////////////////////////////
// FBActor - Representation of an actor
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBActor );
FB_DEFINE_COMPONENT( FBSDK_DLL, Actor );

//! Recalculate MarkerSet offset for?
enum FBRecalcMarkerSetOffset
{
	kFBRecalcMarkerSetOffsetTR,			//!< Recalculate MarkerSet offset for TR
	kFBRecalcMarkerSetOffsetROnly		//!< Recalculate MarkerSet offset for R Only
};

/**	Actor class.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*
*   To obtain the list of actors present in a scene, you need to create an
*   instance of class FBSystem, to obtain the current scene. The FBScene
*   object holds the list of actors in the property Actors.
*
*   @code
*       FBSystem lSystem;
*       HFBScene lScene = lSystem.Scene;
*       for( int lIdx = 0; lIdx < lScene->Actors.GetCount(); ++lIdx )
*       {
*           FBTrace( "Actor[%d]: '%s'\n", lIdx, (char*)lScene->Actors[lIdx] );
*       }
*   @endcode
*
*   The current actor selected in the Character tool can be obtained via
*   the FBApplication object.
*
*   @code
*       FBApplication lApplication;
*       HFBActor lActor = lApplication.CurrentActor;
*       if( lActor )
*       {
*           FBTrace( "Current actor is: '%s'\n", (char*)lActor->Name );
*       }
*       else
*       {
*           FBTrace( "No actor currently selected\n" );
*       }
*   @endcode
*
*/
class FBSDK_DLL FBActor : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare( FBActor, FBComponent );
public:
	/** Constructor.
	*	\param	pName		Name of new actor (default is NULL).
	*	\param	pObject		For internal use only.
	*						This parameter does not need to be specified by the developer.
	*/
	FBActor(char* pName = NULL, HIObject pObject = NULL);

	IObject_Declare(Implementation);		// Interface to IObject.

    /** Actual Actor destructor.
    *   This method is used to delete the actual actor object represented by an instance of FBActor.
    */
    virtual void FBDelete();

	FBPropertyMarkerSet		MarkerSet;		//!< <b>Read Write Property:</b> Associated marker set.
	FBPropertyMarkerSet		OutputMarkerSet;//!< <b>Read Write Property:</b> Associated output marker set.
	FBPropertyBool			Active; 		//!< <b>Read Write Property:</b> Is actor snap active?.
	FBPropertyBool			Locked; 		//!< <b>Read Write Property:</b> Is actor locked?.

	FBPropertyColor			BodyColor;		//!< <b>Read Write Property:</b> The color of the body of the actor.
	FBPropertyColor			SkeletonColor;	//!< <b>Read Write Property:</b> The color of the skeleton of the actor.
	FBPropertyColor			PivotColor;		//!< <b>Read Write Property:</b> The color of the pivot points of the actor.
	FBPropertyDouble		MarkerSetSize;	//!< <b>Read Write Property:</b> The size of the markers of the actor.
	FBPropertyDouble		PivotSize;		//!< <b>Read Write Property:</b> The size of the pivot points of the actor.

	FBPropertyVector3d		HipsPosition;			//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		LeftHipPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		LeftKneePosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		LeftAnklePosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		LeftFootPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		RightHipPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		RightKneePosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		RightAnklePosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		RightFootPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		WaistPosition;			//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		ChestPosition;			//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		LeftCollarPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		LeftShoulderPosition;	//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		LeftElbowPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		LeftWristPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		RightCollarPosition;	//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		RightShoulderPosition;	//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		RightElbowPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		RightWristPosition;		//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		NeckPosition;			//!< <b>Read Write Property:</b> Body part pivot of the actor.
	FBPropertyVector3d		HeadPosition;			//!< <b>Read Write Property:</b> Body part pivot of the actor.

	/** Snap the marker set of the actor.
	*	\return	True if the operation completed successfully.
	*/
	virtual bool Snap( FBRecalcMarkerSetOffset pRecalcOffset );
};


////////////////////////////////////////////////////////////////////////////////////
// FBCharacter - Representation of a character
////////////////////////////////////////////////////////////////////////////////////
FB_FORWARD( FBPlotOptions );
__FB_FORWARD( FBCharacter );
FB_DEFINE_COMPONENT( FBSDK_DLL, Character );

/**	Character class.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*   This class exposes part of the functionality associated with a Character.
*   A character can possess a number of potential sources at the same time, such as
*   an actor and another character, but with only one active at any given time.
*   Before setting the InputType to the desired value, one must make sure to have
*   previously set either the InputCharacter or the InputActor.
*
*   To obtain the list of characters present in a scene, you need to create an
*   instance of class FBSystem, to obtain the current scene. The FBScene
*   object holds the list of characters in the property Characters.
*
*   @code
*       FBSystem lSystem;
*       HFBScene lScene = lSystem.Scene;
*       for( int lIdx = 0; lIdx < lScene->Characters.GetCount(); ++lIdx )
*       {
*           FBTrace( "Character[%d]: '%s'\n", lIdx, (char*)lScene->Characters[lIdx] );
*       }
*   @endcode
*
*   The current character selected in the Character tool can be obtained via
*   the FBApplication object.
*
*   @code
*       FBApplication lApplication;
*       HFBCharacter lCharacter = lApplication.CurrentCharacter;
*       if( lCharacter )
*       {
*           FBTrace( "Current character is: '%s'\n", (char*)lCharacter->Name );
*       }
*       else
*       {
*           FBTrace( "No character currently selected\n" );
*       }
*   @endcode
*
*/
class FBSDK_DLL FBCharacter : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare( FBCharacter, FBComponent );
public:
	/** Constructor.
	*	\param	pName		Name of new character (default is NULL).
	*	\param	pObject		For internal use only.
	*						This parameter does not need to be specified by the developer.
	*/
	FBCharacter(char* pName = NULL, HIObject pObject = NULL);

	IObject_Declare(Implementation);				// Interface to IObject.

    /** Actual Character destructor.
    *   This method is used to delete the actual character object represented by an instance of FBCharacter.
    */
    virtual void FBDelete();

	FBPropertyCharacterInputType	InputType;		//!< <b>Read Write Property:</b> The input type for the character (ex: Actor).
	FBPropertyCharacterKeyingMode	KeyingMode;		//!< <b>Read Write Property:</b> The current keying mode.
	FBPropertyActor					InputActor;		//!< <b>Read Write Property:</b> The index of the actor used for the input.
	FBPropertyCharacter				InputCharacter;	//!< <b>Read Write Property:</b> The index of the character used for the input.
	FBPropertyBool				    ActiveInput;	//!< <b>Read Write Property:</b> Is the character input active?

    FBPropertyListCharacterExtension CharacterExtensions;	//!< <b>List:</b> Character Extensions in the character.

    /** AddCharacterExtension.
	*	\param pExt extension to be added to the character.
	*/
    void AddCharacterExtension(HFBCharacterExtension pExt);  

    /** Get the model associated with each body part of the character.
	*	\param pExt extension to be removed to the character.
	*/
    void RemoveCharacterExtension(HFBCharacterExtension pExt);

	/** Get the model associated with each body part of the character.
	*	\return	The model linked to the specified body part.
	*/
	HFBModel GetModel( FBBodyNodeId pBodyNodeId );

	/** Get the model associated with each body part in the Control Rig of the character.
	*	\return	The model in the Control Rig corresponding to the specified body part.
	*/
	HFBModel GetCtrlRigModel( FBBodyNodeId pBodyNodeId );

	/** Get the model associated with each effector in the Control Rig of the character.
	*	\return	The model in the Control Rig corresponding to the specified Effector.
	*/
	HFBModel GetEffectorModel( FBEffectorId pEffectorId );

	/** Plot the animation of the character.
	*	\return	True if the operation completed successfully.
	*/
	virtual bool PlotAnimation( FBCharacterPlotWhere pPlotWhere, FBPlotOptions* pPlotOptions );

	/** Test if character is ready for the Retarget operation (basically, is it in character input ?).
	*	\return	True if the character is ready.
	*/
	bool ReadyForRetarget();

	/** Retarget the animation from the input character to us.
    *   \param  pOnBaseLayer  if true, keys corrections will be made on base layer; else they will be made on another layer. 
	*/
	void Retarget( bool pOnBaseLayer );

	/** Copy the animation from the input character to us.
	*/
	void CopyAnimation();

	/** Reset the properties of the character.
	*/
	virtual void ResetProperties( );

	/** Select the objects that make a character.
    *   \param  pSelect  True to select, false to deselect.
    *   \param  pApplyToCharacter  TSould the character contraint be selected ?
    *   \param  pApplyToRig  should The rig (and its children) be selected ?
    *   \param  pApplyToExtensions  Should the character extensions (and their children) be selected ?
	*/
    void SelectModels( bool pSelect, bool pApplyToCharacter, bool pApplyToRig, bool pApplyToExtensions );

	/** Set the character in stance pose.
	*	\param pPushUndo					Should we push an undo transaction on the undo stack?
	*	\param pIncludeCharacterExtensions	Should the character extensions go to stance pose too?
	*/
	void GoToStancePose( bool pPushUndo = false, bool pIncludeCharacterExtensions = true );
};



////////////////////////////////////////////////////////////////////////////////////
// Property List: MarkerSet
////////////////////////////////////////////////////////////////////////////////////
FB_FORWARD		( FBPropertyListMarkerSet );
FB_DEFINE_LIST	( FBSDK_DLL, MarkerSet );

/** \b PropertyList: MarkerSet.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/
class FBSDK_DLL FBPropertyListMarkerSet : public FBPropertyBaseList< HFBMarkerSet >
{
	virtual int	Add( HFBMarkerSet pItem );
public:
	/**	Add a marker set.
	*	\param	pName	Name of new marker set.
	*	\return Total number of marker sets after operation.
	*/
	virtual int Add (char* pName);

	/**	Remove the marker set at \e pIndex.
	*	\param	pIndex	Index of marker set to remove.
	*/
    virtual void RemoveAt( int pIndex );

	/**	Get the marker set at \e pIndex.
	*	\param	pIndex	Index of marker set to get a handle on.
	*	\return Marker set at \e pIndex.
	*/
	virtual HFBMarkerSet operator[](int pIndex);

	/**	Get the marker set count.
	*	\return Number of marker sets.
	*/
	virtual int GetCount();

	/** Duplicate a marker set.
	*	\param	pItem	Market set to duplicate.
	*	\return	Total number of marker sets after operation.
	*/
	virtual int Duplicate(HFBMarkerSet pItem );
};


////////////////////////////////////////////////////////////////////////////////////
// Property List: Actor
////////////////////////////////////////////////////////////////////////////////////
FB_FORWARD		( FBPropertyListActor );
FB_DEFINE_LIST	( FBSDK_DLL, Actor );

/** \b PropertyList: Actor.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/
class FBSDK_DLL FBPropertyListActor : public FBPropertyBaseList< HFBActor >
{
  private:
	virtual int Add( HFBActor pItem );

  public:
	/**	Add an actor.
	*	\param	pName	Name of new actor.
	*	\return Total number of actors after operation.
	*/
	virtual int Add( char* pName );

	/**	Remove the actor at \e pIndex.
	*	\param	pIndex	Index of actor to remove.
	*/
    virtual void RemoveAt( int pIndex );

	/**	Get the actor at \e pIndex.
	*	\param	pIndex	Index of actor to get a handle on.
	*	\return Actor at \e pIndex.
	*/
	virtual HFBActor operator[]( int pIndex );

	/**	Get the actor count.
	*	\return Number of actors.
	*/
	virtual int GetCount( );

	/** Duplicate an actor.
	*	\param	pIndex	Index of actor to duplicate.
	*	\return	Total number of actors after operation.
	*/
	virtual int Duplicate( int pIndex );
};


////////////////////////////////////////////////////////////////////////////////////
// Property List: Character
////////////////////////////////////////////////////////////////////////////////////
FB_FORWARD		( FBPropertyListCharacter );
FB_DEFINE_LIST	( FBSDK_DLL, Character );

/** \b PropertyList: Character.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/
class FBSDK_DLL FBPropertyListCharacter : public FBPropertyBaseList< HFBCharacter >
{
  private:
	virtual int Add( HFBCharacter pItem );
  public:
	/**	Add a Character.
	*	\param	pName	Name of new Character.
	*	\return Total number of Characters after operation.
	*/
	virtual int Add( char* pName );

	/**	Remove the Character at \e pIndex.
	*	\param	pIndex	Index of Character to remove.
	*/
    virtual void RemoveAt( int pIndex );

	/**	Get the Character at \e pIndex.
	*	\param	pIndex	Index of Character to get a handle on.
	*	\return Character at \e pIndex.
	*/
	virtual HFBCharacter operator[]( int pIndex );

	/**	Get the Character count.
	*	\return Number of Characters.
	*/
	virtual int GetCount( );

	/** Duplicate a Character.
	*	\param	pIndex	Index of character to duplicate.
	*	\return	Total number of Characters after operation.
	*/
	virtual int Duplicate( int pIndex );
};


#ifdef FBSDKUseNamespace
	}
#endif
#endif /* _FB_CHARACTER_H_ */
