#ifndef __FBCHARACTERFACE_H__
#define __FBCHARACTERFACE_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/** \file fbcharacterface.h
*	Contains definitions for actor faces and character faces <b>In Development</b>.
*	\warning
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif


////////////////////////////////////////////////////////////////////////////////
// FBActorFace - Representation of an actor face
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBActor );
__FB_FORWARD( FBActorFace );
FB_DEFINE_COMPONENT( FBSDK_DLL, ActorFace );

/**	ActorFace class.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/
class FBSDK_DLL FBActorFace : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare( FBActorFace, FBComponent );
public:
	/** Constructor.
	*	\param	pName		Name of new actor face (default is NULL).
	*	\param	pObject		For internal use only.
	*						This parameter does not need to be specified by the developer.
	*/
	FBActorFace(char* pName = NULL, HIObject pObject = NULL);

	/** Plot the animation of the actor face.
	*	\return	True if the operation completed successfully.
	*/
	virtual bool PlotAnimation( );

	IObject_Declare(Implementation);		// Interface to IObject.

    /** Actual Actor Face destructor.
    *   This method is used to delete the actual actor face object represented by an instance of FBActorFace.
    */
    virtual void FBDelete();
};


////////////////////////////////////////////////////////////////////////////////////
// FBCharacterFace - Representation of a character
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBCharacterFace );
FB_DEFINE_COMPONENT( FBSDK_DLL, Character );

/**	Character class.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/
class FBSDK_DLL FBCharacterFace : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare( FBCharacterFace, FBComponent );
public:
	/** Constructor.
	*	\param	pName		Name of new character (default is NULL).
	*	\param	pObject		For internal use only.
	*						This parameter does not need to be specified by the developer.
	*/
	FBCharacterFace(char* pName = NULL, HIObject pObject = NULL);

	IObject_Declare(Implementation);				// Interface to IObject.

	FBPropertyActorFace				InputActorFace;	//!< <b>Read Write Property:</b> The index of the actor used for the input.
	FBPropertyBool					ActiveInput;	//!< <b>Read Write Property:</b> Is the character input active?

	/** Plot the animation of the character face.
	*	\return	True if the operation completed successfully.
	*/
	virtual bool PlotAnimation( );

    /** Actual Character Face destructor.
    *   This method is used to delete the actual character face object represented by an instance of FBCharacterFace.
    */
    virtual void FBDelete();
};



////////////////////////////////////////////////////////////////////////////////////
// Property List: ActorFace
////////////////////////////////////////////////////////////////////////////////////
FB_FORWARD		( FBPropertyListActorFace );
FB_DEFINE_LIST	( FBSDK_DLL, ActorFace );

/** \b PropertyList: Actor face.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/
class FBSDK_DLL FBPropertyListActorFace : public FBPropertyBaseList< HFBActorFace >
{
  private:
	virtual int Add( HFBActorFace pItem );

  public:
	/**	Add an actor face.
	*	\param	pName	Name of new actor.
	*	\return Total number of actor faces after operation.
	*/
	virtual int Add( char* pName );

	/**	Remove the actor face at \e pIndex.
	*	\param	pIndex	Index of actor face to remove.
	*/
    virtual void RemoveAt( int pIndex );

	/**	Get the actor face at \e pIndex.
	*	\param	pIndex	Index of actor face to get a handle on.
	*	\return Actor at \e pIndex.
	*/
	virtual HFBActorFace operator[]( int pIndex );

	/**	Get the actor face count.
	*	\return Number of actor faces.
	*/
	virtual int GetCount( );
};


////////////////////////////////////////////////////////////////////////////////////
// Property List: Character face
////////////////////////////////////////////////////////////////////////////////////
FB_FORWARD		( FBPropertyListCharacterFace );
FB_DEFINE_LIST	( FBSDK_DLL, CharacterFace );

/** \b PropertyList: Character face.
*	<b>These classes are under development and may change dramatically 
*	between versions.</b>
*/
class FBSDK_DLL FBPropertyListCharacterFace : public FBPropertyBaseList< HFBCharacterFace >
{
  private:
	virtual int Add( HFBCharacterFace pItem );
  public:
	/**	Add a Character face.
	*	\param	pName	Name of new Character face.
	*	\return Total number of Character faces after operation.
	*/
	virtual int Add( char* pName );

	/**	Remove the Character face at \e pIndex.
	*	\param	pIndex	Index of Character face to remove.
	*/
    virtual void RemoveAt( int pIndex );

	/**	Get the Character face at \e pIndex.
	*	\param	pIndex	Index of Character face to get a handle on.
	*	\return Character face at \e pIndex.
	*/
	virtual HFBCharacterFace operator[]( int pIndex );

	/**	Get the Character face count.
	*	\return Number of Character faces.
	*/
	virtual int GetCount( );
};


#ifdef FBSDKUseNamespace
	}
#endif
#endif /* _FBCHARACTERFACE_H_ */
