#ifndef __FBFOLDER_H__
#define __FBFOLDER_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file fbfolder.h
*	Folders interface for FBSDK
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif

__FB_FORWARD( FBFolder );
FB_DEFINE_COMPONENT( FBSDK_DLL, Folder );

typedef class FBSDK_DLL FBPropertyBaseList< HFBComponent > FBPropertyBaseListComp;

FB_FORWARD( FBPropertyListComp );
//! <b>List:</b> FBComponent
class FBSDK_DLL FBPropertyListComp : public FBPropertyBaseList< HFBComponent >
{
public:
	/**	Add a component to the property list.
	*	\param	pItem	Component to add to list.
	*	\return	Number of items in list after operation.
	*	\remark	A component can't be in two or more separate folders at once nor multiple times in the same one.
	*/
	virtual int Add(HFBComponent pItem);

	/**	Remove component \e pItem from property list.
	*	\param	pItem	Component to remove from list.
	*	\return Number of items in list after operation.
	*	\remark	A component can't be in two or more separate folders at once nor multiple times in the same one.
	*/
    virtual int Remove(HFBComponent pItem);

	/** Remove the component at \e pIndex.
	*	\param pIndex	Index of component to remove.
	*/
    virtual void RemoveAt(int pIndex);

	/**	Get the component at \e pIndex.
	*	\param	pIndex	Index of component to get.
	*	\return Component at \e pIndex.
	*/
	virtual HFBComponent operator[](int pIndex);

	/** Get the number of component.
	*	\return Number of components.
	*/
	virtual int GetCount();
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// FBFolder
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** Folder class.
*	This class is an interface to manipulate folders in the scene.
*/
class FBSDK_DLL FBFolder : public FBComponent 
{
	//--- Open Reality declaration.
	__FBClassDeclare(FBFolder, FBComponent);
public:

	/**	Constructor.
	*	\param	pName		Name to assign to new folder.
	*	\param	pComponent	Object used to determine folder's category.
	*	\param	pObject		For internal use only.
	*/
	FBFolder(char* pName, HFBComponent pComponent, HIObject pObject=NULL);

	/** Virtual FBDelete function.
	*/
	virtual void FBDelete();

	FBPropertyListComp	Items;	//!< <b>List:</b> List of components in the folder.
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef FBSDKUseNamespace
	}
#endif
#endif /* this must be the last line of this file */
