#ifndef __FBKEYINGGROUP_H__
#define __FBKEYINGGROUP_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file fbkeyinggroup.h
*	KeyingGroups interface for FBSDK
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif

__FB_FORWARD( FBKeyingGroup );
FB_DEFINE_COMPONENT( FBSDK_DLL, KeyingGroup );
FB_DEFINE_LIST( FBSDK_DLL, KeyingGroup );
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// FBKeyingGroup
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** KeyingGroup class.
*	This class is an interface to manipulate which properties will be keyed when active
*   A derived class could control when the keying group should activate and what content should have
*   For example a derived class could activate based one what is selected in the scene.
*/
class FBSDK_DLL FBKeyingGroup : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare(FBKeyingGroup, FBComponent);
public:

	/**	Constructor.
	*	\param	pName	Group name.
	*	\param	pObject	For internal use only.
	*/
	FBKeyingGroup(char* pName, HIObject pObject=NULL);

	/** Virtual FBDelete function.
	*/
	virtual void FBDelete();

	/**	Add property to be keyed when current keying group is active.
	*	\param	pProp	Property to be added.
	*/
	void AddProperty(HFBProperty pProp);
	/**	RemoveProperty from the keyinggroup list.
	*	\param	pProp	Property to be removed.
	*/
	void RemoveProperty(HFBProperty pProp); 

	/**	GetProperty from the keyinggroup list.
	*	\param	pIndex index of the desired property.
	*   \return property coresponding to pIndex.
	*/
	HFBProperty GetProperty(int pIndex); 

	/**	GetPropertyCount.
	*   \return the number of properties in  the keying group.
	*/
	int GetPropertyCount();

	/**	FindPropertyIndex.
	*   \param pProp must be in the list (return -1 if not).
	*   \return the index of pProp in the keyinggroup property list.
	*/
	int FindPropertyIndex( HFBProperty pProp ); 

	/**	AddObjectDependency An object dependency is the content of a keying group and will activate keying group when selected (only work if the keying group is a character extension).
	*   \param pObj a Dependency of the keying group.
	*/
	void    AddObjectDependency(HFBComponent pObj);

	/**	RemoveObjectDependency An object dependency is the content of a keying group and will activate keying group when selected (only work if the keying group is a character extension).
	*   \param pObj a Dependency of the keying group.
	*/
    void    RemoveObjectDependency(HFBComponent pObj); 
	
	/**	IsObjectDependency determine if the pObj is a dependency.
	*   \param pObj an object to test the Dependency.
	*   \return true if it depend.
	*/
    bool    IsObjectDependency(HFBComponent pObj);

	/**	IsObjectDependencySelected.
	*   \return return true as soon as a Property Owner or another Object Dependency is Selected.
	*/
	bool    IsObjectDependencySelected();

	/**	IsObjectDependencySelected empty the property list.
	*/
	void    RemoveAllProperties();
	/**	IsObjectDependencySelected empty the content list.
	*/
	void    RemoveAllObjectDependency();
	
	/**	RemoveAllSubKeyingGroup empty the child keying group.
	*/
	void    RemoveAllSubKeyingGroup();

	/**	GetParentKeyingGroupCount 
	*   \return the number of parent.
	*/
	int                 GetParentKeyingGroupCount();
	/**	GetParentKeyingGroup.
	*   \param pIndex is the index of the parent list of the current keying group.
	*   \return the parent keying group.
	*/
    HFBKeyingGroup      GetParentKeyingGroup(int pIndex);
	/**	GetSubKeyingGroupCount.
	*   \return the number of child keying group.
	*/
    int                 GetSubKeyingGroupCount();
	/**	GetSubKeyingGroup.
	*   \param pIndex index of the desired keying group child.
	*   \return the the child at the index.
	*/
    HFBKeyingGroup      GetSubKeyingGroup(int pIndex);
	/**	GetSubObjectCount.
	*   \return the number of ObjectDependency of the keying group.
	*/
    int                 GetSubObjectCount();
	/**	GetSubObject.
	*   \param pIndex index in the content Object Dependency list
	*   \return the desired object at pIndex.
	*/
    HFBComponent        GetSubObject(int pIndex);

	/**	GetCumulativePropertyCount Same as GetSubKeyingGroupCount but recursive in child keying group.
	*   \param pStopAtVisible consider all keying group and stop to the first visible keying group.
	*   \return he number of ObjectDependency of the keying group.
	*/
	int                 GetCumulativePropertyCount( bool pStopAtVisible = false );
	/**	GetCumulativeProperty Same as GetSubKeyingGroup but recursive in child keying group.
	*   \param pIndex index in the content Object Dependency list
	*   \param pStopAtVisible consider all keying group and stop to the first visible keying group.
	*   \return he number of ObjectDependency of the keying group.
	*/
    HFBProperty			GetCumulativeProperty( int pIndex, bool pStopAtVisible = false );

	/**	ClearAllItems clear object dependency, properties and child keying group.
	*/
	void ClearAllItems();


	/**	SetEnabled, will make available the keying group in keying group list of the key control UI.
	*/
	void SetEnabled(bool pEnable);

    /**	SetActive, activate the keying group.
	*/
	void SetActive(bool pActive);

};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef FBSDKUseNamespace
	}
#endif
#endif /* this must be the last line of this file */
