#ifndef __FBSCENE_H__
#define __FBSCENE_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file fbscene.h
*	Contains information pertaining to the FBScene class, a representation
*	of a scene in the 3D world.
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>
#include <fbsdk/fbcore.h>
#include <fbsdk/fbdata.h>
#include <fbsdk/fbrenderer.h>
#include <fbsdk/fbshader.h>
#include <fbsdk/fbmodel.h>
#include <fbsdk/fbvideo.h>
#include <fbsdk/fbgroup.h>
#include <fbsdk/fbobjectpose.h>

#if !defined(K_NO_CHARACTER)
	#include <fbsdk/fbcharacter.h>
	#include <fbsdk/fbcharacterface.h>
	#include <fbsdk/fbcharacterpose.h>
	#include <fbsdk/fbcharacterextension.h>
#endif

#if !defined(K_NO_DECK)
	#include <fbsdk/fbdeck.h>
#endif

#if !defined(K_NO_MANIPULATOR)
	#include <fbsdk/fbmanipulator.h>
#endif

#if !defined(K_NO_NOTE)
	#include <fbsdk/fbnote.h>
#endif

#if !defined(K_NO_POSE)
	#include <fbsdk/fbpose.h>
#endif

#if !defined(K_NO_STORY)
	#include <fbsdk/fbcommand.h>
#endif

#ifndef FBSDK_LEAN_AND_MEAN
	#include <fbsdk/fbuserobject.h>
#endif

#include <fbsdk/fbconstraint.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif



////////////////////////////////////////////////////////////////////////////////////
// FBSceneEvent
////////////////////////////////////////////////////////////////////////////////////
//! Types of model selection events.
enum FBSceneChangeType
{
	kFBSceneChangeNone,					//!< Unknown event
	kFBSceneChangeDestroy,				//!< Object destroyed
	kFBSceneChangeAttach,				//!< Object attached
	kFBSceneChangeDetach,				//!< Object detached
	kFBSceneChangeAddChild,				//!< Child added
	kFBSceneChangeRemoveChild,			//!< Child removed
	kFBSceneChangeSelect,				//!< Object selection
	kFBSceneChangeUnselect,				//!< Object deselection
	kFBSceneChangeRename,				//!< Before object rename
	kFBSceneChangeRenamePrefix,			//!< Before object rename prefix
	kFBSceneChangeRenameUnique,			//!< Before object rename unique
	kFBSceneChangeRenameUniquePrefix,	//!< Before object rename unique prefix
	kFBSceneChangeRenamed,				//!< After object rename
	kFBSceneChangeRenamedPrefix,		//!< After object rename prefix
	kFBSceneChangeRenamedUnique,		//!< After object rename unique
	kFBSceneChangeRenamedUniquePrefix,	//!< After object rename unique prefix
	kFBSceneChangeSoftSelect,			//!< Soft selection
	kFBSceneChangeSoftUnselect,			//!< Soft deselection
	kFBSceneChangeHardSelect,			//!< Hard selection
	kFBSceneChangeActivate,				//!< Activate
	kFBSceneChangeDeactivate,			//!< Deactivate
	kFBSceneChangeLoadBegin,			//!< Begin loading file
	kFBSceneChangeLoadEnd,				//!< End loading file
	kFBSceneChangeClearBegin,			//!< Begin clearing file (file new)
	kFBSceneChangeClearEnd,				//!< End clearing file (file new)
	kFBSceneChangeTransactionBegin,		//!< Begin transaction
	kFBSceneChangeTransactionEnd,		//!< End transaction
	kFBSceneChangeReSelect,				//!< Re-selection
	kFBSceneChangeChangeName,			//!< Object change name
	kFBSceneChangeChangedName,			//!< Object changed name
	kFBSceneChangePreParent,			//!< Before object parenting
	kFBSceneChangePreUnparent,			//!< Before object unparenting
	kFBSceneChangeFocus,				//!< Object have focus
	kFBSceneChangeChangedParent,		//!< Object changed parent
	kFBSceneChangeReorder,				//!< Object reorder
	kFBSceneChangeReordered,			//!< Object reordered
};

FB_DEFINE_ENUM( FBSDK_DLL, SceneChangeType );

__FB_FORWARD( FBEventSceneChange );

/** Select model event class.
*	This event occurs every time a model is:
*	- (un)selected
*	- added
*	- destroyed
*	- renamed, etc..
*/
class FBSDK_DLL FBEventSceneChange: public FBEvent {
	__FBClassDeclare( FBEventSceneChange,FBEvent );
public:
	/**	Constructor.
	*	\param pEvent Base event (internal) to obtain information from.
	*/
	FBEventSceneChange( HKEventBase pEvent );		

	FBPropertySceneChangeType	Type;			 //!< <b>Read Only Property:</b> Type of selection event.
	FBPropertyComponent			Component;		 //!< <b>Read Only Property:</b> Modified component
	FBPropertyComponent			ChildComponent;  //!< <b>Read Only Property:</b> Child component of the event.
};

////////////////////////////////////////////////////////////////////////////////////
// FBEventTakeChange
////////////////////////////////////////////////////////////////////////////////////
//! Types of take change events.
enum FBTakeChangeType	
{
	kFBTakeChangeAdded,			
	kFBTakeChangeRemoved,		
	kFBTakeChangeOpened,		
	kFBTakeChangeClosed,		
	kFBTakeChangeRenamed,		
	kFBTakeChangeUpdated,		
	kFBTakeChangeMoved,			
	kFBTakeChangeNone			
};

FB_DEFINE_ENUM( FBSDK_DLL, TakeChangeType );

__FB_FORWARD( FBEventTakeChange );

/** Take change event class.
*	This event occurs every time a take is:
*	- added
*	- destroyed
*	- renamed
*	- selected, etc.
*/
class FBSDK_DLL FBEventTakeChange: public FBEvent 
{
	__FBClassDeclare( FBEventTakeChange, FBEvent );

  public:

	/**	Constructor.
	*	\param pEvent Base event (internal) to obtain information from.
	*/
	FBEventTakeChange( HKEventBase pEvent );		

	FBPropertyTakeChangeType	Type;		 //!< <b>Read Only Property:</b> Type of take change event.
	FBPropertyTake				Take;		 //!< <b>Read Only Property:</b> The take modified.
};

////////////////////////////////////////////////////////////////////////////////////
// FBSceneList
////////////////////////////////////////////////////////////////////////////////////
FB_FORWARD		( FBPropertyListScene );
__FB_FORWARD( FBScene );
FB_DEFINE_LIST	( FBSDK_DLL, Scene );

/** \b PropertyList: Scene.
*/
class FBSDK_DLL FBPropertyListScene : public FBPropertyBaseList< HFBScene >
{
  private:
  public:
	/**	Add a scene to the list.
	*	\param	pItem	Scene to add to list.
	*	\return Number of scenes in list after operation.
	*/
	virtual int Add( HFBScene pItem );
	/**	Remove the scene at \e pIndex from list.
	*	\param	pIndex	Index of Scene to remove.
	*/
    virtual void RemoveAt( int pIndex );
	/**	Get the Scene at \e pIndex.
	*	\param	pIndex	Index of Scene to get a handle on.
	*	\return Scene at \e pIndex.
	*/
	virtual HFBScene operator[](int pIndex);
	/**	Get the Scene count.
	*	\return Number of Scenes.
	*/
	virtual int GetCount();
};

////////////////////////////////////////////////////////////////////////////////////
// FBScene
////////////////////////////////////////////////////////////////////////////////////

/**	Scene interface class.
*	This class permits the user to interact with the underlying scene, as well
*	as a few operating system calls.
*/
class FBSDK_DLL FBScene : public FBComponent {
	__FBClassDeclare( FBScene,FBComponent );

    // We want to disallow the use of the copy constructor and operator for FBScene.
	FBScene( const FBScene* );
	FBScene( const FBScene& );
    FBScene& operator=( const FBScene& );

public:

    /**	Constructor.
    *   Client code cannot instantiate objects of this class. The FBSystem class
    *   provides access to the current scene object.
	*	\param	pObject	Internal parent object.
	*/
	FBScene(HIObject pObject);

    /** Virtual FBDelete function.
	*/
	virtual void FBDelete();

	/**	Clear the elements part of the scene. Not those that belong to all the scenes.
    *   This method is being deprecated, please use FBApplication::FileNew() instead.
    */
	void							Clear();
	/** Evaluate the scene
	*	\return \b true if successful.
	*/
	bool							Evaluate();

	FBPropertyListScene				Scenes;			//!< <b>List:</b> List of all subscenes in the system
	FBPropertyModel					RootModel;		//!< <b>Read Only Property:</b> Scene Root model for that scene
	FBPropertyListCamera			Cameras;		//!< <b>List:</b> Cameras in scene.
	FBPropertyListMaterial			Materials;		//!< <b>List:</b> Materials for scene.
	FBPropertyListTexture			Textures;		//!< <b>List:</b> Textures for scene.
	FBPropertyListShader			Shaders;		//!< <b>List:</b> Shaders for scene.
	FBPropertyListTake				Takes;			//!< <b>List:</b> Takes for scene.
	FBPropertyListDevice			Devices;		//!< <b>List:</b> Devices for scene.

    FBPropertyListLight				Lights;			//!< <b>List:</b> Lights in scene.
	FBPropertyListMedia				Media;			//!< <b>List:</b> Media in scene.

#if !defined(K_NO_NOTE)
    FBPropertyListNote              Notes;          //!< <b>List:</b> Notes in scene.
#endif

#if !defined(K_NO_POSE)
	FBPropertyListPose              Poses;          //!< <b>List:</b> Poses in scene.
#endif

#if !defined(K_NO_ACTOR)
	FBPropertyListActor				Actors;			//!< <b>List:</b> Actors in scene.
	FBPropertyListActorFace			ActorFaces;		//!< <b>List:</b> ActorFaces in scene.
#endif

#if !defined(K_NO_CHARACTER)
	FBPropertyListMarkerSet			MarkerSets;		//!< <b>List:</b> MarkerSets in scene.
	FBPropertyListCharacter			Characters;		//!< <b>List:</b> Characters in scene.
	FBPropertyListCharacterFace		CharacterFaces;	//!< <b>List:</b> CharacterFaces in scene.
	FBPropertyListCharacterPose		CharacterPoses;	//!< <b>List:</b> CharacterPoses in scene.
	FBPropertyListCharacterExtension CharacterExtensions;	//!< <b>List:</b> Character Extension available in the scene.
#endif

	FBPropertyListObjectPose		ObjectPoses;	//!< <b>List:</b> ObjectPoses in scene.

#ifndef FB_KERNEL 
	FBPropertyListUserObject		UserObjects;	//!< <b>List:</b> User objects
#endif

	FBPropertyRenderer				Renderer;		//!< <b>Read Only Property:</b> Local renderer
	FBPropertyListComponent			Components;		//!< <b>List:</b> Generic List of components.
	FBPropertyListGroup				Groups;			//!< <b>List:</b> Groups available in the scene.
	FBPropertyListSet				Sets;			//!< <b>List:</b> Sets available in the scene.

#ifndef FB_KERNEL 
    FBPropertyListHandle			Handles;		//!< <b>List:</b> Handles present in the scene.
#endif

	FBPropertyTime					LocalTime;		//!< <b>Read Write Property:</b> Local time in the scene.

	FBPropertyEvent					OnChange;		//!< <b>Event:</b> Something in the scene has happened.(FBEventSceneChange)
	FBPropertyEvent					OnTakeChange;	//!< <b>Event:</b> Something related to a take has happened.(FBEventTakeChange)

};

#ifndef __FB_COMPONENT_SCENE
    #define __FB_COMPONENT_SCENE
	FB_DEFINE_COMPONENT( FBSDK_DLL, Scene );
#endif


#ifdef FBSDKUseNamespace
	}
#endif
#endif

