#ifndef __FBSDK_H__
#define __FBSDK_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file fbsdk.h
*	Base Open Reality SDK include file.
*	This file includes all of the Open Reality files required to use the SDK.
*/

#include <fbsdk/fbcomponent.h>
#include <fbsdk/fbcore.h>
#include <fbsdk/fbconfigfile.h>
#include <fbsdk/fbio.h>

#include <fbsdk/fbmath.h>
#include <fbsdk/fbmodel.h>
#include <fbsdk/fbplug.h>

#include <fbsdk/fbscene.h>
#include <fbsdk/fbshader.h>
#include <fbsdk/fbsystem.h>
#include <fbsdk/fbrenderer.h>
#include <fbsdk/fbkeyinggroup.h>

#include <kaydaraopengl.h>

#if !defined(K_NO_AUDIO)
	#include <fbsdk/fbaudio.h>
#endif

#if !defined(K_NO_DECK)
	#include <fbsdk/fbdeck.h>
#endif

#if !defined(K_NO_CHARACTER)
	#include <fbsdk/fbcharacter.h>
	#include <fbsdk/fbcharacterface.h>
	#include <fbsdk/fbcharacterextension.h>
#endif

#if !defined(K_NO_FOLDER)
	#include <fbsdk/fbfolder.h>
#endif

#if !defined(K_NO_MANIPULATOR)
	#include <fbsdk/fbmanipulator.h>
#endif

#if !defined(K_NO_NOTE)
	#include <fbsdk/fbnote.h>
#endif

#if !defined(K_NO_OPTICAL)
	#include <fbsdk/fboptical.h>
#endif

#if !defined(K_NO_POSE)
	#include <fbsdk/fbpose.h>
#endif

#if !defined(K_NO_STORY)
	#include <fbsdk/fbstory.h>
#endif

#if !defined(K_NO_VIDEO)
	#include <fbsdk/fbvideo.h>
#endif

#if !defined(K_NO_RENDERER)
	#include <fbsdk/fbvideograbber.h>
#endif

#include <fbsdk/fbconstraint.h>
#include <fbsdk/fbfilter.h>
#include <fbsdk/fbgroup.h>

#if !defined(K_NO_UI)
	// User interface includes
	#include <fbcontrols/fbcontrols.h>
	#include <fbcontrols/fbtool.h>
	#include <fbcontrols/fbuiutil.h>
	#include <fbcontrols/fbconstraintlayout.h>
	#include <fbcontrols/fbdecklayout.h>
	#include <fbcontrols/fbdevicelayout.h>
	#include <fbcontrols/fbmanipulatorlayout.h>
	#include <fbcontrols/fbshaderlayout.h>
#endif

#ifdef _MSC_VER
	#pragma warning (disable: 4660) // template-class specialization 'xx<class x*>' is alread instantiated
	#pragma warning (disable: 4702) // unreachable code
#endif

#ifdef FBSDKUseNamespace
	using namespace FBSDKNamespace;
#endif

#endif
