#ifndef __FBVIDEO_H__
#define __FBVIDEO_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file fbvideo.h
*	FBVideo and derivative classes.
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>
#include <fbsdk/fbcore.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif

FB_DEFINE_COMPONENT( FBSDK_DLL, Video			);
FB_DEFINE_COMPONENT( FBSDK_DLL, VideoSwitcher	);

/** Video declaration.
*	\param	ClassName	Name of Video class.
*	\param	Parent		Parent class of \e ClassName.
*/
#define FBVideoDeclare( ClassName, Parent ) \
	FBClassDeclare( ClassName,Parent ); \
  public: \
  ClassName(char * pName):Parent(pName) { FBClassInit; } \
  private:

/** Video implementation.
*	\param	ThisComponent	Name of Video class to implement.
*/
#define FBVideoImplementation( ThisComponent ) \
	FBClassImplementation( ThisComponent )

////////////////////////////////////////////////////////////////////////////////////
// FBVideo
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBVideo );

//! Video proxy modes.
enum FBVideoProxyMode {   
	kFBVideoProxyNone,		//!< No video proxy.
	kFBVideoProxyOnPlay,	//!< Video proxy on play.
	kFBVideoProxyAlways		//!< Always video proxy.
};

//! Video storage modes.
enum FBVideoStorageMode	{
	kFBVideoStorageDisk,			//!< Storage on disk.
	kFBVideoStorageMemory,			//!< Storage in memory.
	kFBVideoStorageFreeRunning		//!< Free running (always playing).
};

//! Video interlace modes.
enum FBVideoInterlaceMode {
	kFBVideoInterlaceNone,				//!< No interacling.
	kFBVideoInterlaceHalfFrameEven,		//!< Half frame (even field).
	kFBVideoInterlaceHalfFrameOdd,		//!< Half frame (odd field).
	kFBVideoInterlaceFullFrameEven,		//!< Full frame (even field).
	kFBVideoInterlaceFullFrameOdd		//!< Full frame (odd field).
};

//! Video color modes.
enum FBVideoFormat {
	kFBVideoFormat_Any,
	kFBVideoFormat_Other,
	kFBVideoFormat_RGBA_32,
	kFBVideoFormat_RGB_24,
	kFBVideoFormat_BGRA_32,
	kFBVideoFormat_BGR_24,
	kFBVideoFormat_BGR_16,
	kFBVideoFormat_ABGR_32,
	kFBVideoFormat_ARGB_32,
	kFBVideoFormat_422
};


FB_DEFINE_ENUM( FBSDK_DLL, VideoProxyMode		);
FB_DEFINE_ENUM( FBSDK_DLL, VideoStorageMode		);
FB_DEFINE_ENUM( FBSDK_DLL, VideoInterlaceMode	);
FB_DEFINE_ENUM( FBSDK_DLL, VideoFormat			);

/** Video media class.
*	Similar to the FBModel class, the FBVideo class serves as a general media
*	class for images, video clips and video memory, as well as the possiblity
*	of custom formats and custom live cards.
*
*   @warning    To have a valid FBVideo object, it must be constructed with
*               a string pointing to a valid media file. After the creation,
*               the method 'IsValid()' should be used to confirm the object's
*               status. An invalid object cannot be used or interact with any
*               other application object. The only property that can be read
*               and modified is its 'Filename'. To make convert an invalid
*               FBVideo object into a vali one, simply change its Filename
*               property to point to a supported media file.
*/
class FBSDK_DLL FBVideo : public FBBox {
	__FBClassDeclare( FBVideo,FBBox );
public:
	/**	Constructor.
	*	\param	pName		Name of video media.
	*	\param	pObject		Internal parent object(default=NULL).
    *   @warning    The pName parameter must point to a valid media file, otherwise
    *               the object will not be valid. Use the method 'IsValid()' to
    *               confirm the object status.
	*/
	FBVideo(char *pName, HIObject pObject=NULL);

    virtual void FBDelete();

	/** Verifies the validity of the FBVideo object.
	*	\return \b true if data is valid.
	*/
	bool IsValid();

	//--- Video (generic) properties.
    FBPropertyString				Filename;			//!< <b>Read Write Property:</b> Filename of media.
	FBPropertyVideoProxyMode		ProxyMode;			//!< <b>Read Write Property:</b> Proxy mode.
	FBPropertyVideoStorageMode		StorageMode;		//!< <b>Read Write Property:</b> Storage mode.
    FBPropertyInt					Width;				//!< <b>Read Only Property:</b> Width of image.
    FBPropertyInt					Height;				//!< <b>Read Only Property:</b> Height of image.
    FBPropertyInt					PowerOfTwoWidth;	//!< <b>Read Only Property:</b> Closest power of two walue superior to width of image.
    FBPropertyInt					PowerOfTwoHeight;	//!< <b>Read Only Property:</b> Closest power of two walue superior to height of image.
	FBPropertyVideoInterlaceMode	InterlaceMode;		//!< <b>Read Write Property:</b> Interlace mode.
	FBPropertyVideoFormat			Format;				//!< <b>Read Only Property:</b> Video format.

	//--- Video (clip) properties
	FBPropertyTime					TimeOffset;			//!< <b>Read Write Property:</b> Temporal offset for beginning of video.
	FBPropertyInt					StartFrame;			//!< <b>Read Write Property:</b> Frame to begin video playback from.
	FBPropertyInt					StopFrame;			//!< <b>Read Write Property:</b> Frame to end video playback at.
	FBPropertyDouble				FPS;				//!< <b>Read Only Property:</b> Frame rate.
	FBPropertyDouble				PlaySpeed;			//!< <b>Read Write Property:</b> Playback speed.
	FBPropertyBool					FreeRunning;		//!< <b>Read Write Property:</b> Is free Running on?
	FBPropertyBool					Loop;				//!< <b>Read Write Property:</b> Loop video clip?

	FBPropertyTime					FrameTime;			//!< <b>Read Only Property:</b> Inverse of FPS, time per frame
	FBPropertyInt					CurrentFrame;		//!< <b>Read Write Property:</b> Current frame.
	FBPropertyInt					LastFrame;			//!< <b>Read Only Property:</b> Last frame in clip.
	FBPropertyTime					LastFrameTime;		//!< <b>Read Only Property:</b> Time of last frame
	FBPropertyTime					CurrentFrameTime;	//!< <b>Read Write Property:</b> Current time in clip.
	
	/**	Draw a frame of the image to the current view.
	*	\param	pX		X position of image (default=0).
	*	\param	pY		Y position of image (default=0).
	*	\param	pW		Width of image (default=-1).
	*	\param	pH		Height of image (default=-1).
	*	\param	pFrame	Frame to draw (default=-1).
	*/
	virtual void DrawImage(int pX = 0, int pY = 0, int pW = -1, int pH = -1, int pFrame = -1);

	/**	Get the current image buffer
	*	\param	pFrame	Frame to get image for (default=-1).
	*	\return	Handle to the image buffer specified by the \e pFrame parameter.
	*/
	virtual unsigned char* GetImage(int pFrame = -1 );

	/**	Get the current image buffer resized with width and height power of two.
	*	\return	Handle to the image buffer specified by the \e pFrame parameter.
	*/
	virtual unsigned char* GetPowerOfTwoImage();
};

////////////////////////////////////////////////////////////////////////////////////
// FBVideoMemory
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBVideoMemory );

//! Video media class.
class FBSDK_DLL FBVideoMemory : public FBVideo {
	__FBClassDeclare( FBVideoMemory,FBVideo );
public:
	/**	Constructor.
	*	\param	pName		Name of video media.
	*	\param	pObject		Internal parent object(default=NULL).
	*/
	FBVideoMemory(char *pName, HIObject pObject=NULL);

	/**	Set image size.
	*	\param	pW	Width of image.
	*	\param	pH	Height of image.
	*/
	virtual void SetObjectImageSize(int pW,int pH);

    FBPropertyInt	TextureOGLId;				//!< <b>Read Write Property:</b> Opengl texture id.
};

////////////////////////////////////////////////////////////////////////////////////
// FBVideoLive
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBVideoLive );

//! Video media class.
class FBSDK_DLL FBVideoLive : public FBVideo {
	__FBClassDeclare( FBVideoLive, FBVideo );
public:
	/**	Constructor.
	*	\param	pName		Name of video media.
	*	\param	pObject		Internal parent object.
	*/
	FBVideoLive(char* pName, HIObject pObject);
};

////////////////////////////////////////////////////////////////////////////////////
// FBVideoOut
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBVideoOut );

//! Video media class.
class FBSDK_DLL FBVideoOut : public FBVideo {
	__FBClassDeclare( FBVideoOut, FBVideo );
public:
	/**	Constructor.
	*	\param	pName		Name of video media.
	*	\param	pObject		Internal parent object.
	*/
	FBVideoOut(char* pName, HIObject pObject);
};


////////////////////////////////////////////////////////////////////////////////////
// FBVideoSwitcher
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBVideoSwitcher		);
__FB_FORWARD( FBEventVideoSwitcher	);

//! Clip end actions
enum FBClipEnd { 
	kFBClipEndEnd,	//!< On clip end stop clip.
	kFBClipEndLoop	//!< On clip end loop clip.
};
//! Play modes.
enum FBPlayMode	{ 
	kFBPlayModeNoPlay,			//!< No play (most common).
	kFBPlayModePreviewToEnd,	//!< Preview clip until end.
	kFBPlayModePlay,			//!< Play clip.
	kFBPlayModeLoop,			//!< Loop clip.
	kFBPlayModePlayToEnd		//!< Play clip to end.
};

FB_DEFINE_ENUM( FBSDK_DLL, ClipEnd	);
FB_DEFINE_ENUM( FBSDK_DLL, PlayMode	);

//! Video switcher callback event.
class FBSDK_DLL FBEventVideoSwitcher : public FBEvent
{
	__FBClassDeclare( FBEventVideoSwitcher, FBEvent );
public:
	/**	Constructor.
	*	\param	pEvent	Internal video event.
	*/
	FBEventVideoSwitcher( HKEventBase pEvent );		

	FBPropertyVideoSwitcher			VideoSwitcher;		//!< <b>Read Only Property:</b> Video switcher.
	FBPropertykReference			Reference;			//!< <b>Read Only Property:</b> Data.
	FBPropertyClipEnd				EndType;			//!< <b>Read Only Property:</b> Clip end action.
};

//! Video Switcher class.
class FBSDK_DLL FBVideoSwitcher : public FBVideo
{
	__FBClassDeclare( FBVideoSwitcher, FBVideo );
public:
	/**	Constructor.
	*	\param	pName		Name of video switcher(default=NULL).
	*	\param	pObject		For internal use only(default=NULL).
	*/
	FBVideoSwitcher( char* pName = NULL, HIObject pObject = NULL );

	/** Reset the video switcher (clear all clips).
	*/
	virtual void ResetVideoSwitcher();
	/** Finish the current video.
	*/
	virtual void FinishCurrentVideo();	
	/** Prepare the next frame.
	*/
	virtual void PrepareNextFrame();
	/** Swap the current video.
	*	\param	pVideo		Video to use as new current.
	*/
	virtual void SwapCurrent( HFBVideo pVideo );
	/** Set the next clip.
	*	\param	pVideo		Next clip to load.
	*	\param	pMode		Mode to play clip with.
	*/
	virtual void SetNextClip( HFBVideo pVideo, FBPlayMode pMode );

	/**
	*/
	virtual bool IsSDKSwitcher();

	FBPropertyInt					CurrentFrame;		//!< <b>Read Write Property:</b> Current frame.
	FBPropertyPlayMode				PlayMode;			//!< <b>Read Write Property:</b> Current play mode.
	FBPropertyTime					TimeRemaining;		//!< <b>Read Only Property:</b> Time remaining.
									
	FBPropertyVideo					CurrentVideo;		//!< <b>Read Only Property:</b> Current video.
	FBPropertyEvent					OnClipEnd;			//!< <b>Event:</b> Clip end event.
	FBPropertyDevice				DeviceOwner;		//!< <b>Read Write Property:</b> Hook onto owner device.
	FBPropertyBool					UsingSystemTime;	//!< <b>Read Write Property:</b> Using the system time?
};

////////////////////////////////////////////////////////////////////////////////////
// FBPropertyListMedia
////////////////////////////////////////////////////////////////////////////////////
__FB_FORWARD( FBPropertyListMedia );
FB_DEFINE_LIST( FBSDK_DLL, Video );

//! \b PropertyList: Media
class FBSDK_DLL FBPropertyListMedia : public FBPropertyBaseList< HFBVideo >
{
public:
	/**	Add a media to the property list.
	*	\param	pItem	Media to add to list.
	*	\return	Number of items in list after operation.
	*/
	virtual int	 Add	( HFBVideo pItem );

	/**	Remove Media \e pItem from property list.
	*	\param	pItem	Media to remove from list.
	*	\return Number of items in list after operation.
	*/
    virtual int  Remove	( HFBVideo pItem );

	/**	Remove the video at \e pIndex.
	*	\param	pIndex	Index to remove video at.
	*/
    virtual void RemoveAt( int pIndex );

	/**	Get the video at \e pIndex.
	*	\param	pIndex	Index to get video at.
	*	\return Video at \e pIndex.
	*/
	virtual HFBVideo operator[](int pIndex);

	/** Get the number of media items loaded..
	*	\return	Number of videos loaded.
	*/
	virtual int  GetCount();
};

#ifdef FBSDKUseNamespace
	}
#endif
#endif
