#ifndef KARCH_ARCH_H
#define KARCH_ARCH_H
/**************************************************************************
 Copyright (C) 1994 - 2004 Systemes Alias Quebec Inc. and/or its licensors.
 All rights reserved.

 The  coded  instructions,  statements, computer programs, and/or related
 material  (collectively  the  "Data") in these files contain unpublished
 information  proprietary  to  Systemes  Alias  Quebec  Inc.  and/or  its
 licensors,  which  is protected by Canadian and US federal copyright law
 and by international treaties.

 The  Data  may  not  be  disclosed or distributed to third parties or be
 copied  or  duplicated,  in  whole or in part, without the prior written
 consent of Alias Systems Corp ("Alias").

 THE  DATA  IS  PROVIDED  "AS IS".  ALIAS HEREBY DISCLAIMS ALL WARRANTIES
 RELATING TO THE DATA, INCLUDING, WITHOUT LIMITATION, ANY AND ALL EXPRESS
 OR   IMPLIED  WARRANTIES  OF  NON-INFRINGEMENT,  MERCHANTABILITY  AND/OR
 FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL ALIAS BE LIABLE FOR
 ANY  DAMAGES WHATSOEVER, WHETHER DIRECT, INDIRECT, SPECIAL, OR PUNITIVE,
 WHETHER  IN  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 OR  IN  EQUITY,  ARISING  OUT OF ACCESS TO, USE OF, OR RELIANCE UPON THE
 DATA.
**************************************************************************/

/*
 *	Intel IA32 Architecture
 */
#define KARCH_ARCH_80286		200

#define KARCH_ARCH_I386			300

#define KARCH_ARCH_I486			400
#define KARCH_ARCH_486DX		400
#define KARCH_ARCH_486SX		420
#define KARCH_ARCH_486DX2		430
#define KARCH_ARCH_486SL		440
#define KARCH_ARCH_486SX2		450
#define KARCH_ARCH_486DX2WB		470
#define KARCH_ARCH_P24D			470
#define KARCH_ARCH_486DX4		480
#define KARCH_ARCH_486DX4WB		490

#define KARCH_ARCH_PENTIUM		500
#define KARCH_ARCH_P5A			500		// Pentium A-step
#define KARCH_ARCH_P5			510		// Pentium
#define KARCH_ARCH_P53			510
#define KARCH_ARCH_P24T			530
#define KARCH_ARCH_P55C			540		// Pentium MMX
#define KARCH_ARCH_TILLAMOOK	540		// Mobile Pentium MMX
#define KARCH_ARCH_DX4			550
#define KARCH_ARCH_P54C			570		// Mobile Pentium

#define KARCH_ARCH_PENTIUMPRO	600
#define KARCH_ARCH_P6A			600		// Pentium Pro A-step
#define KARCH_ARCH_P6			610		// Pentium Pro

#define KARCH_ARCH_PENTIUMII	630
#define KARCH_ARCH_KLAMATH		630		// Pentium Pro MMX, Pentium II
#define KARCH_ARCH_P55CT		640
#define KARCH_ARCH_DESCHUTES	650		// Pentium II, Mobile Pentium II
#define KARCH_ARCH_XEON			650		// Pentium II Xeon

#define KARCH_ARCH_COVINGTON	650		// Celeron
#define KARCH_ARCH_MENDOCINO	660		// Celeron A
#define KARCH_ARCH_DIXON		660		// Mobile Celeron A
#define KARCH_ARCH_DIXONS		660		// Mobile Pentium II, Mobile Celeron
#define KARCH_ARCH_TIMNA		660

#define KARCH_ARCH_PENTIUMIII	670
#define KARCH_ARCH_KATMAI		670		// Pentium III
#define KARCH_ARCH_TANNER		670		// Pentium III Xeon

#define KARCH_ARCH_COPPERMINE	680		// Pentium III, Mobile Pentium III
#define KARCH_ARCH_CASCADES		680		// Pentium III Xeon
#define KARCH_ARCH_KATMOCINO	680		// Celeron SSE, Mobile Celeron SSE

#define KARCH_ARCH_WILLAMETTE	690		// Pentium IV
#define KARCH_ARCH_WILLAMETTES	690		// Pentium IV
#define KARCH_ARCH_FOSTER		690
#define KARCH_ARCH_FOSTERS		690


/*
 *	Intel IA64 Architecture
 */
#define KARCH_ARCH_P7			700
#define KARCH_ARCH_MERCED		700		// Itanium

#define KARCH_ARCH_MCKINLEY
#define KARCH_ARCH_MADISON
#define KARCH_ARCH_DEERFIELD
#define KARCH_ARCH_NORTHWOOD


/*
 *	Motorola 68000 Architecture
 */
#define KARCH_CPU_MC68000		68000
#define KARCH_CPU_MC68010		68010
#define KARCH_CPU_MC68020		68020
#define KARCH_CPU_MC68030		68030
#define KARCH_CPU_MC68040		68040
#define KARCH_CPU_MC68060		68060

#define KARCH_FPU_MC68881		68881
#define KARCH_FPU_MC68882		68882
#define KARCH_FPU_MC68040		68040
#define KARCH_FPU_MC68060		68060

#define KARCH_MMU_MC68851		68851
#define KARCH_MMU_MC68030		68030
#define KARCH_MMU_MC68040		68040
#define KARCH_MMU_MC68060		68060


/*
 *	Mips Architecture
 */
#define KARCH_CPU_R2000			0x0100
#define KARCH_CPU_R2000A		0x0210
#define KARCH_CPU_R3000			0x0220
#define KARCH_CPU_R3000A		0x0230
#define KARCH_CPU_R6000			0x0300
#define KARCH_CPU_R4000			0x0400
#define KARCH_CPU_R4200			0x0420	// ICE
#define KARCH_CPU_R4400			0x0440
#define KARCH_CPU_R6000A		0x0600
#define KARCH_CPU_R4300I		0x0B00
#define KARCH_CPU_R10000		0x0900
#define KARCH_CPU_R12000		0x0E00
#define KARCH_CPU_R8000			0x1000
#define KARCH_CPU_R4600			0x2000
#define KARCH_CPU_R4700			0x2100
#define KARCH_CPU_R4650			0x2200
#define KARCH_CPU_R5000			0x2300
#define KARCH_CPU_RUNDEF		0x2900

#define KARCH_FPU_R2360			0x0100
#define KARCH_FPU_R2010			0x0200
#define KARCH_FPU_R2010A		0x0310
#define KARCH_FPU_R3010			0x0320
#define KARCH_FPU_R3010A		0x0330
#define KARCH_FPU_R6010			0x0400
#define KARCH_FPU_R4000			0x0500
#define KARCH_FPU_R10010		0x0900
#define KARCH_FPU_R12010		0x0E00 
#define KARCH_FPU_R8010			0x1000
#define KARCH_FPU_R4600			0x2000
#define KARCH_FPU_R4700			0x2100
#define KARCH_FPU_R4650			0x2200
#define KARCH_FPU_R5000			0x2300 
#define KARCH_FPU_RUNDEF		0x2900

#define KARCH_ARCH_MIPS1		1
#define KARCH_ARCH_MIPS2		2
#define KARCH_ARCH_MIPS3		3
#define KARCH_ARCH_MIPS4		4

/*
 *	DEC AXP Architecture
 */
#define KARCH_CPU_AXP21064		21064
#define KARCH_CPU_AXP21164		21164
#define KARCH_CPU_AXP21264		21264

#define KARCH_ARCH_EV4			21064
#define KARCH_ARCH_EV5			21164
#define KARCH_ARCH_EV56			21165	// BWX
#define KARCH_ARCH_PCA56		21166	// BWX, MAX
#define KARCH_ARCH_EV6			21264	// BWX, MAX, CIX
#define KARCH_ARCH_EV7			21364
#define KARCH_ARCH_EV8			21464

/*
 *	Motorola PowerPC Architecture
 */
#define KARCH_CPU_MPC403		403
#define KARCH_CPU_MPC601		601
#define KARCH_CPU_MPC603		603
#define KARCH_CPU_MPC604		604
#define KARCH_CPU_MPC604e		604		// SIROCCO
#define KARCH_CPU_MPC620		620
#define KARCH_CPU_MPC750		750
#define KARCH_CPU_MPC7400		7400
#define KARCH_CPU_MPC7500		7500
#define KARCH_CPU_MPC7600		7600

#define KARCH_ARCH_G1			601
#define KARCH_ARCH_G2			603
#define KARCH_ARCH_G3			750
#define KARCH_ARCH_G4			7400
#define KARCH_ARCH_G5			7500
#define KARCH_ARCH_G6			7600

/*
 *	Transmeta Crusoe Architecture
 */
#define KARCH_ARCH_CRUSOE

/*
 *  Sony EE Architecture
 */

#define KARCH_CPU_EE_PSX2			100
#define KARCH_CPU_EE_GSCUBE			200

#if defined(linux) || defined(__CYGWIN32__) //////////////////////////////////////////////// LINUX
	#define KARCH_DEV_GNUC			__GNUC__
	#define KARCH_ENV_UNIX			1
	#define KARCH_ENV_POSIX			1

	#if defined(linux)
		#define KARCH_ENV_LINUX			1
	#endif

	#if defined(__GNUC__)
		#ifndef _GNU_SOURCE
		#define _GNU_SOURCE
		#endif
		#define KARCH_DEV_GNUC			__GNUC__

		// CPU Determination.
		#if defined(__ia64__) && !defined(KARCH_CPU_IA64)
			#define KARCH_CPU_IA64		KARCH_ARCH_MERCED
		#elif !defined(KARCH_CPU_IA32)
			#if defined(__pentiumiii__)
				#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUMIII
			#elif defined(__pentiumii__)
				#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUMII
			#elif defined(__i686__) || defined(__pentiumpro__)
				#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUMPRO
			#elif defined(__i586__) || defined(__pentium__) || defined(__k6__)
				#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUM
			#elif defined(__i486__)
				#define KARCH_CPU_IA32		KARCH_ARCH_I486
			#elif defined(__i386__)
				#define KARCH_CPU_IA32		KARCH_ARCH_I386
			#else
				#define KARCH_CPU_IA32		KARCH_ARCH_I286
			#endif
		#endif

		// ARCH Determination.
		#if defined(KARCH_CPU_IA64)
			#define KARCH_ARCH_IA64			KARCH_CPU_IA64
		#elif defined(KARCH_CPU_IA32)
			#define KARCH_ARCH_IA32			KARCH_CPU_IA32
			
			#if (KARCH_CPU_IA32 >= KARCH_ARCH_PENTIUMII)
				#define KARCH_CPU_IA32_MMX
			#endif
			#if (KARCH_CPU_IA32 >= KARCH_ARCH_PENTIUMIII)
				#define KARCH_CPU_IA32_SIMD
			#endif
		#endif
	#else
		#define KARCH_DEV_GENERIC		1
	#endif
#elif defined(_WIN64)	//////////////////////////////////////////////// WIN64
	#define KARCH_CPU_IA64				KARCH_ARCH_MERCED
	#if defined(KARCH_CPU_IA64)
		#define KARCH_ARCH_IA64			KARCH_CPU_IA64
	#endif
	#define KARCH_ENV_WIN				1
	#define KARCH_ENV_WIN32				_WIN32 // also defined, symmetrically to _WIN32 vs _WIN64
	#define KARCH_ENV_WIN64				_WIN64
	#if defined(_WINNT)
		#define KARCH_ENV_WINNT			_WINNT
	#endif
	#define _WIN32_WINNT				0x0500 // for SetThreadIdealProcessor,TryEnterCriticalSection that does not work on windows 95/98
	#define KARCH_DEV_MSC				_MSC_VER
	#define KARCH_ARCH_GENERIC			1
	#define KARCH_ARCH_NATIVE64			1
#elif defined(_XBOX)
	#define KARCH_ENV_WIN				1
	#define KARCH_ENV_WIN32				_WIN32
	#define KARCH_ENV_XBOX				_XBOX
	#define KARCH_DEV_MSC				_MSC_VER
	#define KARCH_ARCH_IA32				_M_IX86	
	#define KARCH_CPU_IA32				KARCH_ARCH_PENTIUM	
	//#define KARCH_CPU_IA32_MMX
	//#define KARCH_CPU_IA32_SIMD

#elif defined(_WIN32)	//////////////////////////////////////////////// WIN32
	#define KARCH_ENV_WIN				1
	#define KARCH_ENV_WIN32				_WIN32
	#if defined(_WINNT)
		#define KARCH_ENV_WINNT			_WINNT
	#endif
	#define _WIN32_WINNT 0x0400  // for SetThreadIdealProcessor,TryEnterCriticalSection that does not work on windows 95/98
	#if defined(__MINGW32__)
		#define KARCH_ENV_MING32	__MINGW32__
	#endif	
	#if defined(__ICL)
		#define KARCH_DEV_INTEL		__ICL
	#endif
	#if defined(_MSC_VER)
		#define KARCH_DEV_MSC		_MSC_VER
	#elif defined(__GNUC__)
		#define KARCH_DEV_GNUC			__GNUC__
		#if !defined(KARCH_CPU_IA32)
			#if defined(__pentiumiii__)
				#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUMIII
			#elif defined(__pentiumii__)
				#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUMII
			#elif defined(__i686__) || defined(__pentiumpro__)
				#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUMPRO
			#elif defined(__i586__) || defined(__pentium__) || defined(__k6__)
				#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUM
			#elif defined(__i486__)
				#define KARCH_CPU_IA32		KARCH_ARCH_I486
			#elif defined(__i386__)
				#define KARCH_CPU_IA32		KARCH_ARCH_I386
			#else
				#define KARCH_CPU_IA32		KARCH_ARCH_I286
			#endif
		#endif
		#if !defined(KARCH_ARCH_IA32)
			#define KARCH_ARCH_IA32			KARCH_CPU_IA32
		#elif (KARCH_ARCH_IA32 < KARCH_CPU_IA32)
			#error "Selected architecture doesn't support selected instruction set"
		#endif
		#if (KARCH_CPU_IA32 >= KARCH_ARCH_PENTIUMII)
			#define KARCH_CPU_IA32_MMX
		#endif
		#if (KARCH_CPU_IA32 >= KARCH_ARCH_PENTIUMIII)
			#define KARCH_CPU_IA32_SIMD
		#endif
	#else
		#define KARCH_DEV_GENERIC		1
	#endif
	#if defined(_M_IX86)
		#define KARCH_ARCH_IA32			_M_IX86
//		#define KARCH_CPU_IA32			KARCH_ARCH_PENTIUMII // to force a minimum of PENTIUM II
		#if !defined(KARCH_CPU_IA32)
			#if (KARCH_ARCH_IA32 >= KARCH_ARCH_PENTIUM)
				#define KARCH_CPU_IA32	KARCH_ARCH_PENTIUM
			#else
				#define KARCH_CPU_IA32	KARCH_ARCH_IA32
			#endif
		#endif
		#if (KARCH_CPU_IA32 >= KARCH_ARCH_PENTIUMII)
			#define KARCH_CPU_IA32_MMX
		#endif
		#if (KARCH_CPU_IA32 >= KARCH_ARCH_PENTIUMIII)
			#define KARCH_CPU_IA32_SIMD
		#endif
	#elif defined(_M_IA64)
		#define KARCH_ARCH_IA64			_M_IA64
	#elif defined(_M_ALPHA)
		#define KARCH_ARCH_ALPHA		_M_ALPHA
		#define KARCH_ARCH_NATIVE64		1
	#elif defined(_M_MPPC)
		#define KARCH_ARCH_PPC			_M_MPPC
	#elif defined(_M_MRX000)
		#if (_M_MRX000 >= 5000)
			#define KARCH_ARCH_MIPS		KARCH_ARCH_MIPS4
			#define KARCH_ARCH_NATIVE64	1
		#elif (_M_MRX000 >= 4000)
			#define KARCH_ARCH_MIPS		KARCH_ARCH_MIPS3
			#define KARCH_ARCH_NATIVE64	1
		#else
			#define KARCH_ARCH_MIPS		KARCH_ARCH_MIPS1
		#endif
	#else
		#define KARCH_ARCH_GENERIC		1
	#endif
#elif defined(__sgi)	//////////////////////////////////////////////// SGI
	#include <sgidefs.h>

	#define KARCH_ENV_UNIX				1
	#define KARCH_ENV_POSIX				1

	#if defined(_XOPEN5)
		#define KARCH_ENV_IRIX			65
	#else
		#define KARCH_ENV_IRIX			62
	#endif

	#ifdef _MIPS_ISA
		#if ( _MIPS_ISA == _MIPS_ISA_MIPS4 )
			#define KARCH_ARCH_MIPS		KARCH_ARCH_MIPS4
			#define KARCH_ARCH_NATIVE64	1
		#elif (_MIPS_ISA == _MIPS_ISA_MIPS3)
			#define KARCH_ARCH_MIPS		KARCH_ARCH_MIPS3
			#define KARCH_ARCH_NATIVE64	1
		#elif (_MIPS_ISA == _MIPS_ISA_MIPS2)
			#define KARCH_ARCH_MIPS		KARCH_ARCH_MIPS2
		#elif (_MIPS_ISA == _MIPS_ISA_MIPS1)
			#define KARCH_ARCH_MIPS		KARCH_ARCH_MIPS1
		#else
			#define KARCH_ARCH_MIPS		0
		#endif
	#else
		#define KARCH_ARCH_MIPS		0
	#endif
	#if defined(_MIPS_SIM)
		#if (_MIPS_SIM == _MIPS_SIM_ABI64)
			#if defined(__GNUC__)
				#define KARCH_DEV_GNUC			__GNUC__
				#define _WCHAR_T
			#else
				#if defined(_COMPILER_VERSION)
					#define KARCH_DEV_MIPSPRO	_COMPILER_VERSION
				#else
					#define KARCH_DEV_MIPSPRO	0
				#endif
			#endif
			#define KARCH_ENV_IRIX64	64
		#elif (_MIPS_SIM == _MIPS_SIM_NABI32)
			#if defined(__GNUC__)
				#define KARCH_DEV_GNUC			__GNUC__
				#define _WCHAR_T
			#else		
				#if defined(_COMPILER_VERSION)
					#define KARCH_DEV_MIPSPRO	_COMPILER_VERSION
				#else
					#define KARCH_DEV_MIPSPRO	0
				#endif
			#endif
			#define KARCH_ENV_IRIX32	32
		#else
			#if defined(__GNUC__)
				#define KARCH_DEV_GNUC			__GNUC__
				#define _WCHAR_T
			#else
				#if defined(_COMPILER_VERSION)
					#define KARCH_DEV_MIPS		_COMPILER_VERSION
				#else
					#define KARCH_DEV_MIPS		0
				#endif
			#endif
			#define KARCH_ENV_IRIX32	32
		#endif
	#else
		#if defined(_COMPILER_VERSION)
			#define KARCH_DEV_MIPS		_COMPILER_VERSION
		#else
			#define KARCH_DEV_MIPS		0
		#endif
		#define KARCH_ENV_IRIX32	32
	#endif

#elif defined(PSX2)

	#define KARCH_DEV_EE
	#define KARCH_DEV_GNUC_EE
	#define KARCH_ENV_GENERIC
	#define KARCH_ARCH_EE
	
	#if defined(GSCUBE)
		#define KARCH_ARCH_GSCUBE
		#define KARCH_CPU_EE KARCH_CPU_EE_GSCUBE
	#else
		#define KARCH_ARCH_PSX2
		#define KARCH_CPU_EE KARCH_CPU_EE_PSX2
	#endif

#elif defined(__MWERKS__)

    #define KARCH_DEV_MACOSX
    #define KARCH_ENV_MACOSX
    #define KARCH_ARCH_POWERPC
    #define KARCH_CPU_POWERPC
	#define KARCH_ENV_UNIX			1
	#if defined(__MACH__)
		#define KARCH_ENV_POSIX			1
	#else
		#define KARCH_ENV_MACOSX_CFM
	#endif
	#define __CF_USE_FRAMEWORK_INCLUDES__

#elif defined(__MACH__)

	#if defined(__i386__)
		#define KARCH_CPU_IA32		KARCH_ARCH_PENTIUM
	 	#define KARCH_ARCH_IA32		KARCH_CPU_IA32
	#else
	    #define KARCH_ARCH_POWERPC
		#define KARCH_CPU_POWERPC
	#endif
	
    #define KARCH_DEV_MACOSX
    #define KARCH_DEV_GNUC_MACOSX
    #define KARCH_ENV_MACOSX
    #define KARCH_DEV_GNUC			__GNUC__
	#define KARCH_ENV_UNIX			1
	#define KARCH_ENV_POSIX			1

#else	//////////////////////////////////////////////// GENERIC
	#define KARCH_ENV_GENERIC				1
	#define KARCH_DEV_GENERIC				1
	#define KARCH_ARCH_GENERIC				1
#endif

#endif /* KARCH_ARCH_H */
