#ifndef ARCH_TYPES_MIPS_H
#define ARCH_TYPES_MIPS_H
/**************************************************************************
 Copyright (C) 1994 - 2004 Systemes Alias Quebec Inc. and/or its licensors.
 All rights reserved.

 The  coded  instructions,  statements, computer programs, and/or related
 material  (collectively  the  "Data") in these files contain unpublished
 information  proprietary  to  Systemes  Alias  Quebec  Inc.  and/or  its
 licensors,  which  is protected by Canadian and US federal copyright law
 and by international treaties.

 The  Data  may  not  be  disclosed or distributed to third parties or be
 copied  or  duplicated,  in  whole or in part, without the prior written
 consent of Alias Systems Corp ("Alias").

 THE  DATA  IS  PROVIDED  "AS IS".  ALIAS HEREBY DISCLAIMS ALL WARRANTIES
 RELATING TO THE DATA, INCLUDING, WITHOUT LIMITATION, ANY AND ALL EXPRESS
 OR   IMPLIED  WARRANTIES  OF  NON-INFRINGEMENT,  MERCHANTABILITY  AND/OR
 FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL ALIAS BE LIABLE FOR
 ANY  DAMAGES WHATSOEVER, WHETHER DIRECT, INDIRECT, SPECIAL, OR PUNITIVE,
 WHETHER  IN  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 OR  IN  EQUITY,  ARISING  OUT OF ACCESS TO, USE OF, OR RELIANCE UPON THE
 DATA.
**************************************************************************/

#ifdef KARCH_DEV_GNUC
#define _WCHAR_T
#endif
#include <sys/types.h>
#include <sgidefs.h>
#include <sys/endian.h>	// BYTE_ORDER
#include <limits.h>

#if	(BYTE_ORDER == BIG_ENDIAN)
	#define KARCH_BIG_ENDIAN
#elif (BYTE_ORDER == LITTLE_ENDIAN)
	#define KARCH_LITTLE_ENDIAN
#else
#endif

#define K_CHAR(x)			char(x)
#define K_SCHAR(x)			kSChar(x)
#define K_UCHAR(x)			kUChar(x##U)

typedef unsigned short		kWChar;			/* international character */
#define K_WCHAR(x)			kWChar(x)
#define K_WCHAR_MIN			K_WCHAR(0)
#define K_WCHAR_MAX			K_WCHAR(65535)
typedef kWChar *			kWCharPtr;		/* international string */

#ifdef K_UNICODE
    typedef kWChar char;
    typedef kWCharPtr kTCharPtr;
    #ifndef _T
        #define _T(a) L ## a
    #endif
#else
    typedef char char;
    typedef char* kTCharPtr;
    #ifndef _T
        #define _T(a) a
    #endif
#endif

#define K_SHORT(x)			kShort(x)
#define K_USHORT(x)			kUShort(x##U)
#define K_SHORT_MIN			K_SHORT(-32768)
#define K_SHORT_MAX			K_SHORT(32767)
#define K_USHORT_MIN		K_USHORT(0)
#define K_USHORT_MAX		K_USHORT(65535)

#define K_INT(x)			(x)
#define K_UINT(x)			(x##U)
#define K_INT_MIN			K_INT(0x80000000)
#define K_INT_MAX			K_INT(0x7fffffff)
#define K_UINT_MIN			K_UINT(0)
#define K_UINT_MAX			K_UINT(0xffffffff)

typedef signed long			kLong;
#define K_LONG(x)			(x##L)
typedef unsigned long		kULong;
#define K_ULONG(x)			(x##UL)
#if (_MIPS_SIM == _MIPS_SIM_ABI64)
#define K_LONG_MIN			K_LONG(-0x8000000000000000)
#define K_LONG_MAX			K_LONG(0x7fffffffffffffff)
#define K_ULONG_MIN			K_ULONG(0)
#define K_ULONG_MAX			K_ULONG(0xffffffffffffffff)
#else
#define K_LONG_MIN			K_LONG(0x80000000)
#define K_LONG_MAX			K_LONG(0x7fffffff)
#define K_ULONG_MIN			K_ULONG(0)
#define K_ULONG_MAX			K_ULONG(0xffffffff)
#endif

typedef signed long long	kLongLong;
#define K_LONGLONG(x)		(x##LL)
typedef unsigned long long	kULongLong;
#define K_ULONGLONG(x)		(x##ULL)
#define K_LONGLONG_MIN		K_LONGLONG(-0x8000000000000000)
#define K_LONGLONG_MAX		K_LONGLONG(0x7fffffffffffffff)
#define K_ULONGLONG_MIN		K_ULONGLONG(0)
#define K_ULONGLONG_MAX		K_ULONGLONG(0xffffffffffffffff)

#define K_FLOAT(x)			(x##F)
#define K_FLOAT_MIN			FLT_MIN					// minimum positive value
#define K_FLOAT_MAX			FLT_MAX					// maximum positive value

#define K_DOUBLE(x)			(x)
#define K_DOUBLE_MIN		DBL_MIN					// minimum positive value
#define K_DOUBLE_MAX		DBL_MAX					// maximum positive value


typedef kSChar				kInt8;
typedef kUChar				kUInt8;

typedef kShort				kInt16;
typedef kUShort				kUInt16;

typedef int				kInt32;
typedef kUInt				kUInt32;

typedef kLongLong			kInt64;
typedef kULongLong			kUInt64;
#define K_INT64_MIN			K_LONGLONG_MIN
#define K_INT64_MAX			K_LONGLONG_MAX
#define K_UINT64_MIN		K_ULONGLONG_MIN
#define K_UINT64_MAX		K_ULONGLONG_MAX

typedef int				kEnum;

#define kOffset				kULong

typedef kOffset				kSizeT;

#define K_REFERENCE_MIN		K_ULONG_MIN
#define K_REFERENCE_MAX		K_ULONG_MAX

#define K_INLINE			inline
#define K_FORCEINLINE		K_INLINE

#define K_TEMPLATE_SPEC(t)
#define K_TEMPLATE_SPEC2(t1, t2)
#ifdef KARCH_DEV_MIPSPRO
#define K_ASM
#endif

typedef kInt32					kAtomic;
#define K_ATOMIC_MIN			K_INT32_MIN
#define K_ATOMIC_MAX			K_INT32_MAX
#define K_SIZEOF_ATOMIC			4
#define K_ATOMIC_BITS			32

// Atomic definitions

#if defined(KARCH_DEV_MIPSPRO) || defined(KARCH_DEV_GNUC)
    typedef kUInt64				kLongAtomic;
	#define K_LONGATOMIC_MIN	K_UINT64_MIN
	#define K_LONGATOMIC_MAX	K_UINT64_MAX
	#define K_SIZEOF_LONGATOMIC	8
	#define K_LONGATOMIC_BITS	64
#endif

#endif /* KARCH_TYPES_MIPS_H */
