#ifndef KARCH_TYPES_H
#define KARCH_TYPES_H
/**************************************************************************
 Copyright (C) 1994 - 2004 Systemes Alias Quebec Inc. and/or its licensors.
 All rights reserved.

 The  coded  instructions,  statements, computer programs, and/or related
 material  (collectively  the  "Data") in these files contain unpublished
 information  proprietary  to  Systemes  Alias  Quebec  Inc.  and/or  its
 licensors,  which  is protected by Canadian and US federal copyright law
 and by international treaties.

 The  Data  may  not  be  disclosed or distributed to third parties or be
 copied  or  duplicated,  in  whole or in part, without the prior written
 consent of Alias Systems Corp ("Alias").

 THE  DATA  IS  PROVIDED  "AS IS".  ALIAS HEREBY DISCLAIMS ALL WARRANTIES
 RELATING TO THE DATA, INCLUDING, WITHOUT LIMITATION, ANY AND ALL EXPRESS
 OR   IMPLIED  WARRANTIES  OF  NON-INFRINGEMENT,  MERCHANTABILITY  AND/OR
 FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL ALIAS BE LIABLE FOR
 ANY  DAMAGES WHATSOEVER, WHETHER DIRECT, INDIRECT, SPECIAL, OR PUNITIVE,
 WHETHER  IN  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 OR  IN  EQUITY,  ARISING  OUT OF ACCESS TO, USE OF, OR RELIANCE UPON THE
 DATA.
**************************************************************************/

#ifndef KARCH_ARCH_H
	#include <karch/arch.h>
#endif

// Common independant definitions

typedef void*				kPointer;
typedef signed char			kByte;         /* signed 8-bit integer         */
typedef unsigned char		kUByte;        /* unsigned 8-bit integer       */
typedef signed char			kSChar;
typedef unsigned char		kUChar;
typedef unsigned int		kUInt;
typedef signed short		kShort;
typedef unsigned short		kUShort;

typedef double				kVector3[3];   /* 3 x 64-bit real              */
typedef double				kVector4[4];   /* 4 x 64-bit real              */

#define K_SCHAR_MIN			(-128)
#define K_SCHAR_MAX			(127)
#define K_UCHAR_MIN			(0)
#define K_UCHAR_MAX			(255)

#define K_INT8_MIN			(-128)
#define K_INT8_MAX			(127)
#define K_UINT8_MIN			(0)
#define K_UINT8_MAX			(255)

#define K_INT16_MIN			(-32768)
#define K_INT16_MAX			(32767)
#define K_UINT16_MIN		(0)
#define K_UINT16_MAX		(65535)

#define K_INT32_MIN			(0x80000000)
#define K_INT32_MAX			(0x7fffffff)
#define K_UINT32_MIN		(0)
#define K_UINT32_MAX		(0xffffffff)

#if defined(KARCH_ARCH_IA32)
#include <karch/types-ia32.h>
#elif defined(KARCH_ARCH_IA64)
#include <karch/types-ia64.h>
#elif defined(KARCH_ARCH_MIPS)
#include <karch/types-mips.h>
#elif defined(KARCH_ENV_WIN32)
#include <karch/types-win32.h>
#elif defined(KARCH_ARCH_EE)
#include <karch/types-ee.h>
#elif defined (KARCH_ARCH_POWERPC)
#include <karch/types-powerpc.h>
#else
	#error "Architecture not supported"
#endif

// Common dependant definitions

typedef kOffset				kReference;

#endif
