#ifndef _KAYDARA_LIB_H_
#define _KAYDARA_LIB_H_
/**************************************************************************
 Copyright (C) 1994 - 2004 Systemes Alias Quebec Inc. and/or its licensors.
 All rights reserved.

 The  coded  instructions,  statements, computer programs, and/or related
 material  (collectively  the  "Data") in these files contain unpublished
 information  proprietary  to  Systemes  Alias  Quebec  Inc.  and/or  its
 licensors,  which  is protected by Canadian and US federal copyright law
 and by international treaties.

 The  Data  may  not  be  disclosed or distributed to third parties or be
 copied  or  duplicated,  in  whole or in part, without the prior written
 consent of Alias Systems Corp ("Alias").

 THE  DATA  IS  PROVIDED  "AS IS".  ALIAS HEREBY DISCLAIMS ALL WARRANTIES
 RELATING TO THE DATA, INCLUDING, WITHOUT LIMITATION, ANY AND ALL EXPRESS
 OR   IMPLIED  WARRANTIES  OF  NON-INFRINGEMENT,  MERCHANTABILITY  AND/OR
 FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL ALIAS BE LIABLE FOR
 ANY  DAMAGES WHATSOEVER, WHETHER DIRECT, INDIRECT, SPECIAL, OR PUNITIVE,
 WHETHER  IN  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 OR  IN  EQUITY,  ARISING  OUT OF ACCESS TO, USE OF, OR RELIANCE UPON THE
 DATA.
**************************************************************************/

#include <kaydara.h>
#include <kaydaradef.h>

enum kFBDllOperation { kFBDllLoad, kFBDllUnLoad };

	#if defined(KARCH_ENV_WIN32)

    #define FB_DLL_INIT(DLLNAME,STARTUP)\
        __declspec(dllexport) void EntryPoint##DLLNAME(kFBDllOperation STARTUP);\
			BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason, LPVOID lpvReserved )\
			{ \
				switch (fdwReason) \
				{ \
                case DLL_PROCESS_ATTACH: EntryPoint##DLLNAME(kFBDllLoad); break; \
                case DLL_PROCESS_DETACH: EntryPoint##DLLNAME(kFBDllUnLoad); break; \
				} \
				return TRUE; \
			}\
        void EntryPoint##DLLNAME(kFBDllOperation STARTUP)

#elif defined(KARCH_ENV_IRIX) 
    #define FB_DLL_INIT( DllName,Startup ) \
    void EntryPoint##DllName(kFBDllOperation Startup); \
		extern "C" void KdsoInit( void ) \
		{ \
        EntryPoint##DllName(kFBDllLoad);\
		}\
		extern "C" void KdsoDone( void ) \
		{ \
        EntryPoint##DllName(kFBDllUnLoad);\
		}\
    void EntryPoint##DllName(kFBDllOperation Startup)
#elif defined (KARCH_ENV_LINUX)
    #define FB_DLL_INIT( DllName,Startup ) \
    void EntryPoint##DllName(kFBDllOperation Startup); \
    extern "C" void KdsoInit##DllName ( void ) \
		{ \
        EntryPoint##DllName(kFBDllLoad);\
		}\
    class Init##DllName { public: Init##DllName ()  {KdsoInit##DllName (); } }; \
    static Init##DllName Flakel##DllName; \
		extern "C" void KdsoDone( void ) \
		{ \
        EntryPoint##DllName(kFBDllUnLoad);\
		}\
    void EntryPoint##DllName(kFBDllOperation Startup)
#elif defined(KARCH_ENV_MACOSX)
    #define FB_DLL_INIT( DllName,Startup ) \
    void EntryPoint##DllName(kFBDllOperation Startup); \
    extern "C" void KdsoInit##DllName( void ) \
    { \
        EntryPoint##DllName(kFBDllLoad);\
    }\
    extern "C" void KdsoDone##DllName( void ) \
    { \
        EntryPoint##DllName(kFBDllUnLoad);\
    }\
    void EntryPoint##DllName(kFBDllOperation Startup)

#endif

#define KO_MODULE_CALL( Name ) \
	extern void KModule##Name( ); \
	KModule##Name( );

#ifdef KARCH_ENV_MACOSX
#define FB_EXT_INIT(libname)\
{\
	/*extern "C"*/ void KdsoInit##libname( void ); \
	KdsoInit##libname();\
}
#else
#define FB_EXT_INIT(libname)
#endif

#endif /* _KAYDARA_LIB_H_ */
