#ifndef _IObject_H
#define _IObject_H
/**************************************************************************
 Copyright (C) 1994 - 2004 Systemes Alias Quebec Inc. and/or its licensors.
 All rights reserved.

 The  coded  instructions,  statements, computer programs, and/or related
 material  (collectively  the  "Data") in these files contain unpublished
 information  proprietary  to  Systemes  Alias  Quebec  Inc.  and/or  its
 licensors,  which  is protected by Canadian and US federal copyright law
 and by international treaties.

 The  Data  may  not  be  disclosed or distributed to third parties or be
 copied  or  duplicated,  in  whole or in part, without the prior written
 consent of Alias Systems Corp ("Alias").

 THE  DATA  IS  PROVIDED  "AS IS".  ALIAS HEREBY DISCLAIMS ALL WARRANTIES
 RELATING TO THE DATA, INCLUDING, WITHOUT LIMITATION, ANY AND ALL EXPRESS
 OR   IMPLIED  WARRANTIES  OF  NON-INFRINGEMENT,  MERCHANTABILITY  AND/OR
 FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL ALIAS BE LIABLE FOR
 ANY  DAMAGES WHATSOEVER, WHETHER DIRECT, INDIRECT, SPECIAL, OR PUNITIVE,
 WHETHER  IN  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 OR  IN  EQUITY,  ARISING  OUT OF ACCESS TO, USE OF, OR RELIANCE UPON THE
 DATA.
**************************************************************************/

/** Basic includes **/
#include <kaydara.h>

#ifdef K_PLUGIN
	#define IObject    IKObject
	#define HIObject   HIKObject
	#define IObjectID  IKObjectID
	#define IKObjectID 0
	#define IObjectDerived      public IKObject
#else
	#define IObjectID  0
	#define IObjectDerived      public IObject
#endif

/** forwarding **/
K_FORWARD( IObject )

/** other types **/
typedef unsigned long kInterfaceID;

/** MACRO Base definitions **/
#define FncDefine(PFNC,ISPURE) virtual PFNC##ISPURE
#define Pure           =0;
#define Implementation ;
#define IObjectImplement(ClassName,IObjectOwner) \
    HIObject ClassName##::IQuery(kInterfaceID pInterfaceID,int IsLocal) {\
        if ((IObjectOwner!=NULL) && (!IsLocal)) {\
            return IObjectOwner->IQuery(pInterfaceID);\
        }\
        switch (pInterfaceID) 
#define IObjectEnd return NULL; }
#define ILOCAL          1

#define IQUERY(Object,Interface) ((H##Interface)((Object)->IQuery(Interface##ID,0)))
#define IQUERYLOCAL(Object,Interface) ( (H##Interface)((Object)->IQuery(Interface##ID,ILOCAL)))

#define IQ(Object,Interface) IQUERY(Object,Interface)
#define IQL(Object,Interface) IQUERYLOCAL(Object,Interface)

/*********************************************************************
 *  Class IObject
 *    This is the base class of all Important interfaces of the system 
 *********************************************************************/

#define IObject_Declare(IsPure)\
public:\
    virtual HIObject	IQuery(kInterfaceID pInterfaceID, int IsLocal=0)IsPure\
    virtual void		Destroy(int IsLocal=0)IsPure\

#define IQuery_Declare(IsPure)\
public:\
    virtual HIObject IQuery (kInterfaceID pInterfaceID, int IsLocal=0)IsPure\
    
class IObject {
    IObject_Declare(Pure)
};


typedef HIObject (* kObjectCreatorFnc)(HIObject pOwner,char *pName,void *pData);

#ifdef KARCH_DEV_MSC
	#define K_INTERFACE_SPECIAL __declspec(novtable)
	#define NO_DLL				__declspec()		// Use for the Module parameter if the interface is not exported
#else 
	#define K_INTERFACE_SPECIAL 
	#define NO_DLL									// Use for the Module parameter if the interface is not exported
#endif

#define K_INTERFACE( Name,Id ) \
K_FORWARD( Name ) \
const int Name##ID = Id; \
class K_INTERFACE_SPECIAL Name : IObjectDerived { \
    Name##_Declare(Pure) \
} 

#endif  // Must be the last line of the include file


