//***************************************************************************************
//
// File supervisor: Softimage 3D Games & 3D Bridge team
//
// (c) Copyright 2001-2002 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2002 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/


#ifndef	DOTXSI_60_DEFINED
#define	DOTXSI_60_DEFINED
#include "dotXSITemplate.h"
#include "dotXSITemplates3_5.h"
#include "dotXSITemplates3_6.h"
#include "dotXSITemplates5_0.h"


//***************************************************************************************
// Defines
//***************************************************************************************

#define XSI_IK_RESPLANE_TYPE			0
#define XSI_IK_RESPLANE_ROLL			1
#define XSI_IK_RESPLANE_PREFROTX_ROLL	2
#define XSI_IK_RESPLANE_UPX				3
#define XSI_IK_RESPLANE_UPY				4
#define XSI_IK_RESPLANE_UPZ				5
#define XSI_IK_RESPLANE_UPVCTRELROOT	6
#define XSI_IK_RESPLANE_PREFX			7
#define XSI_IK_RESPLANE_PREFY			8
#define XSI_IK_RESPLANE_PREFZ			9
#define XSI_IK_RESPLANE_PREFRELROOT		10
#define XSI_IK_RESPLANE_NUM_PARAMS		11

#define XSI_CAMERA_PRESET					0
#define XSI_CAMERA_PICTURE_RATIO			1
#define XSI_CAMERA_FIELD_OF_VIEW			2
#define XSI_CAMERA_FIELD_OF_VIEW_TYPE		3
#define XSI_CAMERA_PROJECTION_TYPE			4
#define XSI_CAMERA_ORTHO_HEIGHT				5
#define XSI_CAMERA_INTEREST_DISTANCE		6
#define XSI_CAMERA_NEAR_PLANE				7
#define XSI_CAMERA_FAR_PLANE				8
#define XSI_CAMERA_PROJ_PLANE_ENABLE		9
#define XSI_CAMERA_FILM_APERTURE_X			10
#define XSI_CAMERA_FILM_APERTURE_Y			11
#define XSI_CAMERA_OPTICAL_CENTER_SHIFT_X	12
#define XSI_CAMERA_OPTICAL_CENTER_SHIFT_Y	13
#define XSI_CAMERA_NUM_PARAMS				14

#define XSI_TRANSLATE_X						0
#define XSI_TRANSLATE_Y						1
#define XSI_TRANSLATE_Z						2
#define XSI_TRANSLATE_NUM_PARAMS			3

#define XSI_SCALE_X							0
#define XSI_SCALE_Y							1
#define XSI_SCALE_Z							2
#define XSI_SCALE_NUM_PARAMS				3

#define XSI_ROTATE_X						0
#define XSI_ROTATE_Y						1
#define XSI_ROTATE_Z						2
#define XSI_ROTATE_ANGLE					3
#define XSI_ROTATE_NUM_PARAMS				4

#define XSI_SHEAR_X1						0
#define XSI_SHEAR_Y1						1
#define XSI_SHEAR_Z1						2
#define XSI_SHEAR_X2						3
#define XSI_SHEAR_Y2						4
#define XSI_SHEAR_Z2						5
#define XSI_SHEAR_ANGLE						6
#define XSI_SHEAR_NUM_PARAMS				7

#define XSI_LOOKAT_PX						0
#define XSI_LOOKAT_PY						1
#define XSI_LOOKAT_PZ						2
#define XSI_LOOKAT_IX						3
#define XSI_LOOKAT_IY						4
#define XSI_LOOKAT_IZ						5
#define XSI_LOOKAT_UX						6
#define XSI_LOOKAT_UY						7
#define XSI_LOOKAT_UZ						8
#define XSI_LOOKAT_NUM_PARAMS				9

#define XSI_MATRIX_00						0
#define XSI_MATRIX_01						1
#define XSI_MATRIX_02						2
#define XSI_MATRIX_03						3
#define XSI_MATRIX_10						4
#define XSI_MATRIX_11						5
#define XSI_MATRIX_12						6
#define XSI_MATRIX_13						7
#define XSI_MATRIX_20						8
#define XSI_MATRIX_21						9
#define XSI_MATRIX_22						10
#define XSI_MATRIX_23						11
#define XSI_MATRIX_30						12
#define XSI_MATRIX_31						13
#define XSI_MATRIX_32						14
#define XSI_MATRIX_33						15
#define XSI_MATRIX_NUM_PARAMS				16


//***************************************************************************************
// Registration
//***************************************************************************************

extern	TemplateCreation	RegistrationTable60[];

/*! XSI_IK_ResolutionPlane template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_IK_ResolutionPlane template
*/
CdotXSITemplate*	Register_XSI_IK_ResolutionPlane();

/*! XSI_Camera template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_Camera template
*/
CdotXSITemplate*	Register_XSI_Camera();

/*! XSI Polymatricks template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_Polymatricks template
*/
CdotXSITemplate*	Register_XSI_Polymatricks();

/*! XSI translate template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_Translate template
*/
CdotXSITemplate*	Register_XSI_Translate();

/*! XSI Rotate template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_Rotate template
*/
CdotXSITemplate*	Register_XSI_Rotate();

/*! XSI Scale template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_Scale template
*/
CdotXSITemplate*	Register_XSI_Scale();

/*! XSI Shear template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_Shear template
*/
CdotXSITemplate*	Register_XSI_Shear();

/*! XSI Lookat template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_Lookat template
*/
CdotXSITemplate*	Register_XSI_Lookat();

/*! XSI Matrix template registration function
* \return CdotXSITemplate* an instance of CdotXSITemplate that supports the XSI_Matrix template
*/
CdotXSITemplate*	Register_XSI_Matrix();

#endif //DOTXSI_50_DEFINED
