#include "stdafx.h"
#include <PRT/SHFramework.h>

#include <tchar.h>
#include <stdlib.h>  
#include <crtdbg.h>


#include "../PRT/ObjLoader.h"


#define USE_KUGELN

void Dump()
{
#if defined(_DEBUG)
	//check allocation and set this value after program start into _crtBreakAlloc
	_CrtDumpMemoryLeaks();
	int hallo = 0; hallo += 1; 
#endif  
}   
 
int _tmain(int, _TCHAR*[])  
{
	atexit( Dump );  

	using namespace NSH; 

	NTransfer::STransferParameters transferParams;		  
	transferParams.bumpGranularity = true; 
	transferParams.bumpInterreflectionGranularity = true;
	transferParams.backlightingColour = Vec3(85.f/255.f, 255.f/255.f, 97.f/255.f);
	transferParams.transparencyShadowingFactor = 1.0f;
	transferParams.compressToByte = true;
	transferParams.rayCastingThreads = 1;
#if defined(_DEBUG)
	transferParams.sampleCountPerVertex = 100;
#else
	transferParams.sampleCountPerVertex = 2000;
#endif
#if defined(USE_KUGELN)
	transferParams.interreflectionDepth = 3;
	transferParams.supportTransparency = false; 
	transferParams.groundPlaneBlockValue = 1.0f;
#else
	transferParams.configType = NSH::NTransfer::TRANSFER_CONFIG_VEGETATION;
	transferParams.minDirectBumpCoeffVisibility = 0.23f;
	transferParams.interreflectionDepth = 0;
	transferParams.supportTransparency = true; 
	transferParams.groundPlaneBlockValue = 0.4f;
#endif

	NFramework::SFrameworkParameter frameworkParams;
	frameworkParams.sampleCount = 20000;
	frameworkParams.supportedBands = 4;
	frameworkParams.minSampleCountToRetrieve = transferParams.sampleCountPerVertex;
	NFramework::CSHFrameworkManager::Instance(frameworkParams);
 
	try  
	{ 
 
		static const uint32 scImageNum = 1;
		const char *pImageName[scImageNum] = 
		{
			"E:/Martin/MasterCD/Textures/HDR/grace_probe.hdr", 
/*			"E:/Martin/MasterCD/Textures/HDR/building_probe.hdr", 
			"E:/Martin/MasterCD/Textures/HDR/campus_probe.hdr",
			"E:/Martin/MasterCD/Textures/HDR/galileo_probe.hdr",
			"E:/Martin/MasterCD/Textures/HDR/grace_probe.hdr",
			"E:/Martin/MasterCD/Textures/HDR/kitchen_probe.hdr",
			"E:/Martin/MasterCD/Textures/HDR/rnl_probe.hdr",
			"E:/Martin/MasterCD/Textures/HDR/stpeters_probe.hdr",
			"E:/Martin/MasterCD/Textures/HDR/uffizi0_probe.hdr",
			"E:/Martin/MasterCD/Textures/HDR/uffizi_probe.hdr"
	*/	}; 
		for(int i=0; i<scImageNum; ++i)
			NFramework::ProjectSphericalEnvironmentMap(pImageName[i]);
/*

		NSH::TConstPCharVec objNames;	

#if defined(USE_KUGELN)
			objNames.push_back("E:/Martin/MasterCD/Objects/kugeln/kugel.OBJ");
//		objNames.push_back("E:/Martin/MasterCD/Objects/Green/g1.obj");

#else
//			objNames.push_back("E:/Martin/MasterCD/Objects/rainforesttree/canopy.OBJ");
//		objNames.push_back("E:/Martin/MasterCD/Objects/ancient_tree/ancient_tree_b.obj");
//		objNames.push_back("E:/Martin/MasterCD/Objects/ancient_tree_max/ancient_tree01_sh.obj");
		objNames.push_back("E:/Martin/MasterCD/Objects/jungle_tree_large/Jungle_Tree_Large_b.obj");
#endif


		TMatrix34Vec matrixVector;
		Matrix34 matrix;	matrix.SetIdentity();
		matrixVector.push_back(matrix);				
		//		matrix.SetTranslationMat(Vec3_tpl<float>(10.f,0.f,0.f));
		//		matrixVector.push_back(matrix);
		NFramework::ComputeMeshTransfer(objNames, matrixVector, transferParams, NFramework::COEFFICIENT_STORE_POLICY_OBJ);
*/
	}catch(const std::exception& rEx)
	{
		printf(rEx.what());
	}
	printf("\n");
	return 0;
}
