#include "stdafx.h"
#include "SupportFunctions.h"


#include <msi.h>
#include <stdio.h>
#include "ShellAPI.h"


//////////////////////////////////////////////////////////////////////////
LPSTR GetRegistryEntry(HKEY hKeyClass, LPCSTR lpszSubKey, LPCSTR lpszKey)
{
	//HKEY_LOCAL_MACHINE
	HKEY hKey;
	LONG lResult = RegOpenKeyEx( hKeyClass,lpszSubKey,0, KEY_READ, &hKey );
	if( ERROR_SUCCESS != lResult )
	{
		MessageBox(0,lpszSubKey,"Can't open key",MB_OK);
		return "";
	}

	TCHAR szValue[MAX_PATH];
	DWORD dSize = MAX_PATH;
	DWORD dType;
	lResult = RegQueryValueEx( hKey, lpszKey, NULL, &dType, (BYTE*)szValue, &dSize );
	if( ERROR_SUCCESS != lResult )
	{
		MessageBox(0,lpszKey,"Query refused",MB_OK);
		return "";
	}

	RegCloseKey(hKey);
	LPSTR szReturnValue = new TCHAR[dSize+1];
	memcpy(szReturnValue, szValue, dSize);
	szReturnValue[dSize] = 0;
	return szReturnValue;
}


//////////////////////////////////////////////////////////////////////////
char *GetMSIProductPath(const char *guid)
{
	static char buf[MAX_PATH], buf2[MAX_PATH];
	static int beenhere = 0;
	static HMODULE msilib = 0;
	static UINT (WINAPI *MsiSetInternalUI)(INSTALLUILEVEL, HWND*) =	0;
	static UINT (WINAPI *MsiEnumProducts)(DWORD, LPTSTR) = 0;
	static UINT (WINAPI *MsiGetProductInfo)(LPCTSTR, LPCTSTR, LPTSTR, DWORD*) = 0;

	//char guid[39];
	DWORD s;
	//MSIHANDLE h;

	if(!beenhere)
	{
		if(!(msilib = LoadLibraryEx("msi.dll", 0, 0)))
			return 0;

		MsiSetInternalUI = (UINT(WINAPI*)(INSTALLUILEVEL,HWND*))GetProcAddress(msilib, "MsiSetInternalUI");
		MsiEnumProducts = (UINT(WINAPI *)(DWORD,LPTSTR))GetProcAddress(msilib, "MsiEnumProductsA");
		MsiGetProductInfo = (UINT(WINAPI*)(LPCTSTR,LPCTSTR,LPTSTR,DWORD*))GetProcAddress(msilib, "MsiGetProductInfoA");

		if(!(MsiSetInternalUI && MsiEnumProducts && MsiGetProductInfo))
			return 0;

		/* suppress installer dialog boxes */
		MsiSetInternalUI(INSTALLUILEVEL_NONE, 0);

		beenhere = 1;
	}

	s = sizeof(buf);
	if(MsiGetProductInfo(guid, INSTALLPROPERTY_INSTALLLOCATION, buf,&s)!= ERROR_SUCCESS)
		return NULL;

	return buf;

	// enumerate installed products, get product key 
	/*for(i = 0; MsiEnumProducts(i, guid) == ERROR_SUCCESS; i++)
	{
		// get product name 
		s = sizeof(buf);
		if(MsiGetProductInfo(guid, INSTALLPROPERTY_PRODUCTNAME,	buf, &s) == ERROR_SUCCESS)
		{
			s = sizeof(buf);
			if(MsiGetProductInfo(guid, INSTALLPROPERTY_INSTALLLOCATION, buf,&s)!= ERROR_SUCCESS)
				return NULL;
		}
	}/**/

	return NULL;
}


//////////////////////////////////////////////////////////////////////////
LPSTR ConvertLPWSTRToLPSTR(LPWSTR lpwszStrIn)
{
	LPSTR pszOut = NULL;

	if (lpwszStrIn != NULL)
	{
		int nInputStrLen = int(wcslen (lpwszStrIn));

		// Double NULL Termination
		int nOutputStrLen = WideCharToMultiByte (CP_ACP, 0, lpwszStrIn, nInputStrLen, NULL, 0, 0, 0) + 2;
		pszOut = new char [nOutputStrLen];

		if (pszOut)
		{
			memset (pszOut, 0x00, nOutputStrLen);
			WideCharToMultiByte(CP_ACP, 0, lpwszStrIn, nInputStrLen, pszOut, nOutputStrLen, 0, 0);
		}
	}
	return pszOut;
}


//////////////////////////////////////////////////////////////////////////
string GetExtensionExecuterPath(LPCSTR extension)
{
	string testFileName = "C:\\check" + string(extension);
	LPCSTR lpTfn = testFileName.c_str();
	CHAR xxx[MAX_PATH];

	CreateFile(lpTfn,GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ,NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_HIDDEN,NULL);
	FindExecutableA(lpTfn,"",(LPSTR)&xxx);
	Sleep(50);
	DeleteFile(lpTfn);	

	return ExtractPath((LPSTR)&xxx);/**/

/*	string sRegistryPath = string(GetRegistryEntry(HKEY_CLASSES_ROOT, extension, "")) + "\\shell\\open\\command";
	string sCallCommand = GetRegistryEntry(HKEY_CLASSES_ROOT, sRegistryPath.c_str(), "");
	if (int(sCallCommand.find("\""))==0)
		sCallCommand = sCallCommand.substr(1);
	return ExtractPath(sCallCommand);/**/
}


//////////////////////////////////////////////////////////////////////////
string ExtractPath(const string &str)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char path[_MAX_PATH];
	_splitpath_s( str.c_str(), drive, _MAX_DRIVE, dir, _MAX_DIR, NULL, 0, NULL, 0);
	_makepath_s( path, _MAX_PATH, drive, dir, NULL, NULL);
	return string(path);
}


//////////////////////////////////////////////////////////////////////////
bool IsX86Path(const string &str)
{
	return int(str.find("(x86)"))>0;
}


//////////////////////////////////////////////////////////////////////////
bool DirectoryExists(const string &file)
{
	DWORD ret = GetFileAttributes(file.c_str());
	return ret != -1;
}


//////////////////////////////////////////////////////////////////////////
bool FileExists(const string &file)
{
	DWORD ret = GetFileAttributes(file.c_str());
	return ret != -1;
}


//////////////////////////////////////////////////////////////////////////
bool Is64BitWindows()
{
	LPFN_ISWOW64PROCESS fnIsWow64Process;
	BOOL bIsWow64 = FALSE;

	fnIsWow64Process = (LPFN_ISWOW64PROCESS)GetProcAddress(GetModuleHandle(TEXT("kernel32")),"IsWow64Process");

	if (NULL != fnIsWow64Process)
	{
		if (!fnIsWow64Process(GetCurrentProcess(),&bIsWow64))
			return FALSE;
	}
	return bIsWow64==TRUE;
}
