//////////////////////////////////////////////////////////////////////////
// ToolInstaller API
// Supports installation of all CryENGINE2 plugins to 3rd party programs
// and stores initial information to registry
//////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"


#include "SupportFunctions.h"
#include "ToolInstallerGUI.h"
#include "ResourceCompilerHelper.h"


//////////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain(HMODULE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}


//////////////////////////////////////////////////////////////////////////
STDAPI GetCrysisPath(WCHAR* lpszRootPath)
{
	//string path = GetRegistryEntry(HKEY_LOCAL_MACHINE, "SOFTWARE\\Autodesk\\3dsMax\\10.0\\MAX-1:409", "Installdir");

	char* res = GetMSIProductPath("{000E79B7-E725-4F01-870A-C12942B7F8E4}");
	if (res==NULL)
		return FALSE;

	string sRootPath = string(res);
	int len = (int)sRootPath.length();

	for(int i=0;i<len;i++)
		lpszRootPath[i] = sRootPath[i];
	lpszRootPath[len] = 0;

	if (len==0)
		return FALSE;
	return TRUE;
}


//////////////////////////////////////////////////////////////////////////
STDAPI IsCryEnginePath(WCHAR* lpszRootPath)
{
	string sRootPath = string(ConvertLPWSTRToLPSTR(lpszRootPath));

	if (FileExists(sRootPath + "\\Bin32\\Crysis.exe") ||
		FileExists(sRootPath + "\\Bin64\\Crysis.exe") ||
		FileExists(sRootPath + "\\Bin32\\Editor.exe") ||
		FileExists(sRootPath + "\\Bin64\\Editor.exe"))
	{
		return TRUE;
	}

	return FALSE;
}


//////////////////////////////////////////////////////////////////////////
STDAPI IsCrysisPath(WCHAR* lpszRootPath)
{
	return IsCryEnginePath(lpszRootPath);
}


//////////////////////////////////////////////////////////////////////////
STDAPI InstallTools(WCHAR* lpszRootPath)
{
	string sRootPath = string(ConvertLPWSTRToLPSTR(lpszRootPath));
	if (sRootPath.length()>0 && sRootPath[sRootPath.length()-1]!='\\')
		sRootPath += "\\";

	bool bWindowsIs64Bit = Is64BitWindows();

	// write basic registry entries for engine
	CResourceCompilerHelper rch;
	rch.RestoreDefaults();
	rch.SetRootPath(sRootPath.c_str());
	rch.StoreData();

	// extract 3DS Max information

	string sMaxPath = GetExtensionExecuterPath(".max");
	bool bHasMax = DirectoryExists(sMaxPath);
	string sMaxPlugins = "";
	string sMaxVersion = "Not Detected";

	if (bHasMax)
	{
		sMaxPlugins = sMaxPath + "plugins\\";
		bool bMaxIs64Bit = bWindowsIs64Bit && !IsX86Path(sMaxPath);
		bool isMax10 = int(sMaxPath.find("2008"))>0;
		bool isMax8 = !isMax10 && (int(sMaxPath.find("8"))>0);
		bool isMax9 = !isMax10 && !isMax9 && (int(sMaxPath.find("9"))>0);

		string sVersionNr = isMax8 ? "8" : (isMax9 ? "9" : (isMax10 ? "2008" : ""));
		if (sVersionNr!="")
			sMaxVersion = "3DSMax version " + sVersionNr + " " + (bMaxIs64Bit ? "64Bit" : "32Bit");
		else
			bHasMax = false;
	}


	// extract photoshop information

	string sPsdPath1 = GetExtensionExecuterPath(".psd");
	string sPsdPath2 = GetExtensionExecuterPath(".pdd");
	string sPsdPath3 = GetExtensionExecuterPath(".eps");
	string sPsdPath = sPsdPath1==sPsdPath2 ? sPsdPath1 : (sPsdPath2==sPsdPath3 ? sPsdPath2 : sPsdPath3);	
	if (sPsdPath=="")
		sPsdPath = sPsdPath1;

	bool bHasPsd = DirectoryExists(sPsdPath);
	string sPsdPlugins = "";
	string sPsdVersion = "Not Detected";

	if (bHasPsd)
	{
		sPsdPlugins = sPsdPath + "Plug-Ins\\File Format\\";
		bool bPsdIs64Bit = bWindowsIs64Bit && !IsX86Path(sPsdPath);
		if (!bPsdIs64Bit)
			sPsdVersion = string("Photoshop") + (int(sPsdPath.find("CS3"))>0 ? " CS3" : "");
		else
			bHasPsd = false;
	}


	// collect all possible plugins and meta-files

	std::map<string, string> mPluginToProgramVersion; // which plug-in suits to which program

	mPluginToProgramVersion["CryExport8.dlu"] = "3DSMax version 8 32Bit";
	mPluginToProgramVersion["CryExport9.dlu"] = "3DSMax version 9 32Bit";
	mPluginToProgramVersion["CryExport10.dlu"] = "3DSMax version 2008 32Bit";
	mPluginToProgramVersion["CryExport9_64.dlu"] = "3DSMax version 9 64Bit";
	mPluginToProgramVersion["CryExport10_64.dlu"] = "3DSMax version 2008 64Bit";

	mPluginToProgramVersion["PolyBumpPlugin8.dlu"] = "3DSMax version 8 32Bit";
	mPluginToProgramVersion["PolyBumpPlugin9.dlu"] = "3DSMax version 9 32Bit";
	mPluginToProgramVersion["PolyBumpPlugin10.dlu"] = "3DSMax version 2008 32Bit";
	mPluginToProgramVersion["PolyBumpPlugin9_64.dlu"] = "3DSMax version 9 64Bit";
	mPluginToProgramVersion["PolyBumpPlugin10_64.dlu"] = "3DSMax version 2008 64Bit";

	mPluginToProgramVersion["CryTIFPlugin.8bi"] = "Photoshop";
	mPluginToProgramVersion["CryTIFPlugin.8bi"] = "Photoshop CS3";

	std::map<string, std::vector<string>> mTypeToPlugin; // form groups of which only one plug-in must be found

	mTypeToPlugin["3DS Max Exporter"].push_back("CryExport8.dlu");
	mTypeToPlugin["3DS Max Exporter"].push_back("CryExport9.dlu");
	mTypeToPlugin["3DS Max Exporter"].push_back("CryExport10.dlu");
	mTypeToPlugin["3DS Max Exporter"].push_back("CryExport9_64.dlu");
	mTypeToPlugin["3DS Max Exporter"].push_back("CryExport10_64.dlu");

	mTypeToPlugin["Polybump Plugin"].push_back("PolyBumpPlugin8.dlu");
	mTypeToPlugin["Polybump Plugin"].push_back("PolyBumpPlugin9.dlu");
	mTypeToPlugin["Polybump Plugin"].push_back("PolyBumpPlugin9_64.dlu");
	mTypeToPlugin["Polybump Plugin"].push_back("PolyBumpPlugin10.dlu");
	mTypeToPlugin["Polybump Plugin"].push_back("PolyBumpPlugin10_64.dlu");

	mTypeToPlugin["Photoshop Plugin"].push_back("CryTIFPlugin.8bi");

	std::map<string, std::vector<string>> mPluginToMetafiles; // mention which plug-in needs which additional file sources

	mPluginToMetafiles["CryTIFPlugin.8bi"].push_back("Bin32\\jpeg62.dll");
	mPluginToMetafiles["CryTIFPlugin.8bi"].push_back("Bin32\\libtiff3.dll");
	mPluginToMetafiles["CryTIFPlugin.8bi"].push_back("Bin32\\zlib1.dll");

	mPluginToMetafiles["CryExport8.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");
	mPluginToMetafiles["CryExport9.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");
	mPluginToMetafiles["CryExport9_64.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");
	mPluginToMetafiles["CryExport10.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");
	mPluginToMetafiles["CryExport10_64.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");

	mPluginToMetafiles["PolyBumpPlugin8.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");
	mPluginToMetafiles["PolyBumpPlugin9.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");
	mPluginToMetafiles["PolyBumpPlugin8_64.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");
	mPluginToMetafiles["PolyBumpPlugin9_64.dlu"].push_back("Tools\\maxscript\\LoadCryTools.ms");

	std::map<string, string> mMetafileToDestination; // map meta file sources to destination files in program

	mMetafileToDestination["Bin32\\jpeg62.dll"] = "jpeg62.dll";
	mMetafileToDestination["Bin32\\libtiff3.dll"] = "libtiff3.dll";
	mMetafileToDestination["Bin32\\zlib1.dll"] = "zlib1.dll";

	mMetafileToDestination["Tools\\maxscript\\LoadCryTools.ms"] = "scripts\\startup\\LoadCryTools.ms";


	// setup list of available plug-ins

	std::vector<CToolInstallerGUI::SPlugin*> vPlugins;
	CToolInstallerGUI::SPlugin* p;

	// walk through all plug-in types	
	for (std::map<string, std::vector<string>>::iterator it=mTypeToPlugin.begin();it!=mTypeToPlugin.end();it++)
	{
		std::vector<string> &plugins = it->second;
		bool bPluginFound = false;
		bool bPluginLinked = false;

		for (unsigned int i=0;i<plugins.size();i++)
		{
			string sPluginName = plugins[i];
			string sPluginFile = sRootPath+"Tools\\"+sPluginName;

			// If plug-ins of a type are found
			if (FileExists(sPluginFile))
			{
				bPluginFound = true;

				p = new CToolInstallerGUI::SPlugin();
				p->name = it->first;
				p->fileName = sPluginName;
				p->pluginSourceUrl = sPluginFile;
				p->installable = true;

				// Mention the first one fitting to one of the found programs
				for (std::map<string, string>::iterator it2=mPluginToProgramVersion.begin();it2!=mPluginToProgramVersion.end();it2++)
				{
					p->target = it2->second;

					// check against 3DS Max
					if (it2->first==sPluginName && (bHasMax && it2->second==sMaxVersion))
					{
						p->pluginDestinationUrl = sMaxPlugins+sPluginName;
						p->targetUrl = sMaxPath; 

						vPlugins.push_back(p);
						bPluginLinked = true;
						break;
					}

					// check against Photoshop
					if (it2->first==sPluginName && (bHasPsd && it2->second==sPsdVersion))
					{
						p->pluginDestinationUrl = sPsdPlugins+sPluginName;
						p->targetUrl = sPsdPath; 

						vPlugins.push_back(p);
						bPluginLinked = true;
						break;
					}
				}

				if (!bPluginLinked)
				{
					delete p;
				}
			}
			if (bPluginLinked)
				break;
		}

		// If no plug-in fits, mark plug-in type integration as failed
		if (bPluginFound && !bPluginLinked)
		{
			p = new CToolInstallerGUI::SPlugin();
			p->name = it->first;
			p->installable = false;
			p->target = "[No suitable software detected]";
			vPlugins.push_back(p);
		}
	}


	// no installable plugins found?
	if (vPlugins.size()==0)
		return S_OK;


	// ask user to agree integration
	CToolInstallerGUI tig;
	if (IDOK==tig.ShowDialog(GetForegroundWindow(), vPlugins))
	{
		// integrate plugins and metadata
		for (unsigned int i=0;i<vPlugins.size();i++)
		{
			CToolInstallerGUI::SPlugin* pl = vPlugins[i];

			if (pl->installable)
			{
				CopyFile(pl->pluginSourceUrl.c_str(), pl->pluginDestinationUrl.c_str(), false);

				// move meta-files to their destination
				if (mPluginToMetafiles.find(pl->fileName)!=mPluginToMetafiles.end())
				{
					std::vector<string> &vMetaFiles = mPluginToMetafiles[pl->fileName];

					for (unsigned int j=0;j<vMetaFiles.size();j++)
					{
						string src = sRootPath+vMetaFiles[j];
						string dst = pl->targetUrl+mMetafileToDestination[vMetaFiles[j]];
						DeleteFile(dst.c_str());
						CopyFile(src.c_str(), dst.c_str(), false);
					}
				}
			}
		}		
	}

	return S_OK;
}


//////////////////////////////////////////////////////////////////////////
STDAPI Is64BitSystem()
{
	return Is64BitWindows() ? 1 : 0;
}
