#include "StdAfx.h"
#include "ToolInstallerGUI.h"


#define DLG_WIDTH		420
#define DLG_HEIGHT		102


static CToolInstallerGUI *g_pThis	= NULL;
static LRESULT g_hDialogResult		= 0;


//////////////////////////////////////////////////////////////////////////
LRESULT CToolInstallerGUI::ShowDialog( HWND hParent, std::vector<SPlugin*> &vPlugins)
{
	g_hDialogResult = 0;
	g_pThis = this;
	const char *szWindowClass = "TOOL_INSTALLER_UI";
	int iDynDlgHeight = DLG_HEIGHT + int(vPlugins.size()*19)-19;


	// Register the window class

	WNDCLASS wndClass = { 0, WndProc, 0, DLGWINDOWEXTRA, GetModuleHandle(0),
		NULL, LoadCursor( NULL, IDC_ARROW ), (HBRUSH)COLOR_BTNSHADOW, NULL, szWindowClass };

	RegisterClass(&wndClass);

	bool bReEnableParent = false;

	if(IsWindowEnabled(hParent))
	{
		bReEnableParent = true;
		EnableWindow(hParent, false);
	}


	// Create the window

	int cwX = CW_USEDEFAULT;
	int cwY = CW_USEDEFAULT;
	int cwW = DLG_WIDTH+2*GetSystemMetrics(SM_CYFIXEDFRAME);
	int cwH = iDynDlgHeight+2*GetSystemMetrics(SM_CYFIXEDFRAME)+GetSystemMetrics(SM_CYSMCAPTION);

	if (hParent!=NULL)
	{
		// center window over parent
		RECT rParentRect;
		GetWindowRect(hParent, &rParentRect);
		cwX = rParentRect.left + (rParentRect.right-rParentRect.left)/2 - cwW/2;
		cwY = rParentRect.top + (rParentRect.bottom-rParentRect.top)/2 - cwH/2;
	}

	HWND hDialogWnd = CreateWindowEx( WS_EX_TOOLWINDOW | WS_EX_CONTROLPARENT | WS_EX_TOPMOST, szWindowClass, "Plugin Integration", WS_BORDER | WS_CAPTION | WS_SYSMENU | WS_VISIBLE, 
		cwX, cwY, cwW, cwH,	0, NULL, GetModuleHandle(0), NULL);

	SetupDialogContent(hDialogWnd, vPlugins);


	// main loop

	MSG msg;
	while(!g_hDialogResult) 
	{
		GetMessage(&msg, NULL, 0, 0);

		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}


	// remove dialog

	DestroyWindow(hDialogWnd);
	UnregisterClass(szWindowClass,GetModuleHandle(0));

	if(bReEnableParent)
		EnableWindow(hParent, true);

	BringWindowToTop(hParent);

	g_pThis = NULL;

	return g_hDialogResult;
}


//////////////////////////////////////////////////////////////////////////
void CToolInstallerGUI::SetupDialogContent(HWND hDialogWnd, std::vector<SPlugin*> &vPlugins)
{
	HINSTANCE hInst = GetModuleHandle(0);
	HGDIOBJ hDlgFont = GetStockObject(DEFAULT_GUI_FONT);
	int iDynDlgHeight = DLG_HEIGHT + int(vPlugins.size()*19)-19;

	// table headers

	HWND hLbl1 = CreateWindow("STATIC","Available Plugins:", WS_CHILD | WS_VISIBLE | BS_FLAT,
		10, 10, 140, 16, hDialogWnd, 0, hInst, NULL);
	SendMessage(hLbl1, WM_SETFONT, (WPARAM)hDlgFont, FALSE);

	HWND hLbl2 = CreateWindow("STATIC","State:", WS_CHILD | WS_VISIBLE | BS_FLAT,
		150, 10, 90, 16, hDialogWnd, 0, hInst, NULL);
	SendMessage(hLbl2, WM_SETFONT, (WPARAM)hDlgFont, FALSE);

	HWND hLbl3 = CreateWindow("STATIC","Target Software:", WS_CHILD | WS_VISIBLE | BS_FLAT,
		240, 10, 170, 16, hDialogWnd, 0, hInst, NULL);
	SendMessage(hLbl3, WM_SETFONT, (WPARAM)hDlgFont, FALSE);

	HWND hGrp = CreateWindow("BUTTON","", WS_CHILD | WS_VISIBLE | BS_GROUPBOX,
		8,26,DLG_WIDTH-16,iDynDlgHeight-41-26, hDialogWnd,NULL, hInst, NULL);
	SendMessage(hGrp,WM_SETFONT,(WPARAM)hDlgFont,FALSE);


	// plug-in table

	int yOfs = 37;
	for (unsigned int i=0;i<vPlugins.size();i++)
	{
		SPlugin* p = vPlugins[i];

		HWND hLbl = CreateWindow("STATIC",p->name.c_str(), WS_CHILD | WS_VISIBLE | BS_FLAT,
			13, yOfs, 132, 17, hDialogWnd, 0, hInst, NULL);
		SendMessage(hLbl, WM_SETFONT, (WPARAM)hDlgFont, FALSE);

		HWND hLblSt = CreateWindow("STATIC",p->installable ? "Ready" : "Not Installable", WS_CHILD | WS_VISIBLE | BS_FLAT, 
			150, yOfs, 85, 17, hDialogWnd, 0, hInst, NULL);
		SendMessage(hLblSt, WM_SETFONT, (WPARAM)hDlgFont, FALSE);		
		
		HWND hEdt = CreateWindow("STATIC",p->target.c_str(), WS_CHILD | WS_VISIBLE | BS_FLAT,
			240, yOfs, 165, 17, hDialogWnd, 0, hInst, NULL);
		SendMessage(hEdt, WM_SETFONT, (WPARAM)hDlgFont, FALSE);

		yOfs += 20;
	}


	// std buttons

	HWND hBtnOK = CreateWindow("BUTTON","Integrate", WS_CHILD | BS_DEFPUSHBUTTON | WS_CHILD | WS_VISIBLE | ES_LEFT | WS_TABSTOP,
		DLG_WIDTH/2-85, iDynDlgHeight-32, 80, 22, hDialogWnd, (HMENU)IDOK, hInst, NULL);
	SendMessage(hBtnOK, WM_SETFONT, (WPARAM)hDlgFont, FALSE);

	HWND hBtnCancel = CreateWindow("BUTTON","Abort", WS_CHILD | WS_CHILD | WS_VISIBLE | ES_LEFT | WS_TABSTOP,
		DLG_WIDTH/2+5, iDynDlgHeight-32, 80, 22, hDialogWnd,( HMENU)IDCANCEL, hInst, NULL);
	SendMessage(hBtnCancel, WM_SETFONT, (WPARAM)hDlgFont, FALSE);


	SetFocus(hBtnOK);
}


//////////////////////////////////////////////////////////////////////////
LRESULT CToolInstallerGUI::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return g_pThis->HandleProc(hWnd, uMsg, wParam, lParam);
}


//////////////////////////////////////////////////////////////////////////
LRESULT CToolInstallerGUI::HandleProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_CREATE:
		break;

	case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
			case IDOK:
				g_hDialogResult = IDOK;
				break;

			case IDCANCEL:
				g_hDialogResult = IDCANCEL;
				break;
			}
			break;
		}

	case WM_CLOSE:
		g_hDialogResult = IDCLOSE;
		break;
	}

	return DefWindowProc( hWnd, uMsg, wParam, lParam );
}

